/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMaskingColumnRequest
extends BmcRequest<Void> {
    private String maskingPolicyId;
    private String maskingColumnKey;
    private String opcRequestId;

    public String getMaskingPolicyId() {
        return this.maskingPolicyId;
    }

    public String getMaskingColumnKey() {
        return this.maskingColumnKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().maskingPolicyId(this.maskingPolicyId).maskingColumnKey(this.maskingColumnKey).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maskingPolicyId=").append(String.valueOf(this.maskingPolicyId));
        sb.append(",maskingColumnKey=").append(String.valueOf(this.maskingColumnKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMaskingColumnRequest)) {
            return false;
        }
        GetMaskingColumnRequest other = (GetMaskingColumnRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maskingPolicyId, other.maskingPolicyId) && Objects.equals(this.maskingColumnKey, other.maskingColumnKey) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maskingPolicyId == null ? 43 : this.maskingPolicyId.hashCode());
        result = result * 59 + (this.maskingColumnKey == null ? 43 : this.maskingColumnKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMaskingColumnRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maskingPolicyId = null;
        private String maskingColumnKey = null;
        private String opcRequestId = null;

        public Builder maskingPolicyId(String maskingPolicyId) {
            this.maskingPolicyId = maskingPolicyId;
            return this;
        }

        public Builder maskingColumnKey(String maskingColumnKey) {
            this.maskingColumnKey = maskingColumnKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMaskingColumnRequest o) {
            this.maskingPolicyId(o.getMaskingPolicyId());
            this.maskingColumnKey(o.getMaskingColumnKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMaskingColumnRequest build() {
            GetMaskingColumnRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMaskingColumnRequest buildWithoutInvocationCallback() {
            GetMaskingColumnRequest request = new GetMaskingColumnRequest();
            request.maskingPolicyId = this.maskingPolicyId;
            request.maskingColumnKey = this.maskingColumnKey;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

