/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMaskingPolicyHealthReportRequest
extends BmcRequest<Void> {
    private String maskingPolicyHealthReportId;
    private String opcRequestId;

    public String getMaskingPolicyHealthReportId() {
        return this.maskingPolicyHealthReportId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().maskingPolicyHealthReportId(this.maskingPolicyHealthReportId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maskingPolicyHealthReportId=").append(String.valueOf(this.maskingPolicyHealthReportId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMaskingPolicyHealthReportRequest)) {
            return false;
        }
        GetMaskingPolicyHealthReportRequest other = (GetMaskingPolicyHealthReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maskingPolicyHealthReportId, other.maskingPolicyHealthReportId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maskingPolicyHealthReportId == null ? 43 : this.maskingPolicyHealthReportId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMaskingPolicyHealthReportRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maskingPolicyHealthReportId = null;
        private String opcRequestId = null;

        public Builder maskingPolicyHealthReportId(String maskingPolicyHealthReportId) {
            this.maskingPolicyHealthReportId = maskingPolicyHealthReportId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMaskingPolicyHealthReportRequest o) {
            this.maskingPolicyHealthReportId(o.getMaskingPolicyHealthReportId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMaskingPolicyHealthReportRequest build() {
            GetMaskingPolicyHealthReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMaskingPolicyHealthReportRequest buildWithoutInvocationCallback() {
            GetMaskingPolicyHealthReportRequest request = new GetMaskingPolicyHealthReportRequest();
            request.maskingPolicyHealthReportId = this.maskingPolicyHealthReportId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

