/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListDatabaseTableAccessEntriesRequest
extends BmcRequest<Void> {
    private String securityPolicyReportId;
    private Integer limit;
    private String page;
    private String scimQuery;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    public String getSecurityPolicyReportId() {
        return this.securityPolicyReportId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getScimQuery() {
        return this.scimQuery;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().securityPolicyReportId(this.securityPolicyReportId).limit(this.limit).page(this.page).scimQuery(this.scimQuery).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityPolicyReportId=").append(String.valueOf(this.securityPolicyReportId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",scimQuery=").append(String.valueOf(this.scimQuery));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDatabaseTableAccessEntriesRequest)) {
            return false;
        }
        ListDatabaseTableAccessEntriesRequest other = (ListDatabaseTableAccessEntriesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityPolicyReportId, other.securityPolicyReportId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.scimQuery, other.scimQuery) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityPolicyReportId == null ? 43 : this.securityPolicyReportId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.scimQuery == null ? 43 : this.scimQuery.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDatabaseTableAccessEntriesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityPolicyReportId = null;
        private Integer limit = null;
        private String page = null;
        private String scimQuery = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;

        public Builder securityPolicyReportId(String securityPolicyReportId) {
            this.securityPolicyReportId = securityPolicyReportId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder scimQuery(String scimQuery) {
            this.scimQuery = scimQuery;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDatabaseTableAccessEntriesRequest o) {
            this.securityPolicyReportId(o.getSecurityPolicyReportId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.scimQuery(o.getScimQuery());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDatabaseTableAccessEntriesRequest build() {
            ListDatabaseTableAccessEntriesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDatabaseTableAccessEntriesRequest buildWithoutInvocationCallback() {
            ListDatabaseTableAccessEntriesRequest request = new ListDatabaseTableAccessEntriesRequest();
            request.securityPolicyReportId = this.securityPolicyReportId;
            request.limit = this.limit;
            request.page = this.page;
            request.scimQuery = this.scimQuery;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Key("key"),
        Grantee("grantee"),
        AccessType("accessType"),
        TableSchema("tableSchema"),
        TableName("tableName"),
        PrivilegeType("privilegeType"),
        Privilege("privilege"),
        PrivilegeGrantable("privilegeGrantable"),
        GrantFromRole("grantFromRole"),
        AccessThroughObject("accessThroughObject"),
        ColumnName("columnName"),
        Grantor("grantor"),
        AreAllTablesAccessible("areAllTablesAccessible"),
        IsAccessConstrainedByView("isAccessConstrainedByView"),
        IsAccessConstrainedByLabelSecurity("isAccessConstrainedByLabelSecurity"),
        IsAccessConstrainedByDatabaseVault("isAccessConstrainedByDatabaseVault"),
        IsAccessConstrainedByVirtualPrivateDatabase("isAccessConstrainedByVirtualPrivateDatabase"),
        IsAccessConstrainedByRedaction("isAccessConstrainedByRedaction"),
        IsAccessConstrainedByRealApplicationSecurity("isAccessConstrainedByRealApplicationSecurity"),
        IsAccessConstrainedBySqlFirewall("isAccessConstrainedBySqlFirewall"),
        IsSensitive("isSensitive");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

