/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datasafe.model.SdmMaskingPolicyDifference;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListSdmMaskingPolicyDifferencesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Boolean compartmentIdInSubtree;
    private DifferenceAccessLevel differenceAccessLevel;
    private String displayName;
    private String sensitiveDataModelId;
    private SdmMaskingPolicyDifference.LifecycleState lifecycleState;
    private String maskingPolicyId;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;
    private Integer limit;
    private String page;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public DifferenceAccessLevel getDifferenceAccessLevel() {
        return this.differenceAccessLevel;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSensitiveDataModelId() {
        return this.sensitiveDataModelId;
    }

    public SdmMaskingPolicyDifference.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getMaskingPolicyId() {
        return this.maskingPolicyId;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).compartmentIdInSubtree(this.compartmentIdInSubtree).differenceAccessLevel(this.differenceAccessLevel).displayName(this.displayName).sensitiveDataModelId(this.sensitiveDataModelId).lifecycleState(this.lifecycleState).maskingPolicyId(this.maskingPolicyId).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",differenceAccessLevel=").append(String.valueOf((Object)this.differenceAccessLevel));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",sensitiveDataModelId=").append(String.valueOf(this.sensitiveDataModelId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",maskingPolicyId=").append(String.valueOf(this.maskingPolicyId));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSdmMaskingPolicyDifferencesRequest)) {
            return false;
        }
        ListSdmMaskingPolicyDifferencesRequest other = (ListSdmMaskingPolicyDifferencesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.differenceAccessLevel, (Object)other.differenceAccessLevel) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.sensitiveDataModelId, other.sensitiveDataModelId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.maskingPolicyId, other.maskingPolicyId) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.differenceAccessLevel == null ? 43 : this.differenceAccessLevel.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.sensitiveDataModelId == null ? 43 : this.sensitiveDataModelId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.maskingPolicyId == null ? 43 : this.maskingPolicyId.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSdmMaskingPolicyDifferencesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Boolean compartmentIdInSubtree = null;
        private DifferenceAccessLevel differenceAccessLevel = null;
        private String displayName = null;
        private String sensitiveDataModelId = null;
        private SdmMaskingPolicyDifference.LifecycleState lifecycleState = null;
        private String maskingPolicyId = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder differenceAccessLevel(DifferenceAccessLevel differenceAccessLevel) {
            this.differenceAccessLevel = differenceAccessLevel;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder sensitiveDataModelId(String sensitiveDataModelId) {
            this.sensitiveDataModelId = sensitiveDataModelId;
            return this;
        }

        public Builder lifecycleState(SdmMaskingPolicyDifference.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder maskingPolicyId(String maskingPolicyId) {
            this.maskingPolicyId = maskingPolicyId;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSdmMaskingPolicyDifferencesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.differenceAccessLevel(o.getDifferenceAccessLevel());
            this.displayName(o.getDisplayName());
            this.sensitiveDataModelId(o.getSensitiveDataModelId());
            this.lifecycleState(o.getLifecycleState());
            this.maskingPolicyId(o.getMaskingPolicyId());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSdmMaskingPolicyDifferencesRequest build() {
            ListSdmMaskingPolicyDifferencesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSdmMaskingPolicyDifferencesRequest buildWithoutInvocationCallback() {
            ListSdmMaskingPolicyDifferencesRequest request = new ListSdmMaskingPolicyDifferencesRequest();
            request.compartmentId = this.compartmentId;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.differenceAccessLevel = this.differenceAccessLevel;
            request.displayName = this.displayName;
            request.sensitiveDataModelId = this.sensitiveDataModelId;
            request.lifecycleState = this.lifecycleState;
            request.maskingPolicyId = this.maskingPolicyId;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreationStarted("timeCreationStarted"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DifferenceAccessLevel implements BmcEnum
    {
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, DifferenceAccessLevel> map;

        private DifferenceAccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DifferenceAccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DifferenceAccessLevel: " + key);
        }

        static {
            map = new HashMap<String, DifferenceAccessLevel>();
            for (DifferenceAccessLevel v : DifferenceAccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

