/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListSqlCollectionLogInsightsRequest
extends BmcRequest<Void> {
    private Date timeStarted;
    private Date timeEnded;
    private String sqlCollectionId;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private GroupBy groupBy;

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public String getSqlCollectionId() {
        return this.sqlCollectionId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public Builder toBuilder() {
        return new Builder().timeStarted(this.timeStarted).timeEnded(this.timeEnded).sqlCollectionId(this.sqlCollectionId).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).groupBy(this.groupBy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(",timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(",sqlCollectionId=").append(String.valueOf(this.sqlCollectionId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",groupBy=").append(String.valueOf((Object)this.groupBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSqlCollectionLogInsightsRequest)) {
            return false;
        }
        ListSqlCollectionLogInsightsRequest other = (ListSqlCollectionLogInsightsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.sqlCollectionId, other.sqlCollectionId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.groupBy, (Object)other.groupBy);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.sqlCollectionId == null ? 43 : this.sqlCollectionId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.groupBy == null ? 43 : this.groupBy.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSqlCollectionLogInsightsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private Date timeStarted = null;
        private Date timeEnded = null;
        private String sqlCollectionId = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private GroupBy groupBy = null;

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            return this;
        }

        public Builder sqlCollectionId(String sqlCollectionId) {
            this.sqlCollectionId = sqlCollectionId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder groupBy(GroupBy groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSqlCollectionLogInsightsRequest o) {
            this.timeStarted(o.getTimeStarted());
            this.timeEnded(o.getTimeEnded());
            this.sqlCollectionId(o.getSqlCollectionId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.groupBy(o.getGroupBy());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSqlCollectionLogInsightsRequest build() {
            ListSqlCollectionLogInsightsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSqlCollectionLogInsightsRequest buildWithoutInvocationCallback() {
            ListSqlCollectionLogInsightsRequest request = new ListSqlCollectionLogInsightsRequest();
            request.timeStarted = this.timeStarted;
            request.timeEnded = this.timeEnded;
            request.sqlCollectionId = this.sqlCollectionId;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.groupBy = this.groupBy;
            return request;
        }
    }

    public static enum GroupBy implements BmcEnum
    {
        ClientIp("clientIp"),
        ClientProgram("clientProgram"),
        ClientOsUserName("clientOsUserName");

        private final String value;
        private static Map<String, GroupBy> map;

        private GroupBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GroupBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid GroupBy: " + key);
        }

        static {
            map = new HashMap<String, GroupBy>();
            for (GroupBy v : GroupBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

