/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.UpdateReportDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateReportRequest
extends BmcRequest<UpdateReportDetails> {
    private String reportId;
    private UpdateReportDetails updateReportDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getReportId() {
        return this.reportId;
    }

    public UpdateReportDetails getUpdateReportDetails() {
        return this.updateReportDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public UpdateReportDetails getBody$() {
        return this.updateReportDetails;
    }

    public Builder toBuilder() {
        return new Builder().reportId(this.reportId).updateReportDetails(this.updateReportDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",reportId=").append(String.valueOf(this.reportId));
        sb.append(",updateReportDetails=").append(String.valueOf((Object)this.updateReportDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateReportRequest)) {
            return false;
        }
        UpdateReportRequest other = (UpdateReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.reportId, other.reportId) && Objects.equals((Object)this.updateReportDetails, (Object)other.updateReportDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.reportId == null ? 43 : this.reportId.hashCode());
        result = result * 59 + (this.updateReportDetails == null ? 43 : this.updateReportDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateReportRequest, UpdateReportDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String reportId = null;
        private UpdateReportDetails updateReportDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public Builder updateReportDetails(UpdateReportDetails updateReportDetails) {
            this.updateReportDetails = updateReportDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateReportRequest o) {
            this.reportId(o.getReportId());
            this.updateReportDetails(o.getUpdateReportDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateReportRequest build() {
            UpdateReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateReportDetails body) {
            this.updateReportDetails(body);
            return this;
        }

        public UpdateReportRequest buildWithoutInvocationCallback() {
            UpdateReportRequest request = new UpdateReportRequest();
            request.reportId = this.reportId;
            request.updateReportDetails = this.updateReportDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

