/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.AuditPolicyCategory;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AuditSpecification
extends ExplicitlySetBmcModel {
    @JsonProperty(value="auditPolicyName")
    private final String auditPolicyName;
    @JsonProperty(value="databasePolicyNames")
    private final List<String> databasePolicyNames;
    @JsonProperty(value="auditPolicyCategory")
    private final AuditPolicyCategory auditPolicyCategory;
    @JsonProperty(value="enableStatus")
    private final EnableStatus enableStatus;
    @JsonProperty(value="partiallyEnabledMsg")
    private final String partiallyEnabledMsg;
    @JsonProperty(value="isEnabledForAllUsers")
    private final Boolean isEnabledForAllUsers;
    @JsonProperty(value="isViewOnly")
    private final Boolean isViewOnly;
    @JsonProperty(value="isSeededInTarget")
    private final Boolean isSeededInTarget;
    @JsonProperty(value="isSeededInDataSafe")
    private final Boolean isSeededInDataSafe;
    @JsonProperty(value="isCreated")
    private final Boolean isCreated;
    @JsonProperty(value="enabledEntities")
    private final EnabledEntities enabledEntities;

    @Deprecated
    @ConstructorProperties(value={"auditPolicyName", "databasePolicyNames", "auditPolicyCategory", "enableStatus", "partiallyEnabledMsg", "isEnabledForAllUsers", "isViewOnly", "isSeededInTarget", "isSeededInDataSafe", "isCreated", "enabledEntities"})
    public AuditSpecification(String auditPolicyName, List<String> databasePolicyNames, AuditPolicyCategory auditPolicyCategory, EnableStatus enableStatus, String partiallyEnabledMsg, Boolean isEnabledForAllUsers, Boolean isViewOnly, Boolean isSeededInTarget, Boolean isSeededInDataSafe, Boolean isCreated, EnabledEntities enabledEntities) {
        this.auditPolicyName = auditPolicyName;
        this.databasePolicyNames = databasePolicyNames;
        this.auditPolicyCategory = auditPolicyCategory;
        this.enableStatus = enableStatus;
        this.partiallyEnabledMsg = partiallyEnabledMsg;
        this.isEnabledForAllUsers = isEnabledForAllUsers;
        this.isViewOnly = isViewOnly;
        this.isSeededInTarget = isSeededInTarget;
        this.isSeededInDataSafe = isSeededInDataSafe;
        this.isCreated = isCreated;
        this.enabledEntities = enabledEntities;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAuditPolicyName() {
        return this.auditPolicyName;
    }

    public List<String> getDatabasePolicyNames() {
        return this.databasePolicyNames;
    }

    public AuditPolicyCategory getAuditPolicyCategory() {
        return this.auditPolicyCategory;
    }

    public EnableStatus getEnableStatus() {
        return this.enableStatus;
    }

    public String getPartiallyEnabledMsg() {
        return this.partiallyEnabledMsg;
    }

    public Boolean getIsEnabledForAllUsers() {
        return this.isEnabledForAllUsers;
    }

    public Boolean getIsViewOnly() {
        return this.isViewOnly;
    }

    public Boolean getIsSeededInTarget() {
        return this.isSeededInTarget;
    }

    public Boolean getIsSeededInDataSafe() {
        return this.isSeededInDataSafe;
    }

    public Boolean getIsCreated() {
        return this.isCreated;
    }

    public EnabledEntities getEnabledEntities() {
        return this.enabledEntities;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AuditSpecification(");
        sb.append("super=").append(super.toString());
        sb.append("auditPolicyName=").append(String.valueOf(this.auditPolicyName));
        sb.append(", databasePolicyNames=").append(String.valueOf(this.databasePolicyNames));
        sb.append(", auditPolicyCategory=").append(String.valueOf((Object)this.auditPolicyCategory));
        sb.append(", enableStatus=").append(String.valueOf((Object)this.enableStatus));
        sb.append(", partiallyEnabledMsg=").append(String.valueOf(this.partiallyEnabledMsg));
        sb.append(", isEnabledForAllUsers=").append(String.valueOf(this.isEnabledForAllUsers));
        sb.append(", isViewOnly=").append(String.valueOf(this.isViewOnly));
        sb.append(", isSeededInTarget=").append(String.valueOf(this.isSeededInTarget));
        sb.append(", isSeededInDataSafe=").append(String.valueOf(this.isSeededInDataSafe));
        sb.append(", isCreated=").append(String.valueOf(this.isCreated));
        sb.append(", enabledEntities=").append(String.valueOf((Object)this.enabledEntities));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuditSpecification)) {
            return false;
        }
        AuditSpecification other = (AuditSpecification)((Object)o);
        return Objects.equals(this.auditPolicyName, other.auditPolicyName) && Objects.equals(this.databasePolicyNames, other.databasePolicyNames) && Objects.equals((Object)this.auditPolicyCategory, (Object)other.auditPolicyCategory) && Objects.equals((Object)this.enableStatus, (Object)other.enableStatus) && Objects.equals(this.partiallyEnabledMsg, other.partiallyEnabledMsg) && Objects.equals(this.isEnabledForAllUsers, other.isEnabledForAllUsers) && Objects.equals(this.isViewOnly, other.isViewOnly) && Objects.equals(this.isSeededInTarget, other.isSeededInTarget) && Objects.equals(this.isSeededInDataSafe, other.isSeededInDataSafe) && Objects.equals(this.isCreated, other.isCreated) && Objects.equals((Object)this.enabledEntities, (Object)other.enabledEntities) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.auditPolicyName == null ? 43 : this.auditPolicyName.hashCode());
        result = result * 59 + (this.databasePolicyNames == null ? 43 : this.databasePolicyNames.hashCode());
        result = result * 59 + (this.auditPolicyCategory == null ? 43 : this.auditPolicyCategory.hashCode());
        result = result * 59 + (this.enableStatus == null ? 43 : this.enableStatus.hashCode());
        result = result * 59 + (this.partiallyEnabledMsg == null ? 43 : this.partiallyEnabledMsg.hashCode());
        result = result * 59 + (this.isEnabledForAllUsers == null ? 43 : this.isEnabledForAllUsers.hashCode());
        result = result * 59 + (this.isViewOnly == null ? 43 : this.isViewOnly.hashCode());
        result = result * 59 + (this.isSeededInTarget == null ? 43 : this.isSeededInTarget.hashCode());
        result = result * 59 + (this.isSeededInDataSafe == null ? 43 : this.isSeededInDataSafe.hashCode());
        result = result * 59 + (this.isCreated == null ? 43 : this.isCreated.hashCode());
        result = result * 59 + (this.enabledEntities == null ? 43 : this.enabledEntities.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum EnabledEntities implements BmcEnum
    {
        AllUsers("ALL_USERS"),
        IncludeUsers("INCLUDE_USERS"),
        IncludeRoles("INCLUDE_ROLES"),
        ExcludeUsers("EXCLUDE_USERS"),
        IncludeUsersRoles("INCLUDE_USERS_ROLES"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EnabledEntities> map;

        private EnabledEntities(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EnabledEntities create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EnabledEntities', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EnabledEntities.class);
            map = new HashMap<String, EnabledEntities>();
            for (EnabledEntities v : EnabledEntities.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum EnableStatus implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        PartiallyEnabled("PARTIALLY_ENABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EnableStatus> map;

        private EnableStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EnableStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EnableStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EnableStatus.class);
            map = new HashMap<String, EnableStatus>();
            for (EnableStatus v : EnableStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="auditPolicyName")
        private String auditPolicyName;
        @JsonProperty(value="databasePolicyNames")
        private List<String> databasePolicyNames;
        @JsonProperty(value="auditPolicyCategory")
        private AuditPolicyCategory auditPolicyCategory;
        @JsonProperty(value="enableStatus")
        private EnableStatus enableStatus;
        @JsonProperty(value="partiallyEnabledMsg")
        private String partiallyEnabledMsg;
        @JsonProperty(value="isEnabledForAllUsers")
        private Boolean isEnabledForAllUsers;
        @JsonProperty(value="isViewOnly")
        private Boolean isViewOnly;
        @JsonProperty(value="isSeededInTarget")
        private Boolean isSeededInTarget;
        @JsonProperty(value="isSeededInDataSafe")
        private Boolean isSeededInDataSafe;
        @JsonProperty(value="isCreated")
        private Boolean isCreated;
        @JsonProperty(value="enabledEntities")
        private EnabledEntities enabledEntities;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder auditPolicyName(String auditPolicyName) {
            this.auditPolicyName = auditPolicyName;
            this.__explicitlySet__.add("auditPolicyName");
            return this;
        }

        public Builder databasePolicyNames(List<String> databasePolicyNames) {
            this.databasePolicyNames = databasePolicyNames;
            this.__explicitlySet__.add("databasePolicyNames");
            return this;
        }

        public Builder auditPolicyCategory(AuditPolicyCategory auditPolicyCategory) {
            this.auditPolicyCategory = auditPolicyCategory;
            this.__explicitlySet__.add("auditPolicyCategory");
            return this;
        }

        public Builder enableStatus(EnableStatus enableStatus) {
            this.enableStatus = enableStatus;
            this.__explicitlySet__.add("enableStatus");
            return this;
        }

        public Builder partiallyEnabledMsg(String partiallyEnabledMsg) {
            this.partiallyEnabledMsg = partiallyEnabledMsg;
            this.__explicitlySet__.add("partiallyEnabledMsg");
            return this;
        }

        public Builder isEnabledForAllUsers(Boolean isEnabledForAllUsers) {
            this.isEnabledForAllUsers = isEnabledForAllUsers;
            this.__explicitlySet__.add("isEnabledForAllUsers");
            return this;
        }

        public Builder isViewOnly(Boolean isViewOnly) {
            this.isViewOnly = isViewOnly;
            this.__explicitlySet__.add("isViewOnly");
            return this;
        }

        public Builder isSeededInTarget(Boolean isSeededInTarget) {
            this.isSeededInTarget = isSeededInTarget;
            this.__explicitlySet__.add("isSeededInTarget");
            return this;
        }

        public Builder isSeededInDataSafe(Boolean isSeededInDataSafe) {
            this.isSeededInDataSafe = isSeededInDataSafe;
            this.__explicitlySet__.add("isSeededInDataSafe");
            return this;
        }

        public Builder isCreated(Boolean isCreated) {
            this.isCreated = isCreated;
            this.__explicitlySet__.add("isCreated");
            return this;
        }

        public Builder enabledEntities(EnabledEntities enabledEntities) {
            this.enabledEntities = enabledEntities;
            this.__explicitlySet__.add("enabledEntities");
            return this;
        }

        public AuditSpecification build() {
            AuditSpecification model = new AuditSpecification(this.auditPolicyName, this.databasePolicyNames, this.auditPolicyCategory, this.enableStatus, this.partiallyEnabledMsg, this.isEnabledForAllUsers, this.isViewOnly, this.isSeededInTarget, this.isSeededInDataSafe, this.isCreated, this.enabledEntities);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AuditSpecification model) {
            if (model.wasPropertyExplicitlySet("auditPolicyName")) {
                this.auditPolicyName(model.getAuditPolicyName());
            }
            if (model.wasPropertyExplicitlySet("databasePolicyNames")) {
                this.databasePolicyNames(model.getDatabasePolicyNames());
            }
            if (model.wasPropertyExplicitlySet("auditPolicyCategory")) {
                this.auditPolicyCategory(model.getAuditPolicyCategory());
            }
            if (model.wasPropertyExplicitlySet("enableStatus")) {
                this.enableStatus(model.getEnableStatus());
            }
            if (model.wasPropertyExplicitlySet("partiallyEnabledMsg")) {
                this.partiallyEnabledMsg(model.getPartiallyEnabledMsg());
            }
            if (model.wasPropertyExplicitlySet("isEnabledForAllUsers")) {
                this.isEnabledForAllUsers(model.getIsEnabledForAllUsers());
            }
            if (model.wasPropertyExplicitlySet("isViewOnly")) {
                this.isViewOnly(model.getIsViewOnly());
            }
            if (model.wasPropertyExplicitlySet("isSeededInTarget")) {
                this.isSeededInTarget(model.getIsSeededInTarget());
            }
            if (model.wasPropertyExplicitlySet("isSeededInDataSafe")) {
                this.isSeededInDataSafe(model.getIsSeededInDataSafe());
            }
            if (model.wasPropertyExplicitlySet("isCreated")) {
                this.isCreated(model.getIsCreated());
            }
            if (model.wasPropertyExplicitlySet("enabledEntities")) {
                this.enabledEntities(model.getEnabledEntities());
            }
            return this;
        }
    }
}

