/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Column
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="fieldName")
    private final String fieldName;
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="isHidden")
    private final Boolean isHidden;
    @JsonProperty(value="displayOrder")
    private final Integer displayOrder;

    @Deprecated
    @ConstructorProperties(value={"displayName", "fieldName", "dataType", "isHidden", "displayOrder"})
    public Column(String displayName, String fieldName, String dataType, Boolean isHidden, Integer displayOrder) {
        this.displayName = displayName;
        this.fieldName = fieldName;
        this.dataType = dataType;
        this.isHidden = isHidden;
        this.displayOrder = displayOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Column(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", fieldName=").append(String.valueOf(this.fieldName));
        sb.append(", dataType=").append(String.valueOf(this.dataType));
        sb.append(", isHidden=").append(String.valueOf(this.isHidden));
        sb.append(", displayOrder=").append(String.valueOf(this.displayOrder));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.dataType, other.dataType) && Objects.equals(this.isHidden, other.isHidden) && Objects.equals(this.displayOrder, other.displayOrder) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.fieldName == null ? 43 : this.fieldName.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.isHidden == null ? 43 : this.isHidden.hashCode());
        result = result * 59 + (this.displayOrder == null ? 43 : this.displayOrder.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="fieldName")
        private String fieldName;
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="displayOrder")
        private Integer displayOrder;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            this.__explicitlySet__.add("fieldName");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            this.__explicitlySet__.add("displayOrder");
            return this;
        }

        public Column build() {
            Column model = new Column(this.displayName, this.fieldName, this.dataType, this.isHidden, this.displayOrder);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Column model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("fieldName")) {
                this.fieldName(model.getFieldName());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("displayOrder")) {
                this.displayOrder(model.getDisplayOrder());
            }
            return this;
        }
    }
}

