/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Dimensions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="sensitiveDataModelId")
    private final String sensitiveDataModelId;
    @JsonProperty(value="sensitiveTypeId")
    private final String sensitiveTypeId;

    @Deprecated
    @ConstructorProperties(value={"targetId", "sensitiveDataModelId", "sensitiveTypeId"})
    public Dimensions(String targetId, String sensitiveDataModelId, String sensitiveTypeId) {
        this.targetId = targetId;
        this.sensitiveDataModelId = sensitiveDataModelId;
        this.sensitiveTypeId = sensitiveTypeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getSensitiveDataModelId() {
        return this.sensitiveDataModelId;
    }

    public String getSensitiveTypeId() {
        return this.sensitiveTypeId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Dimensions(");
        sb.append("super=").append(super.toString());
        sb.append("targetId=").append(String.valueOf(this.targetId));
        sb.append(", sensitiveDataModelId=").append(String.valueOf(this.sensitiveDataModelId));
        sb.append(", sensitiveTypeId=").append(String.valueOf(this.sensitiveTypeId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dimensions)) {
            return false;
        }
        Dimensions other = (Dimensions)((Object)o);
        return Objects.equals(this.targetId, other.targetId) && Objects.equals(this.sensitiveDataModelId, other.sensitiveDataModelId) && Objects.equals(this.sensitiveTypeId, other.sensitiveTypeId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.sensitiveDataModelId == null ? 43 : this.sensitiveDataModelId.hashCode());
        result = result * 59 + (this.sensitiveTypeId == null ? 43 : this.sensitiveTypeId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="sensitiveDataModelId")
        private String sensitiveDataModelId;
        @JsonProperty(value="sensitiveTypeId")
        private String sensitiveTypeId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder sensitiveDataModelId(String sensitiveDataModelId) {
            this.sensitiveDataModelId = sensitiveDataModelId;
            this.__explicitlySet__.add("sensitiveDataModelId");
            return this;
        }

        public Builder sensitiveTypeId(String sensitiveTypeId) {
            this.sensitiveTypeId = sensitiveTypeId;
            this.__explicitlySet__.add("sensitiveTypeId");
            return this;
        }

        public Dimensions build() {
            Dimensions model = new Dimensions(this.targetId, this.sensitiveDataModelId, this.sensitiveTypeId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Dimensions model) {
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("sensitiveDataModelId")) {
                this.sensitiveDataModelId(model.getSensitiveDataModelId());
            }
            if (model.wasPropertyExplicitlySet("sensitiveTypeId")) {
                this.sensitiveTypeId(model.getSensitiveTypeId());
            }
            return this;
        }
    }
}

