/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.FindingLifecycleState;
import com.oracle.bmc.datasafe.model.References;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Finding
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="severity")
    private final Severity severity;
    @JsonProperty(value="assessmentId")
    private final String assessmentId;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="title")
    private final String title;
    @JsonProperty(value="remarks")
    private final String remarks;
    @JsonProperty(value="details")
    private final Object details;
    @JsonProperty(value="summary")
    private final String summary;
    @JsonProperty(value="references")
    private final References references;
    @JsonProperty(value="oracleDefinedSeverity")
    private final Severity oracleDefinedSeverity;
    @JsonProperty(value="isRiskModified")
    private final Boolean isRiskModified;
    @JsonProperty(value="hasTargetDbRiskLevelChanged")
    private final Boolean hasTargetDbRiskLevelChanged;
    @JsonProperty(value="justification")
    private final String justification;
    @JsonProperty(value="timeValidUntil")
    private final Date timeValidUntil;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final FindingLifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;

    @Deprecated
    @ConstructorProperties(value={"key", "severity", "assessmentId", "targetId", "title", "remarks", "details", "summary", "references", "oracleDefinedSeverity", "isRiskModified", "hasTargetDbRiskLevelChanged", "justification", "timeValidUntil", "timeUpdated", "lifecycleState", "lifecycleDetails"})
    public Finding(String key, Severity severity, String assessmentId, String targetId, String title, String remarks, Object details, String summary, References references, Severity oracleDefinedSeverity, Boolean isRiskModified, Boolean hasTargetDbRiskLevelChanged, String justification, Date timeValidUntil, Date timeUpdated, FindingLifecycleState lifecycleState, String lifecycleDetails) {
        this.key = key;
        this.severity = severity;
        this.assessmentId = assessmentId;
        this.targetId = targetId;
        this.title = title;
        this.remarks = remarks;
        this.details = details;
        this.summary = summary;
        this.references = references;
        this.oracleDefinedSeverity = oracleDefinedSeverity;
        this.isRiskModified = isRiskModified;
        this.hasTargetDbRiskLevelChanged = hasTargetDbRiskLevelChanged;
        this.justification = justification;
        this.timeValidUntil = timeValidUntil;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getAssessmentId() {
        return this.assessmentId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public Object getDetails() {
        return this.details;
    }

    public String getSummary() {
        return this.summary;
    }

    public References getReferences() {
        return this.references;
    }

    public Severity getOracleDefinedSeverity() {
        return this.oracleDefinedSeverity;
    }

    public Boolean getIsRiskModified() {
        return this.isRiskModified;
    }

    public Boolean getHasTargetDbRiskLevelChanged() {
        return this.hasTargetDbRiskLevelChanged;
    }

    public String getJustification() {
        return this.justification;
    }

    public Date getTimeValidUntil() {
        return this.timeValidUntil;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public FindingLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Finding(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", assessmentId=").append(String.valueOf(this.assessmentId));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", title=").append(String.valueOf(this.title));
        sb.append(", remarks=").append(String.valueOf(this.remarks));
        sb.append(", details=").append(String.valueOf(this.details));
        sb.append(", summary=").append(String.valueOf(this.summary));
        sb.append(", references=").append(String.valueOf((Object)this.references));
        sb.append(", oracleDefinedSeverity=").append(String.valueOf((Object)this.oracleDefinedSeverity));
        sb.append(", isRiskModified=").append(String.valueOf(this.isRiskModified));
        sb.append(", hasTargetDbRiskLevelChanged=").append(String.valueOf(this.hasTargetDbRiskLevelChanged));
        sb.append(", justification=").append(String.valueOf(this.justification));
        sb.append(", timeValidUntil=").append(String.valueOf(this.timeValidUntil));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Finding)) {
            return false;
        }
        Finding other = (Finding)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.assessmentId, other.assessmentId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.title, other.title) && Objects.equals(this.remarks, other.remarks) && Objects.equals(this.details, other.details) && Objects.equals(this.summary, other.summary) && Objects.equals((Object)this.references, (Object)other.references) && Objects.equals((Object)this.oracleDefinedSeverity, (Object)other.oracleDefinedSeverity) && Objects.equals(this.isRiskModified, other.isRiskModified) && Objects.equals(this.hasTargetDbRiskLevelChanged, other.hasTargetDbRiskLevelChanged) && Objects.equals(this.justification, other.justification) && Objects.equals(this.timeValidUntil, other.timeValidUntil) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.assessmentId == null ? 43 : this.assessmentId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.title == null ? 43 : this.title.hashCode());
        result = result * 59 + (this.remarks == null ? 43 : this.remarks.hashCode());
        result = result * 59 + (this.details == null ? 43 : this.details.hashCode());
        result = result * 59 + (this.summary == null ? 43 : this.summary.hashCode());
        result = result * 59 + (this.references == null ? 43 : this.references.hashCode());
        result = result * 59 + (this.oracleDefinedSeverity == null ? 43 : this.oracleDefinedSeverity.hashCode());
        result = result * 59 + (this.isRiskModified == null ? 43 : this.isRiskModified.hashCode());
        result = result * 59 + (this.hasTargetDbRiskLevelChanged == null ? 43 : this.hasTargetDbRiskLevelChanged.hashCode());
        result = result * 59 + (this.justification == null ? 43 : this.justification.hashCode());
        result = result * 59 + (this.timeValidUntil == null ? 43 : this.timeValidUntil.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Severity implements BmcEnum
    {
        High("HIGH"),
        Medium("MEDIUM"),
        Low("LOW"),
        Evaluate("EVALUATE"),
        Advisory("ADVISORY"),
        Pass("PASS"),
        Deferred("DEFERRED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Severity> map;

        private Severity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Severity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Severity', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Severity.class);
            map = new HashMap<String, Severity>();
            for (Severity v : Severity.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="severity")
        private Severity severity;
        @JsonProperty(value="assessmentId")
        private String assessmentId;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="remarks")
        private String remarks;
        @JsonProperty(value="details")
        private Object details;
        @JsonProperty(value="summary")
        private String summary;
        @JsonProperty(value="references")
        private References references;
        @JsonProperty(value="oracleDefinedSeverity")
        private Severity oracleDefinedSeverity;
        @JsonProperty(value="isRiskModified")
        private Boolean isRiskModified;
        @JsonProperty(value="hasTargetDbRiskLevelChanged")
        private Boolean hasTargetDbRiskLevelChanged;
        @JsonProperty(value="justification")
        private String justification;
        @JsonProperty(value="timeValidUntil")
        private Date timeValidUntil;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private FindingLifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            this.__explicitlySet__.add("assessmentId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.__explicitlySet__.add("title");
            return this;
        }

        public Builder remarks(String remarks) {
            this.remarks = remarks;
            this.__explicitlySet__.add("remarks");
            return this;
        }

        public Builder details(Object details) {
            this.details = details;
            this.__explicitlySet__.add("details");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public Builder references(References references) {
            this.references = references;
            this.__explicitlySet__.add("references");
            return this;
        }

        public Builder oracleDefinedSeverity(Severity oracleDefinedSeverity) {
            this.oracleDefinedSeverity = oracleDefinedSeverity;
            this.__explicitlySet__.add("oracleDefinedSeverity");
            return this;
        }

        public Builder isRiskModified(Boolean isRiskModified) {
            this.isRiskModified = isRiskModified;
            this.__explicitlySet__.add("isRiskModified");
            return this;
        }

        public Builder hasTargetDbRiskLevelChanged(Boolean hasTargetDbRiskLevelChanged) {
            this.hasTargetDbRiskLevelChanged = hasTargetDbRiskLevelChanged;
            this.__explicitlySet__.add("hasTargetDbRiskLevelChanged");
            return this;
        }

        public Builder justification(String justification) {
            this.justification = justification;
            this.__explicitlySet__.add("justification");
            return this;
        }

        public Builder timeValidUntil(Date timeValidUntil) {
            this.timeValidUntil = timeValidUntil;
            this.__explicitlySet__.add("timeValidUntil");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(FindingLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Finding build() {
            Finding model = new Finding(this.key, this.severity, this.assessmentId, this.targetId, this.title, this.remarks, this.details, this.summary, this.references, this.oracleDefinedSeverity, this.isRiskModified, this.hasTargetDbRiskLevelChanged, this.justification, this.timeValidUntil, this.timeUpdated, this.lifecycleState, this.lifecycleDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Finding model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("assessmentId")) {
                this.assessmentId(model.getAssessmentId());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("title")) {
                this.title(model.getTitle());
            }
            if (model.wasPropertyExplicitlySet("remarks")) {
                this.remarks(model.getRemarks());
            }
            if (model.wasPropertyExplicitlySet("details")) {
                this.details(model.getDetails());
            }
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            if (model.wasPropertyExplicitlySet("references")) {
                this.references(model.getReferences());
            }
            if (model.wasPropertyExplicitlySet("oracleDefinedSeverity")) {
                this.oracleDefinedSeverity(model.getOracleDefinedSeverity());
            }
            if (model.wasPropertyExplicitlySet("isRiskModified")) {
                this.isRiskModified(model.getIsRiskModified());
            }
            if (model.wasPropertyExplicitlySet("hasTargetDbRiskLevelChanged")) {
                this.hasTargetDbRiskLevelChanged(model.getHasTargetDbRiskLevelChanged());
            }
            if (model.wasPropertyExplicitlySet("justification")) {
                this.justification(model.getJustification());
            }
            if (model.wasPropertyExplicitlySet("timeValidUntil")) {
                this.timeValidUntil(model.getTimeValidUntil());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            return this;
        }
    }
}

