/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FindingAnalyticsDimensions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="topFindingCategory")
    private final String topFindingCategory;
    @JsonProperty(value="title")
    private final String title;
    @JsonProperty(value="topFindingStatus")
    private final TopFindingStatus topFindingStatus;
    @JsonProperty(value="severity")
    private final Severity severity;
    @JsonProperty(value="targetId")
    private final String targetId;

    @Deprecated
    @ConstructorProperties(value={"key", "topFindingCategory", "title", "topFindingStatus", "severity", "targetId"})
    public FindingAnalyticsDimensions(String key, String topFindingCategory, String title, TopFindingStatus topFindingStatus, Severity severity, String targetId) {
        this.key = key;
        this.topFindingCategory = topFindingCategory;
        this.title = title;
        this.topFindingStatus = topFindingStatus;
        this.severity = severity;
        this.targetId = targetId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getTopFindingCategory() {
        return this.topFindingCategory;
    }

    public String getTitle() {
        return this.title;
    }

    public TopFindingStatus getTopFindingStatus() {
        return this.topFindingStatus;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FindingAnalyticsDimensions(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", topFindingCategory=").append(String.valueOf(this.topFindingCategory));
        sb.append(", title=").append(String.valueOf(this.title));
        sb.append(", topFindingStatus=").append(String.valueOf((Object)this.topFindingStatus));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FindingAnalyticsDimensions)) {
            return false;
        }
        FindingAnalyticsDimensions other = (FindingAnalyticsDimensions)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.topFindingCategory, other.topFindingCategory) && Objects.equals(this.title, other.title) && Objects.equals((Object)this.topFindingStatus, (Object)other.topFindingStatus) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.targetId, other.targetId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.topFindingCategory == null ? 43 : this.topFindingCategory.hashCode());
        result = result * 59 + (this.title == null ? 43 : this.title.hashCode());
        result = result * 59 + (this.topFindingStatus == null ? 43 : this.topFindingStatus.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Severity implements BmcEnum
    {
        High("HIGH"),
        Medium("MEDIUM"),
        Low("LOW"),
        Evaluate("EVALUATE"),
        Advisory("ADVISORY"),
        Pass("PASS"),
        Deferred("DEFERRED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Severity> map;

        private Severity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Severity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Severity', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Severity.class);
            map = new HashMap<String, Severity>();
            for (Severity v : Severity.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TopFindingStatus implements BmcEnum
    {
        Risk("RISK"),
        Evaluate("EVALUATE"),
        Advisory("ADVISORY"),
        Pass("PASS"),
        Deferred("DEFERRED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TopFindingStatus> map;

        private TopFindingStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TopFindingStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TopFindingStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TopFindingStatus.class);
            map = new HashMap<String, TopFindingStatus>();
            for (TopFindingStatus v : TopFindingStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="topFindingCategory")
        private String topFindingCategory;
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="topFindingStatus")
        private TopFindingStatus topFindingStatus;
        @JsonProperty(value="severity")
        private Severity severity;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder topFindingCategory(String topFindingCategory) {
            this.topFindingCategory = topFindingCategory;
            this.__explicitlySet__.add("topFindingCategory");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.__explicitlySet__.add("title");
            return this;
        }

        public Builder topFindingStatus(TopFindingStatus topFindingStatus) {
            this.topFindingStatus = topFindingStatus;
            this.__explicitlySet__.add("topFindingStatus");
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public FindingAnalyticsDimensions build() {
            FindingAnalyticsDimensions model = new FindingAnalyticsDimensions(this.key, this.topFindingCategory, this.title, this.topFindingStatus, this.severity, this.targetId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FindingAnalyticsDimensions model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("topFindingCategory")) {
                this.topFindingCategory(model.getTopFindingCategory());
            }
            if (model.wasPropertyExplicitlySet("title")) {
                this.title(model.getTitle());
            }
            if (model.wasPropertyExplicitlySet("topFindingStatus")) {
                this.topFindingStatus(model.getTopFindingStatus());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            return this;
        }
    }
}

