/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.Finding;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FindingsChangeAuditLogSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="findingKey")
    private final String findingKey;
    @JsonProperty(value="findingTitle")
    private final String findingTitle;
    @JsonProperty(value="assessmentId")
    private final String assessmentId;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="severity")
    private final Finding.Severity severity;
    @JsonProperty(value="oracleDefinedSeverity")
    private final Finding.Severity oracleDefinedSeverity;
    @JsonProperty(value="isRiskDeferred")
    private final Boolean isRiskDeferred;
    @JsonProperty(value="previousSeverity")
    private final Finding.Severity previousSeverity;
    @JsonProperty(value="justification")
    private final String justification;
    @JsonProperty(value="timeValidUntil")
    private final Date timeValidUntil;
    @JsonProperty(value="modifiedBy")
    private final String modifiedBy;

    @Deprecated
    @ConstructorProperties(value={"key", "findingKey", "findingTitle", "assessmentId", "targetId", "timeUpdated", "severity", "oracleDefinedSeverity", "isRiskDeferred", "previousSeverity", "justification", "timeValidUntil", "modifiedBy"})
    public FindingsChangeAuditLogSummary(String key, String findingKey, String findingTitle, String assessmentId, String targetId, Date timeUpdated, Finding.Severity severity, Finding.Severity oracleDefinedSeverity, Boolean isRiskDeferred, Finding.Severity previousSeverity, String justification, Date timeValidUntil, String modifiedBy) {
        this.key = key;
        this.findingKey = findingKey;
        this.findingTitle = findingTitle;
        this.assessmentId = assessmentId;
        this.targetId = targetId;
        this.timeUpdated = timeUpdated;
        this.severity = severity;
        this.oracleDefinedSeverity = oracleDefinedSeverity;
        this.isRiskDeferred = isRiskDeferred;
        this.previousSeverity = previousSeverity;
        this.justification = justification;
        this.timeValidUntil = timeValidUntil;
        this.modifiedBy = modifiedBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getFindingKey() {
        return this.findingKey;
    }

    public String getFindingTitle() {
        return this.findingTitle;
    }

    public String getAssessmentId() {
        return this.assessmentId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Finding.Severity getSeverity() {
        return this.severity;
    }

    public Finding.Severity getOracleDefinedSeverity() {
        return this.oracleDefinedSeverity;
    }

    public Boolean getIsRiskDeferred() {
        return this.isRiskDeferred;
    }

    public Finding.Severity getPreviousSeverity() {
        return this.previousSeverity;
    }

    public String getJustification() {
        return this.justification;
    }

    public Date getTimeValidUntil() {
        return this.timeValidUntil;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FindingsChangeAuditLogSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", findingKey=").append(String.valueOf(this.findingKey));
        sb.append(", findingTitle=").append(String.valueOf(this.findingTitle));
        sb.append(", assessmentId=").append(String.valueOf(this.assessmentId));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", oracleDefinedSeverity=").append(String.valueOf((Object)this.oracleDefinedSeverity));
        sb.append(", isRiskDeferred=").append(String.valueOf(this.isRiskDeferred));
        sb.append(", previousSeverity=").append(String.valueOf((Object)this.previousSeverity));
        sb.append(", justification=").append(String.valueOf(this.justification));
        sb.append(", timeValidUntil=").append(String.valueOf(this.timeValidUntil));
        sb.append(", modifiedBy=").append(String.valueOf(this.modifiedBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FindingsChangeAuditLogSummary)) {
            return false;
        }
        FindingsChangeAuditLogSummary other = (FindingsChangeAuditLogSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.findingKey, other.findingKey) && Objects.equals(this.findingTitle, other.findingTitle) && Objects.equals(this.assessmentId, other.assessmentId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals((Object)this.oracleDefinedSeverity, (Object)other.oracleDefinedSeverity) && Objects.equals(this.isRiskDeferred, other.isRiskDeferred) && Objects.equals((Object)this.previousSeverity, (Object)other.previousSeverity) && Objects.equals(this.justification, other.justification) && Objects.equals(this.timeValidUntil, other.timeValidUntil) && Objects.equals(this.modifiedBy, other.modifiedBy) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.findingKey == null ? 43 : this.findingKey.hashCode());
        result = result * 59 + (this.findingTitle == null ? 43 : this.findingTitle.hashCode());
        result = result * 59 + (this.assessmentId == null ? 43 : this.assessmentId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.oracleDefinedSeverity == null ? 43 : this.oracleDefinedSeverity.hashCode());
        result = result * 59 + (this.isRiskDeferred == null ? 43 : this.isRiskDeferred.hashCode());
        result = result * 59 + (this.previousSeverity == null ? 43 : this.previousSeverity.hashCode());
        result = result * 59 + (this.justification == null ? 43 : this.justification.hashCode());
        result = result * 59 + (this.timeValidUntil == null ? 43 : this.timeValidUntil.hashCode());
        result = result * 59 + (this.modifiedBy == null ? 43 : this.modifiedBy.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="findingKey")
        private String findingKey;
        @JsonProperty(value="findingTitle")
        private String findingTitle;
        @JsonProperty(value="assessmentId")
        private String assessmentId;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="severity")
        private Finding.Severity severity;
        @JsonProperty(value="oracleDefinedSeverity")
        private Finding.Severity oracleDefinedSeverity;
        @JsonProperty(value="isRiskDeferred")
        private Boolean isRiskDeferred;
        @JsonProperty(value="previousSeverity")
        private Finding.Severity previousSeverity;
        @JsonProperty(value="justification")
        private String justification;
        @JsonProperty(value="timeValidUntil")
        private Date timeValidUntil;
        @JsonProperty(value="modifiedBy")
        private String modifiedBy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder findingKey(String findingKey) {
            this.findingKey = findingKey;
            this.__explicitlySet__.add("findingKey");
            return this;
        }

        public Builder findingTitle(String findingTitle) {
            this.findingTitle = findingTitle;
            this.__explicitlySet__.add("findingTitle");
            return this;
        }

        public Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            this.__explicitlySet__.add("assessmentId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder severity(Finding.Severity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder oracleDefinedSeverity(Finding.Severity oracleDefinedSeverity) {
            this.oracleDefinedSeverity = oracleDefinedSeverity;
            this.__explicitlySet__.add("oracleDefinedSeverity");
            return this;
        }

        public Builder isRiskDeferred(Boolean isRiskDeferred) {
            this.isRiskDeferred = isRiskDeferred;
            this.__explicitlySet__.add("isRiskDeferred");
            return this;
        }

        public Builder previousSeverity(Finding.Severity previousSeverity) {
            this.previousSeverity = previousSeverity;
            this.__explicitlySet__.add("previousSeverity");
            return this;
        }

        public Builder justification(String justification) {
            this.justification = justification;
            this.__explicitlySet__.add("justification");
            return this;
        }

        public Builder timeValidUntil(Date timeValidUntil) {
            this.timeValidUntil = timeValidUntil;
            this.__explicitlySet__.add("timeValidUntil");
            return this;
        }

        public Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            this.__explicitlySet__.add("modifiedBy");
            return this;
        }

        public FindingsChangeAuditLogSummary build() {
            FindingsChangeAuditLogSummary model = new FindingsChangeAuditLogSummary(this.key, this.findingKey, this.findingTitle, this.assessmentId, this.targetId, this.timeUpdated, this.severity, this.oracleDefinedSeverity, this.isRiskDeferred, this.previousSeverity, this.justification, this.timeValidUntil, this.modifiedBy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FindingsChangeAuditLogSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("findingKey")) {
                this.findingKey(model.getFindingKey());
            }
            if (model.wasPropertyExplicitlySet("findingTitle")) {
                this.findingTitle(model.getFindingTitle());
            }
            if (model.wasPropertyExplicitlySet("assessmentId")) {
                this.assessmentId(model.getAssessmentId());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("oracleDefinedSeverity")) {
                this.oracleDefinedSeverity(model.getOracleDefinedSeverity());
            }
            if (model.wasPropertyExplicitlySet("isRiskDeferred")) {
                this.isRiskDeferred(model.getIsRiskDeferred());
            }
            if (model.wasPropertyExplicitlySet("previousSeverity")) {
                this.previousSeverity(model.getPreviousSeverity());
            }
            if (model.wasPropertyExplicitlySet("justification")) {
                this.justification(model.getJustification());
            }
            if (model.wasPropertyExplicitlySet("timeValidUntil")) {
                this.timeValidUntil(model.getTimeValidUntil());
            }
            if (model.wasPropertyExplicitlySet("modifiedBy")) {
                this.modifiedBy(model.getModifiedBy());
            }
            return this;
        }
    }
}

