/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.FormatEntry;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class FixedNumberFormatEntry
extends FormatEntry {
    @JsonProperty(value="fixedNumber")
    private final BigDecimal fixedNumber;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public FixedNumberFormatEntry(String description, BigDecimal fixedNumber) {
        super(description);
        this.fixedNumber = fixedNumber;
    }

    public BigDecimal getFixedNumber() {
        return this.fixedNumber;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FixedNumberFormatEntry(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", fixedNumber=").append(String.valueOf(this.fixedNumber));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedNumberFormatEntry)) {
            return false;
        }
        FixedNumberFormatEntry other = (FixedNumberFormatEntry)((Object)o);
        return Objects.equals(this.fixedNumber, other.fixedNumber) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fixedNumber == null ? 43 : this.fixedNumber.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="fixedNumber")
        private BigDecimal fixedNumber;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder fixedNumber(BigDecimal fixedNumber) {
            this.fixedNumber = fixedNumber;
            this.__explicitlySet__.add("fixedNumber");
            return this;
        }

        public FixedNumberFormatEntry build() {
            FixedNumberFormatEntry model = new FixedNumberFormatEntry(this.description, this.fixedNumber);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FixedNumberFormatEntry model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("fixedNumber")) {
                this.fixedNumber(model.getFixedNumber());
            }
            return this;
        }
    }
}

