/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GenerateMaskingReportForDownloadDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="reportId")
    private final String reportId;
    @JsonProperty(value="reportFormat")
    private final ReportFormat reportFormat;

    @Deprecated
    @ConstructorProperties(value={"reportId", "reportFormat"})
    public GenerateMaskingReportForDownloadDetails(String reportId, ReportFormat reportFormat) {
        this.reportId = reportId;
        this.reportFormat = reportFormat;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getReportId() {
        return this.reportId;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GenerateMaskingReportForDownloadDetails(");
        sb.append("super=").append(super.toString());
        sb.append("reportId=").append(String.valueOf(this.reportId));
        sb.append(", reportFormat=").append(String.valueOf((Object)this.reportFormat));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateMaskingReportForDownloadDetails)) {
            return false;
        }
        GenerateMaskingReportForDownloadDetails other = (GenerateMaskingReportForDownloadDetails)((Object)o);
        return Objects.equals(this.reportId, other.reportId) && Objects.equals((Object)this.reportFormat, (Object)other.reportFormat) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.reportId == null ? 43 : this.reportId.hashCode());
        result = result * 59 + (this.reportFormat == null ? 43 : this.reportFormat.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ReportFormat implements BmcEnum
    {
        Pdf("PDF"),
        Xls("XLS");

        private final String value;
        private static Map<String, ReportFormat> map;

        private ReportFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReportFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReportFormat: " + key);
        }

        static {
            map = new HashMap<String, ReportFormat>();
            for (ReportFormat v : ReportFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="reportId")
        private String reportId;
        @JsonProperty(value="reportFormat")
        private ReportFormat reportFormat;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder reportId(String reportId) {
            this.reportId = reportId;
            this.__explicitlySet__.add("reportId");
            return this;
        }

        public Builder reportFormat(ReportFormat reportFormat) {
            this.reportFormat = reportFormat;
            this.__explicitlySet__.add("reportFormat");
            return this;
        }

        public GenerateMaskingReportForDownloadDetails build() {
            GenerateMaskingReportForDownloadDetails model = new GenerateMaskingReportForDownloadDetails(this.reportId, this.reportFormat);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GenerateMaskingReportForDownloadDetails model) {
            if (model.wasPropertyExplicitlySet("reportId")) {
                this.reportId(model.getReportId());
            }
            if (model.wasPropertyExplicitlySet("reportFormat")) {
                this.reportFormat(model.getReportFormat());
            }
            return this;
        }
    }
}

