/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.PeerTargetDatabaseSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PeerTargetDatabaseCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="targetDatabaseId")
    private final String targetDatabaseId;
    @JsonProperty(value="items")
    private final List<PeerTargetDatabaseSummary> items;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "targetDatabaseId", "items"})
    public PeerTargetDatabaseCollection(String compartmentId, String targetDatabaseId, List<PeerTargetDatabaseSummary> items) {
        this.compartmentId = compartmentId;
        this.targetDatabaseId = targetDatabaseId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetDatabaseId() {
        return this.targetDatabaseId;
    }

    public List<PeerTargetDatabaseSummary> getItems() {
        return this.items;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PeerTargetDatabaseCollection(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", targetDatabaseId=").append(String.valueOf(this.targetDatabaseId));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PeerTargetDatabaseCollection)) {
            return false;
        }
        PeerTargetDatabaseCollection other = (PeerTargetDatabaseCollection)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetDatabaseId, other.targetDatabaseId) && Objects.equals(this.items, other.items) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetDatabaseId == null ? 43 : this.targetDatabaseId.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="targetDatabaseId")
        private String targetDatabaseId;
        @JsonProperty(value="items")
        private List<PeerTargetDatabaseSummary> items;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder targetDatabaseId(String targetDatabaseId) {
            this.targetDatabaseId = targetDatabaseId;
            this.__explicitlySet__.add("targetDatabaseId");
            return this;
        }

        public Builder items(List<PeerTargetDatabaseSummary> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public PeerTargetDatabaseCollection build() {
            PeerTargetDatabaseCollection model = new PeerTargetDatabaseCollection(this.compartmentId, this.targetDatabaseId, this.items);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PeerTargetDatabaseCollection model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("targetDatabaseId")) {
                this.targetDatabaseId(model.getTargetDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            return this;
        }
    }
}

