/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.ReportDefinitionDataSource;
import com.oracle.bmc.datasafe.model.ReportDefinitionLifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ReportDefinitionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="category")
    private final Category category;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="isSeeded")
    private final Boolean isSeeded;
    @JsonProperty(value="displayOrder")
    private final Integer displayOrder;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dataSource")
    private final ReportDefinitionDataSource dataSource;
    @JsonProperty(value="lifecycleState")
    private final ReportDefinitionLifecycleState lifecycleState;
    @JsonProperty(value="schedule")
    private final String schedule;
    @JsonProperty(value="complianceStandards")
    private final List<String> complianceStandards;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "id", "category", "description", "isSeeded", "displayOrder", "timeCreated", "timeUpdated", "compartmentId", "dataSource", "lifecycleState", "schedule", "complianceStandards", "freeformTags", "definedTags"})
    public ReportDefinitionSummary(String displayName, String id, Category category, String description, Boolean isSeeded, Integer displayOrder, Date timeCreated, Date timeUpdated, String compartmentId, ReportDefinitionDataSource dataSource, ReportDefinitionLifecycleState lifecycleState, String schedule, List<String> complianceStandards, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.id = id;
        this.category = category;
        this.description = description;
        this.isSeeded = isSeeded;
        this.displayOrder = displayOrder;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.compartmentId = compartmentId;
        this.dataSource = dataSource;
        this.lifecycleState = lifecycleState;
        this.schedule = schedule;
        this.complianceStandards = complianceStandards;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsSeeded() {
        return this.isSeeded;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ReportDefinitionDataSource getDataSource() {
        return this.dataSource;
    }

    public ReportDefinitionLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public List<String> getComplianceStandards() {
        return this.complianceStandards;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReportDefinitionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", category=").append(String.valueOf((Object)this.category));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", isSeeded=").append(String.valueOf(this.isSeeded));
        sb.append(", displayOrder=").append(String.valueOf(this.displayOrder));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", dataSource=").append(String.valueOf((Object)this.dataSource));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", schedule=").append(String.valueOf(this.schedule));
        sb.append(", complianceStandards=").append(String.valueOf(this.complianceStandards));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReportDefinitionSummary)) {
            return false;
        }
        ReportDefinitionSummary other = (ReportDefinitionSummary)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.category, (Object)other.category) && Objects.equals(this.description, other.description) && Objects.equals(this.isSeeded, other.isSeeded) && Objects.equals(this.displayOrder, other.displayOrder) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.dataSource, (Object)other.dataSource) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.schedule, other.schedule) && Objects.equals(this.complianceStandards, other.complianceStandards) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.isSeeded == null ? 43 : this.isSeeded.hashCode());
        result = result * 59 + (this.displayOrder == null ? 43 : this.displayOrder.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dataSource == null ? 43 : this.dataSource.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.schedule == null ? 43 : this.schedule.hashCode());
        result = result * 59 + (this.complianceStandards == null ? 43 : this.complianceStandards.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Category implements BmcEnum
    {
        CustomReports("CUSTOM_REPORTS"),
        Summary("SUMMARY"),
        ActivityAuditing("ACTIVITY_AUDITING"),
        FirewallViolations("FIREWALL_VIOLATIONS"),
        AllowedSql("ALLOWED_SQL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Category> map;

        private Category(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Category create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Category', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Category.class);
            map = new HashMap<String, Category>();
            for (Category v : Category.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="category")
        private Category category;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isSeeded")
        private Boolean isSeeded;
        @JsonProperty(value="displayOrder")
        private Integer displayOrder;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dataSource")
        private ReportDefinitionDataSource dataSource;
        @JsonProperty(value="lifecycleState")
        private ReportDefinitionLifecycleState lifecycleState;
        @JsonProperty(value="schedule")
        private String schedule;
        @JsonProperty(value="complianceStandards")
        private List<String> complianceStandards;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder category(Category category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isSeeded(Boolean isSeeded) {
            this.isSeeded = isSeeded;
            this.__explicitlySet__.add("isSeeded");
            return this;
        }

        public Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            this.__explicitlySet__.add("displayOrder");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dataSource(ReportDefinitionDataSource dataSource) {
            this.dataSource = dataSource;
            this.__explicitlySet__.add("dataSource");
            return this;
        }

        public Builder lifecycleState(ReportDefinitionLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder schedule(String schedule) {
            this.schedule = schedule;
            this.__explicitlySet__.add("schedule");
            return this;
        }

        public Builder complianceStandards(List<String> complianceStandards) {
            this.complianceStandards = complianceStandards;
            this.__explicitlySet__.add("complianceStandards");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public ReportDefinitionSummary build() {
            ReportDefinitionSummary model = new ReportDefinitionSummary(this.displayName, this.id, this.category, this.description, this.isSeeded, this.displayOrder, this.timeCreated, this.timeUpdated, this.compartmentId, this.dataSource, this.lifecycleState, this.schedule, this.complianceStandards, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReportDefinitionSummary model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("isSeeded")) {
                this.isSeeded(model.getIsSeeded());
            }
            if (model.wasPropertyExplicitlySet("displayOrder")) {
                this.displayOrder(model.getDisplayOrder());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dataSource")) {
                this.dataSource(model.getDataSource());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("schedule")) {
                this.schedule(model.getSchedule());
            }
            if (model.wasPropertyExplicitlySet("complianceStandards")) {
                this.complianceStandards(model.getComplianceStandards());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

