/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.SectionStatistics;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecurityAssessmentStatistics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targetsCount")
    private final Integer targetsCount;
    @JsonProperty(value="highRisk")
    private final SectionStatistics highRisk;
    @JsonProperty(value="mediumRisk")
    private final SectionStatistics mediumRisk;
    @JsonProperty(value="lowRisk")
    private final SectionStatistics lowRisk;
    @JsonProperty(value="advisory")
    private final SectionStatistics advisory;
    @JsonProperty(value="evaluate")
    private final SectionStatistics evaluate;
    @JsonProperty(value="pass")
    private final SectionStatistics pass;
    @JsonProperty(value="deferred")
    private final SectionStatistics deferred;

    @Deprecated
    @ConstructorProperties(value={"targetsCount", "highRisk", "mediumRisk", "lowRisk", "advisory", "evaluate", "pass", "deferred"})
    public SecurityAssessmentStatistics(Integer targetsCount, SectionStatistics highRisk, SectionStatistics mediumRisk, SectionStatistics lowRisk, SectionStatistics advisory, SectionStatistics evaluate, SectionStatistics pass, SectionStatistics deferred) {
        this.targetsCount = targetsCount;
        this.highRisk = highRisk;
        this.mediumRisk = mediumRisk;
        this.lowRisk = lowRisk;
        this.advisory = advisory;
        this.evaluate = evaluate;
        this.pass = pass;
        this.deferred = deferred;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getTargetsCount() {
        return this.targetsCount;
    }

    public SectionStatistics getHighRisk() {
        return this.highRisk;
    }

    public SectionStatistics getMediumRisk() {
        return this.mediumRisk;
    }

    public SectionStatistics getLowRisk() {
        return this.lowRisk;
    }

    public SectionStatistics getAdvisory() {
        return this.advisory;
    }

    public SectionStatistics getEvaluate() {
        return this.evaluate;
    }

    public SectionStatistics getPass() {
        return this.pass;
    }

    public SectionStatistics getDeferred() {
        return this.deferred;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecurityAssessmentStatistics(");
        sb.append("super=").append(super.toString());
        sb.append("targetsCount=").append(String.valueOf(this.targetsCount));
        sb.append(", highRisk=").append(String.valueOf((Object)this.highRisk));
        sb.append(", mediumRisk=").append(String.valueOf((Object)this.mediumRisk));
        sb.append(", lowRisk=").append(String.valueOf((Object)this.lowRisk));
        sb.append(", advisory=").append(String.valueOf((Object)this.advisory));
        sb.append(", evaluate=").append(String.valueOf((Object)this.evaluate));
        sb.append(", pass=").append(String.valueOf((Object)this.pass));
        sb.append(", deferred=").append(String.valueOf((Object)this.deferred));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityAssessmentStatistics)) {
            return false;
        }
        SecurityAssessmentStatistics other = (SecurityAssessmentStatistics)((Object)o);
        return Objects.equals(this.targetsCount, other.targetsCount) && Objects.equals((Object)this.highRisk, (Object)other.highRisk) && Objects.equals((Object)this.mediumRisk, (Object)other.mediumRisk) && Objects.equals((Object)this.lowRisk, (Object)other.lowRisk) && Objects.equals((Object)this.advisory, (Object)other.advisory) && Objects.equals((Object)this.evaluate, (Object)other.evaluate) && Objects.equals((Object)this.pass, (Object)other.pass) && Objects.equals((Object)this.deferred, (Object)other.deferred) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targetsCount == null ? 43 : this.targetsCount.hashCode());
        result = result * 59 + (this.highRisk == null ? 43 : this.highRisk.hashCode());
        result = result * 59 + (this.mediumRisk == null ? 43 : this.mediumRisk.hashCode());
        result = result * 59 + (this.lowRisk == null ? 43 : this.lowRisk.hashCode());
        result = result * 59 + (this.advisory == null ? 43 : this.advisory.hashCode());
        result = result * 59 + (this.evaluate == null ? 43 : this.evaluate.hashCode());
        result = result * 59 + (this.pass == null ? 43 : this.pass.hashCode());
        result = result * 59 + (this.deferred == null ? 43 : this.deferred.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targetsCount")
        private Integer targetsCount;
        @JsonProperty(value="highRisk")
        private SectionStatistics highRisk;
        @JsonProperty(value="mediumRisk")
        private SectionStatistics mediumRisk;
        @JsonProperty(value="lowRisk")
        private SectionStatistics lowRisk;
        @JsonProperty(value="advisory")
        private SectionStatistics advisory;
        @JsonProperty(value="evaluate")
        private SectionStatistics evaluate;
        @JsonProperty(value="pass")
        private SectionStatistics pass;
        @JsonProperty(value="deferred")
        private SectionStatistics deferred;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targetsCount(Integer targetsCount) {
            this.targetsCount = targetsCount;
            this.__explicitlySet__.add("targetsCount");
            return this;
        }

        public Builder highRisk(SectionStatistics highRisk) {
            this.highRisk = highRisk;
            this.__explicitlySet__.add("highRisk");
            return this;
        }

        public Builder mediumRisk(SectionStatistics mediumRisk) {
            this.mediumRisk = mediumRisk;
            this.__explicitlySet__.add("mediumRisk");
            return this;
        }

        public Builder lowRisk(SectionStatistics lowRisk) {
            this.lowRisk = lowRisk;
            this.__explicitlySet__.add("lowRisk");
            return this;
        }

        public Builder advisory(SectionStatistics advisory) {
            this.advisory = advisory;
            this.__explicitlySet__.add("advisory");
            return this;
        }

        public Builder evaluate(SectionStatistics evaluate) {
            this.evaluate = evaluate;
            this.__explicitlySet__.add("evaluate");
            return this;
        }

        public Builder pass(SectionStatistics pass) {
            this.pass = pass;
            this.__explicitlySet__.add("pass");
            return this;
        }

        public Builder deferred(SectionStatistics deferred) {
            this.deferred = deferred;
            this.__explicitlySet__.add("deferred");
            return this;
        }

        public SecurityAssessmentStatistics build() {
            SecurityAssessmentStatistics model = new SecurityAssessmentStatistics(this.targetsCount, this.highRisk, this.mediumRisk, this.lowRisk, this.advisory, this.evaluate, this.pass, this.deferred);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecurityAssessmentStatistics model) {
            if (model.wasPropertyExplicitlySet("targetsCount")) {
                this.targetsCount(model.getTargetsCount());
            }
            if (model.wasPropertyExplicitlySet("highRisk")) {
                this.highRisk(model.getHighRisk());
            }
            if (model.wasPropertyExplicitlySet("mediumRisk")) {
                this.mediumRisk(model.getMediumRisk());
            }
            if (model.wasPropertyExplicitlySet("lowRisk")) {
                this.lowRisk(model.getLowRisk());
            }
            if (model.wasPropertyExplicitlySet("advisory")) {
                this.advisory(model.getAdvisory());
            }
            if (model.wasPropertyExplicitlySet("evaluate")) {
                this.evaluate(model.getEvaluate());
            }
            if (model.wasPropertyExplicitlySet("pass")) {
                this.pass(model.getPass());
            }
            if (model.wasPropertyExplicitlySet("deferred")) {
                this.deferred(model.getDeferred());
            }
            return this;
        }
    }
}

