/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecurityFeatureSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="assessmentId")
    private final String assessmentId;
    @JsonProperty(value="unifiedAudit")
    private final UnifiedAudit unifiedAudit;
    @JsonProperty(value="fineGrainedAudit")
    private final FineGrainedAudit fineGrainedAudit;
    @JsonProperty(value="traditionalAudit")
    private final TraditionalAudit traditionalAudit;
    @JsonProperty(value="databaseVault")
    private final DatabaseVault databaseVault;
    @JsonProperty(value="privilegeAnalysis")
    private final PrivilegeAnalysis privilegeAnalysis;
    @JsonProperty(value="tablespaceEncryption")
    private final TablespaceEncryption tablespaceEncryption;
    @JsonProperty(value="columnEncryption")
    private final ColumnEncryption columnEncryption;
    @JsonProperty(value="networkEncryption")
    private final NetworkEncryption networkEncryption;
    @JsonProperty(value="passwordAuthentication")
    private final PasswordAuthentication passwordAuthentication;
    @JsonProperty(value="globalAuthentication")
    private final GlobalAuthentication globalAuthentication;
    @JsonProperty(value="externalAuthentication")
    private final ExternalAuthentication externalAuthentication;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "targetId", "assessmentId", "unifiedAudit", "fineGrainedAudit", "traditionalAudit", "databaseVault", "privilegeAnalysis", "tablespaceEncryption", "columnEncryption", "networkEncryption", "passwordAuthentication", "globalAuthentication", "externalAuthentication", "freeformTags", "definedTags"})
    public SecurityFeatureSummary(String compartmentId, String targetId, String assessmentId, UnifiedAudit unifiedAudit, FineGrainedAudit fineGrainedAudit, TraditionalAudit traditionalAudit, DatabaseVault databaseVault, PrivilegeAnalysis privilegeAnalysis, TablespaceEncryption tablespaceEncryption, ColumnEncryption columnEncryption, NetworkEncryption networkEncryption, PasswordAuthentication passwordAuthentication, GlobalAuthentication globalAuthentication, ExternalAuthentication externalAuthentication, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.compartmentId = compartmentId;
        this.targetId = targetId;
        this.assessmentId = assessmentId;
        this.unifiedAudit = unifiedAudit;
        this.fineGrainedAudit = fineGrainedAudit;
        this.traditionalAudit = traditionalAudit;
        this.databaseVault = databaseVault;
        this.privilegeAnalysis = privilegeAnalysis;
        this.tablespaceEncryption = tablespaceEncryption;
        this.columnEncryption = columnEncryption;
        this.networkEncryption = networkEncryption;
        this.passwordAuthentication = passwordAuthentication;
        this.globalAuthentication = globalAuthentication;
        this.externalAuthentication = externalAuthentication;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getAssessmentId() {
        return this.assessmentId;
    }

    public UnifiedAudit getUnifiedAudit() {
        return this.unifiedAudit;
    }

    public FineGrainedAudit getFineGrainedAudit() {
        return this.fineGrainedAudit;
    }

    public TraditionalAudit getTraditionalAudit() {
        return this.traditionalAudit;
    }

    public DatabaseVault getDatabaseVault() {
        return this.databaseVault;
    }

    public PrivilegeAnalysis getPrivilegeAnalysis() {
        return this.privilegeAnalysis;
    }

    public TablespaceEncryption getTablespaceEncryption() {
        return this.tablespaceEncryption;
    }

    public ColumnEncryption getColumnEncryption() {
        return this.columnEncryption;
    }

    public NetworkEncryption getNetworkEncryption() {
        return this.networkEncryption;
    }

    public PasswordAuthentication getPasswordAuthentication() {
        return this.passwordAuthentication;
    }

    public GlobalAuthentication getGlobalAuthentication() {
        return this.globalAuthentication;
    }

    public ExternalAuthentication getExternalAuthentication() {
        return this.externalAuthentication;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecurityFeatureSummary(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", assessmentId=").append(String.valueOf(this.assessmentId));
        sb.append(", unifiedAudit=").append(String.valueOf((Object)this.unifiedAudit));
        sb.append(", fineGrainedAudit=").append(String.valueOf((Object)this.fineGrainedAudit));
        sb.append(", traditionalAudit=").append(String.valueOf((Object)this.traditionalAudit));
        sb.append(", databaseVault=").append(String.valueOf((Object)this.databaseVault));
        sb.append(", privilegeAnalysis=").append(String.valueOf((Object)this.privilegeAnalysis));
        sb.append(", tablespaceEncryption=").append(String.valueOf((Object)this.tablespaceEncryption));
        sb.append(", columnEncryption=").append(String.valueOf((Object)this.columnEncryption));
        sb.append(", networkEncryption=").append(String.valueOf((Object)this.networkEncryption));
        sb.append(", passwordAuthentication=").append(String.valueOf((Object)this.passwordAuthentication));
        sb.append(", globalAuthentication=").append(String.valueOf((Object)this.globalAuthentication));
        sb.append(", externalAuthentication=").append(String.valueOf((Object)this.externalAuthentication));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityFeatureSummary)) {
            return false;
        }
        SecurityFeatureSummary other = (SecurityFeatureSummary)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.assessmentId, other.assessmentId) && Objects.equals((Object)this.unifiedAudit, (Object)other.unifiedAudit) && Objects.equals((Object)this.fineGrainedAudit, (Object)other.fineGrainedAudit) && Objects.equals((Object)this.traditionalAudit, (Object)other.traditionalAudit) && Objects.equals((Object)this.databaseVault, (Object)other.databaseVault) && Objects.equals((Object)this.privilegeAnalysis, (Object)other.privilegeAnalysis) && Objects.equals((Object)this.tablespaceEncryption, (Object)other.tablespaceEncryption) && Objects.equals((Object)this.columnEncryption, (Object)other.columnEncryption) && Objects.equals((Object)this.networkEncryption, (Object)other.networkEncryption) && Objects.equals((Object)this.passwordAuthentication, (Object)other.passwordAuthentication) && Objects.equals((Object)this.globalAuthentication, (Object)other.globalAuthentication) && Objects.equals((Object)this.externalAuthentication, (Object)other.externalAuthentication) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.assessmentId == null ? 43 : this.assessmentId.hashCode());
        result = result * 59 + (this.unifiedAudit == null ? 43 : this.unifiedAudit.hashCode());
        result = result * 59 + (this.fineGrainedAudit == null ? 43 : this.fineGrainedAudit.hashCode());
        result = result * 59 + (this.traditionalAudit == null ? 43 : this.traditionalAudit.hashCode());
        result = result * 59 + (this.databaseVault == null ? 43 : this.databaseVault.hashCode());
        result = result * 59 + (this.privilegeAnalysis == null ? 43 : this.privilegeAnalysis.hashCode());
        result = result * 59 + (this.tablespaceEncryption == null ? 43 : this.tablespaceEncryption.hashCode());
        result = result * 59 + (this.columnEncryption == null ? 43 : this.columnEncryption.hashCode());
        result = result * 59 + (this.networkEncryption == null ? 43 : this.networkEncryption.hashCode());
        result = result * 59 + (this.passwordAuthentication == null ? 43 : this.passwordAuthentication.hashCode());
        result = result * 59 + (this.globalAuthentication == null ? 43 : this.globalAuthentication.hashCode());
        result = result * 59 + (this.externalAuthentication == null ? 43 : this.externalAuthentication.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ExternalAuthentication implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExternalAuthentication> map;

        private ExternalAuthentication(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExternalAuthentication create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExternalAuthentication', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExternalAuthentication.class);
            map = new HashMap<String, ExternalAuthentication>();
            for (ExternalAuthentication v : ExternalAuthentication.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum GlobalAuthentication implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, GlobalAuthentication> map;

        private GlobalAuthentication(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GlobalAuthentication create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'GlobalAuthentication', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(GlobalAuthentication.class);
            map = new HashMap<String, GlobalAuthentication>();
            for (GlobalAuthentication v : GlobalAuthentication.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PasswordAuthentication implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PasswordAuthentication> map;

        private PasswordAuthentication(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PasswordAuthentication create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PasswordAuthentication', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PasswordAuthentication.class);
            map = new HashMap<String, PasswordAuthentication>();
            for (PasswordAuthentication v : PasswordAuthentication.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum NetworkEncryption implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, NetworkEncryption> map;

        private NetworkEncryption(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NetworkEncryption create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'NetworkEncryption', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(NetworkEncryption.class);
            map = new HashMap<String, NetworkEncryption>();
            for (NetworkEncryption v : NetworkEncryption.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ColumnEncryption implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ColumnEncryption> map;

        private ColumnEncryption(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ColumnEncryption create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ColumnEncryption', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ColumnEncryption.class);
            map = new HashMap<String, ColumnEncryption>();
            for (ColumnEncryption v : ColumnEncryption.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TablespaceEncryption implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TablespaceEncryption> map;

        private TablespaceEncryption(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TablespaceEncryption create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TablespaceEncryption', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TablespaceEncryption.class);
            map = new HashMap<String, TablespaceEncryption>();
            for (TablespaceEncryption v : TablespaceEncryption.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PrivilegeAnalysis implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PrivilegeAnalysis> map;

        private PrivilegeAnalysis(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PrivilegeAnalysis create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PrivilegeAnalysis', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PrivilegeAnalysis.class);
            map = new HashMap<String, PrivilegeAnalysis>();
            for (PrivilegeAnalysis v : PrivilegeAnalysis.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseVault implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DatabaseVault> map;

        private DatabaseVault(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseVault create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DatabaseVault', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DatabaseVault.class);
            map = new HashMap<String, DatabaseVault>();
            for (DatabaseVault v : DatabaseVault.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TraditionalAudit implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TraditionalAudit> map;

        private TraditionalAudit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TraditionalAudit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TraditionalAudit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TraditionalAudit.class);
            map = new HashMap<String, TraditionalAudit>();
            for (TraditionalAudit v : TraditionalAudit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum FineGrainedAudit implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FineGrainedAudit> map;

        private FineGrainedAudit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FineGrainedAudit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FineGrainedAudit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FineGrainedAudit.class);
            map = new HashMap<String, FineGrainedAudit>();
            for (FineGrainedAudit v : FineGrainedAudit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum UnifiedAudit implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UnifiedAudit> map;

        private UnifiedAudit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UnifiedAudit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UnifiedAudit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UnifiedAudit.class);
            map = new HashMap<String, UnifiedAudit>();
            for (UnifiedAudit v : UnifiedAudit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="assessmentId")
        private String assessmentId;
        @JsonProperty(value="unifiedAudit")
        private UnifiedAudit unifiedAudit;
        @JsonProperty(value="fineGrainedAudit")
        private FineGrainedAudit fineGrainedAudit;
        @JsonProperty(value="traditionalAudit")
        private TraditionalAudit traditionalAudit;
        @JsonProperty(value="databaseVault")
        private DatabaseVault databaseVault;
        @JsonProperty(value="privilegeAnalysis")
        private PrivilegeAnalysis privilegeAnalysis;
        @JsonProperty(value="tablespaceEncryption")
        private TablespaceEncryption tablespaceEncryption;
        @JsonProperty(value="columnEncryption")
        private ColumnEncryption columnEncryption;
        @JsonProperty(value="networkEncryption")
        private NetworkEncryption networkEncryption;
        @JsonProperty(value="passwordAuthentication")
        private PasswordAuthentication passwordAuthentication;
        @JsonProperty(value="globalAuthentication")
        private GlobalAuthentication globalAuthentication;
        @JsonProperty(value="externalAuthentication")
        private ExternalAuthentication externalAuthentication;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            this.__explicitlySet__.add("assessmentId");
            return this;
        }

        public Builder unifiedAudit(UnifiedAudit unifiedAudit) {
            this.unifiedAudit = unifiedAudit;
            this.__explicitlySet__.add("unifiedAudit");
            return this;
        }

        public Builder fineGrainedAudit(FineGrainedAudit fineGrainedAudit) {
            this.fineGrainedAudit = fineGrainedAudit;
            this.__explicitlySet__.add("fineGrainedAudit");
            return this;
        }

        public Builder traditionalAudit(TraditionalAudit traditionalAudit) {
            this.traditionalAudit = traditionalAudit;
            this.__explicitlySet__.add("traditionalAudit");
            return this;
        }

        public Builder databaseVault(DatabaseVault databaseVault) {
            this.databaseVault = databaseVault;
            this.__explicitlySet__.add("databaseVault");
            return this;
        }

        public Builder privilegeAnalysis(PrivilegeAnalysis privilegeAnalysis) {
            this.privilegeAnalysis = privilegeAnalysis;
            this.__explicitlySet__.add("privilegeAnalysis");
            return this;
        }

        public Builder tablespaceEncryption(TablespaceEncryption tablespaceEncryption) {
            this.tablespaceEncryption = tablespaceEncryption;
            this.__explicitlySet__.add("tablespaceEncryption");
            return this;
        }

        public Builder columnEncryption(ColumnEncryption columnEncryption) {
            this.columnEncryption = columnEncryption;
            this.__explicitlySet__.add("columnEncryption");
            return this;
        }

        public Builder networkEncryption(NetworkEncryption networkEncryption) {
            this.networkEncryption = networkEncryption;
            this.__explicitlySet__.add("networkEncryption");
            return this;
        }

        public Builder passwordAuthentication(PasswordAuthentication passwordAuthentication) {
            this.passwordAuthentication = passwordAuthentication;
            this.__explicitlySet__.add("passwordAuthentication");
            return this;
        }

        public Builder globalAuthentication(GlobalAuthentication globalAuthentication) {
            this.globalAuthentication = globalAuthentication;
            this.__explicitlySet__.add("globalAuthentication");
            return this;
        }

        public Builder externalAuthentication(ExternalAuthentication externalAuthentication) {
            this.externalAuthentication = externalAuthentication;
            this.__explicitlySet__.add("externalAuthentication");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public SecurityFeatureSummary build() {
            SecurityFeatureSummary model = new SecurityFeatureSummary(this.compartmentId, this.targetId, this.assessmentId, this.unifiedAudit, this.fineGrainedAudit, this.traditionalAudit, this.databaseVault, this.privilegeAnalysis, this.tablespaceEncryption, this.columnEncryption, this.networkEncryption, this.passwordAuthentication, this.globalAuthentication, this.externalAuthentication, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecurityFeatureSummary model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("assessmentId")) {
                this.assessmentId(model.getAssessmentId());
            }
            if (model.wasPropertyExplicitlySet("unifiedAudit")) {
                this.unifiedAudit(model.getUnifiedAudit());
            }
            if (model.wasPropertyExplicitlySet("fineGrainedAudit")) {
                this.fineGrainedAudit(model.getFineGrainedAudit());
            }
            if (model.wasPropertyExplicitlySet("traditionalAudit")) {
                this.traditionalAudit(model.getTraditionalAudit());
            }
            if (model.wasPropertyExplicitlySet("databaseVault")) {
                this.databaseVault(model.getDatabaseVault());
            }
            if (model.wasPropertyExplicitlySet("privilegeAnalysis")) {
                this.privilegeAnalysis(model.getPrivilegeAnalysis());
            }
            if (model.wasPropertyExplicitlySet("tablespaceEncryption")) {
                this.tablespaceEncryption(model.getTablespaceEncryption());
            }
            if (model.wasPropertyExplicitlySet("columnEncryption")) {
                this.columnEncryption(model.getColumnEncryption());
            }
            if (model.wasPropertyExplicitlySet("networkEncryption")) {
                this.networkEncryption(model.getNetworkEncryption());
            }
            if (model.wasPropertyExplicitlySet("passwordAuthentication")) {
                this.passwordAuthentication(model.getPasswordAuthentication());
            }
            if (model.wasPropertyExplicitlySet("globalAuthentication")) {
                this.globalAuthentication(model.getGlobalAuthentication());
            }
            if (model.wasPropertyExplicitlySet("externalAuthentication")) {
                this.externalAuthentication(model.getExternalAuthentication());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

