/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSecurityPolicyEntryStateRequest
extends BmcRequest<Void> {
    private String securityPolicyDeploymentId;
    private String securityPolicyEntryStateId;
    private String opcRequestId;

    public String getSecurityPolicyDeploymentId() {
        return this.securityPolicyDeploymentId;
    }

    public String getSecurityPolicyEntryStateId() {
        return this.securityPolicyEntryStateId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().securityPolicyDeploymentId(this.securityPolicyDeploymentId).securityPolicyEntryStateId(this.securityPolicyEntryStateId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityPolicyDeploymentId=").append(String.valueOf(this.securityPolicyDeploymentId));
        sb.append(",securityPolicyEntryStateId=").append(String.valueOf(this.securityPolicyEntryStateId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSecurityPolicyEntryStateRequest)) {
            return false;
        }
        GetSecurityPolicyEntryStateRequest other = (GetSecurityPolicyEntryStateRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityPolicyDeploymentId, other.securityPolicyDeploymentId) && Objects.equals(this.securityPolicyEntryStateId, other.securityPolicyEntryStateId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityPolicyDeploymentId == null ? 43 : this.securityPolicyDeploymentId.hashCode());
        result = result * 59 + (this.securityPolicyEntryStateId == null ? 43 : this.securityPolicyEntryStateId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSecurityPolicyEntryStateRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityPolicyDeploymentId = null;
        private String securityPolicyEntryStateId = null;
        private String opcRequestId = null;

        public Builder securityPolicyDeploymentId(String securityPolicyDeploymentId) {
            this.securityPolicyDeploymentId = securityPolicyDeploymentId;
            return this;
        }

        public Builder securityPolicyEntryStateId(String securityPolicyEntryStateId) {
            this.securityPolicyEntryStateId = securityPolicyEntryStateId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSecurityPolicyEntryStateRequest o) {
            this.securityPolicyDeploymentId(o.getSecurityPolicyDeploymentId());
            this.securityPolicyEntryStateId(o.getSecurityPolicyEntryStateId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSecurityPolicyEntryStateRequest build() {
            GetSecurityPolicyEntryStateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSecurityPolicyEntryStateRequest buildWithoutInvocationCallback() {
            GetSecurityPolicyEntryStateRequest request = new GetSecurityPolicyEntryStateRequest();
            request.securityPolicyDeploymentId = this.securityPolicyDeploymentId;
            request.securityPolicyEntryStateId = this.securityPolicyEntryStateId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

