/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListFindingsChangeAuditLogsRequest
extends BmcRequest<Void> {
    private String securityAssessmentId;
    private Severity severity;
    private String findingKey;
    private String findingTitle;
    private Boolean isRiskDeferred;
    private String modifiedBy;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private Date timeValidUntilGreaterThanOrEqualTo;
    private Date timeValidUntilLessThan;
    private Date timeUpdatedGreaterThanOrEqualTo;
    private Date timeUpdatedLessThan;
    private String opcRequestId;

    public String getSecurityAssessmentId() {
        return this.securityAssessmentId;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getFindingKey() {
        return this.findingKey;
    }

    public String getFindingTitle() {
        return this.findingTitle;
    }

    public Boolean getIsRiskDeferred() {
        return this.isRiskDeferred;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Date getTimeValidUntilGreaterThanOrEqualTo() {
        return this.timeValidUntilGreaterThanOrEqualTo;
    }

    public Date getTimeValidUntilLessThan() {
        return this.timeValidUntilLessThan;
    }

    public Date getTimeUpdatedGreaterThanOrEqualTo() {
        return this.timeUpdatedGreaterThanOrEqualTo;
    }

    public Date getTimeUpdatedLessThan() {
        return this.timeUpdatedLessThan;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().securityAssessmentId(this.securityAssessmentId).severity(this.severity).findingKey(this.findingKey).findingTitle(this.findingTitle).isRiskDeferred(this.isRiskDeferred).modifiedBy(this.modifiedBy).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).timeValidUntilGreaterThanOrEqualTo(this.timeValidUntilGreaterThanOrEqualTo).timeValidUntilLessThan(this.timeValidUntilLessThan).timeUpdatedGreaterThanOrEqualTo(this.timeUpdatedGreaterThanOrEqualTo).timeUpdatedLessThan(this.timeUpdatedLessThan).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityAssessmentId=").append(String.valueOf(this.securityAssessmentId));
        sb.append(",severity=").append(String.valueOf((Object)this.severity));
        sb.append(",findingKey=").append(String.valueOf(this.findingKey));
        sb.append(",findingTitle=").append(String.valueOf(this.findingTitle));
        sb.append(",isRiskDeferred=").append(String.valueOf(this.isRiskDeferred));
        sb.append(",modifiedBy=").append(String.valueOf(this.modifiedBy));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",timeValidUntilGreaterThanOrEqualTo=").append(String.valueOf(this.timeValidUntilGreaterThanOrEqualTo));
        sb.append(",timeValidUntilLessThan=").append(String.valueOf(this.timeValidUntilLessThan));
        sb.append(",timeUpdatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeUpdatedGreaterThanOrEqualTo));
        sb.append(",timeUpdatedLessThan=").append(String.valueOf(this.timeUpdatedLessThan));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListFindingsChangeAuditLogsRequest)) {
            return false;
        }
        ListFindingsChangeAuditLogsRequest other = (ListFindingsChangeAuditLogsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityAssessmentId, other.securityAssessmentId) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.findingKey, other.findingKey) && Objects.equals(this.findingTitle, other.findingTitle) && Objects.equals(this.isRiskDeferred, other.isRiskDeferred) && Objects.equals(this.modifiedBy, other.modifiedBy) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.timeValidUntilGreaterThanOrEqualTo, other.timeValidUntilGreaterThanOrEqualTo) && Objects.equals(this.timeValidUntilLessThan, other.timeValidUntilLessThan) && Objects.equals(this.timeUpdatedGreaterThanOrEqualTo, other.timeUpdatedGreaterThanOrEqualTo) && Objects.equals(this.timeUpdatedLessThan, other.timeUpdatedLessThan) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityAssessmentId == null ? 43 : this.securityAssessmentId.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.findingKey == null ? 43 : this.findingKey.hashCode());
        result = result * 59 + (this.findingTitle == null ? 43 : this.findingTitle.hashCode());
        result = result * 59 + (this.isRiskDeferred == null ? 43 : this.isRiskDeferred.hashCode());
        result = result * 59 + (this.modifiedBy == null ? 43 : this.modifiedBy.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.timeValidUntilGreaterThanOrEqualTo == null ? 43 : this.timeValidUntilGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeValidUntilLessThan == null ? 43 : this.timeValidUntilLessThan.hashCode());
        result = result * 59 + (this.timeUpdatedGreaterThanOrEqualTo == null ? 43 : this.timeUpdatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeUpdatedLessThan == null ? 43 : this.timeUpdatedLessThan.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListFindingsChangeAuditLogsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityAssessmentId = null;
        private Severity severity = null;
        private String findingKey = null;
        private String findingTitle = null;
        private Boolean isRiskDeferred = null;
        private String modifiedBy = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private Date timeValidUntilGreaterThanOrEqualTo = null;
        private Date timeValidUntilLessThan = null;
        private Date timeUpdatedGreaterThanOrEqualTo = null;
        private Date timeUpdatedLessThan = null;
        private String opcRequestId = null;

        public Builder securityAssessmentId(String securityAssessmentId) {
            this.securityAssessmentId = securityAssessmentId;
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder findingKey(String findingKey) {
            this.findingKey = findingKey;
            return this;
        }

        public Builder findingTitle(String findingTitle) {
            this.findingTitle = findingTitle;
            return this;
        }

        public Builder isRiskDeferred(Boolean isRiskDeferred) {
            this.isRiskDeferred = isRiskDeferred;
            return this;
        }

        public Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder timeValidUntilGreaterThanOrEqualTo(Date timeValidUntilGreaterThanOrEqualTo) {
            this.timeValidUntilGreaterThanOrEqualTo = timeValidUntilGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeValidUntilLessThan(Date timeValidUntilLessThan) {
            this.timeValidUntilLessThan = timeValidUntilLessThan;
            return this;
        }

        public Builder timeUpdatedGreaterThanOrEqualTo(Date timeUpdatedGreaterThanOrEqualTo) {
            this.timeUpdatedGreaterThanOrEqualTo = timeUpdatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeUpdatedLessThan(Date timeUpdatedLessThan) {
            this.timeUpdatedLessThan = timeUpdatedLessThan;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListFindingsChangeAuditLogsRequest o) {
            this.securityAssessmentId(o.getSecurityAssessmentId());
            this.severity(o.getSeverity());
            this.findingKey(o.getFindingKey());
            this.findingTitle(o.getFindingTitle());
            this.isRiskDeferred(o.getIsRiskDeferred());
            this.modifiedBy(o.getModifiedBy());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.timeValidUntilGreaterThanOrEqualTo(o.getTimeValidUntilGreaterThanOrEqualTo());
            this.timeValidUntilLessThan(o.getTimeValidUntilLessThan());
            this.timeUpdatedGreaterThanOrEqualTo(o.getTimeUpdatedGreaterThanOrEqualTo());
            this.timeUpdatedLessThan(o.getTimeUpdatedLessThan());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListFindingsChangeAuditLogsRequest build() {
            ListFindingsChangeAuditLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListFindingsChangeAuditLogsRequest buildWithoutInvocationCallback() {
            ListFindingsChangeAuditLogsRequest request = new ListFindingsChangeAuditLogsRequest();
            request.securityAssessmentId = this.securityAssessmentId;
            request.severity = this.severity;
            request.findingKey = this.findingKey;
            request.findingTitle = this.findingTitle;
            request.isRiskDeferred = this.isRiskDeferred;
            request.modifiedBy = this.modifiedBy;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.timeValidUntilGreaterThanOrEqualTo = this.timeValidUntilGreaterThanOrEqualTo;
            request.timeValidUntilLessThan = this.timeValidUntilLessThan;
            request.timeUpdatedGreaterThanOrEqualTo = this.timeUpdatedGreaterThanOrEqualTo;
            request.timeUpdatedLessThan = this.timeUpdatedLessThan;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeUpdated("timeUpdated"),
        ModifiedBy("modifiedBy"),
        IsRiskDeferred("isRiskDeferred"),
        TimeValidUntil("timeValidUntil");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Severity implements BmcEnum
    {
        High("HIGH"),
        Medium("MEDIUM"),
        Low("LOW"),
        Evaluate("EVALUATE"),
        Advisory("ADVISORY"),
        Pass("PASS"),
        Deferred("DEFERRED");

        private final String value;
        private static Map<String, Severity> map;

        private Severity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Severity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Severity: " + key);
        }

        static {
            map = new HashMap<String, Severity>();
            for (Severity v : Severity.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

