/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListGrantsRequest
extends BmcRequest<Void> {
    private String userAssessmentId;
    private String userKey;
    private String grantKey;
    private String grantName;
    private String privilegeType;
    private String privilegeCategory;
    private Integer depthLevel;
    private Integer depthLevelGreaterThanOrEqualTo;
    private Integer depthLevelLessThan;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getUserAssessmentId() {
        return this.userAssessmentId;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public String getGrantKey() {
        return this.grantKey;
    }

    public String getGrantName() {
        return this.grantName;
    }

    public String getPrivilegeType() {
        return this.privilegeType;
    }

    public String getPrivilegeCategory() {
        return this.privilegeCategory;
    }

    public Integer getDepthLevel() {
        return this.depthLevel;
    }

    public Integer getDepthLevelGreaterThanOrEqualTo() {
        return this.depthLevelGreaterThanOrEqualTo;
    }

    public Integer getDepthLevelLessThan() {
        return this.depthLevelLessThan;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().userAssessmentId(this.userAssessmentId).userKey(this.userKey).grantKey(this.grantKey).grantName(this.grantName).privilegeType(this.privilegeType).privilegeCategory(this.privilegeCategory).depthLevel(this.depthLevel).depthLevelGreaterThanOrEqualTo(this.depthLevelGreaterThanOrEqualTo).depthLevelLessThan(this.depthLevelLessThan).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userAssessmentId=").append(String.valueOf(this.userAssessmentId));
        sb.append(",userKey=").append(String.valueOf(this.userKey));
        sb.append(",grantKey=").append(String.valueOf(this.grantKey));
        sb.append(",grantName=").append(String.valueOf(this.grantName));
        sb.append(",privilegeType=").append(String.valueOf(this.privilegeType));
        sb.append(",privilegeCategory=").append(String.valueOf(this.privilegeCategory));
        sb.append(",depthLevel=").append(String.valueOf(this.depthLevel));
        sb.append(",depthLevelGreaterThanOrEqualTo=").append(String.valueOf(this.depthLevelGreaterThanOrEqualTo));
        sb.append(",depthLevelLessThan=").append(String.valueOf(this.depthLevelLessThan));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListGrantsRequest)) {
            return false;
        }
        ListGrantsRequest other = (ListGrantsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userAssessmentId, other.userAssessmentId) && Objects.equals(this.userKey, other.userKey) && Objects.equals(this.grantKey, other.grantKey) && Objects.equals(this.grantName, other.grantName) && Objects.equals(this.privilegeType, other.privilegeType) && Objects.equals(this.privilegeCategory, other.privilegeCategory) && Objects.equals(this.depthLevel, other.depthLevel) && Objects.equals(this.depthLevelGreaterThanOrEqualTo, other.depthLevelGreaterThanOrEqualTo) && Objects.equals(this.depthLevelLessThan, other.depthLevelLessThan) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userAssessmentId == null ? 43 : this.userAssessmentId.hashCode());
        result = result * 59 + (this.userKey == null ? 43 : this.userKey.hashCode());
        result = result * 59 + (this.grantKey == null ? 43 : this.grantKey.hashCode());
        result = result * 59 + (this.grantName == null ? 43 : this.grantName.hashCode());
        result = result * 59 + (this.privilegeType == null ? 43 : this.privilegeType.hashCode());
        result = result * 59 + (this.privilegeCategory == null ? 43 : this.privilegeCategory.hashCode());
        result = result * 59 + (this.depthLevel == null ? 43 : this.depthLevel.hashCode());
        result = result * 59 + (this.depthLevelGreaterThanOrEqualTo == null ? 43 : this.depthLevelGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.depthLevelLessThan == null ? 43 : this.depthLevelLessThan.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListGrantsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userAssessmentId = null;
        private String userKey = null;
        private String grantKey = null;
        private String grantName = null;
        private String privilegeType = null;
        private String privilegeCategory = null;
        private Integer depthLevel = null;
        private Integer depthLevelGreaterThanOrEqualTo = null;
        private Integer depthLevelLessThan = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder userAssessmentId(String userAssessmentId) {
            this.userAssessmentId = userAssessmentId;
            return this;
        }

        public Builder userKey(String userKey) {
            this.userKey = userKey;
            return this;
        }

        public Builder grantKey(String grantKey) {
            this.grantKey = grantKey;
            return this;
        }

        public Builder grantName(String grantName) {
            this.grantName = grantName;
            return this;
        }

        public Builder privilegeType(String privilegeType) {
            this.privilegeType = privilegeType;
            return this;
        }

        public Builder privilegeCategory(String privilegeCategory) {
            this.privilegeCategory = privilegeCategory;
            return this;
        }

        public Builder depthLevel(Integer depthLevel) {
            this.depthLevel = depthLevel;
            return this;
        }

        public Builder depthLevelGreaterThanOrEqualTo(Integer depthLevelGreaterThanOrEqualTo) {
            this.depthLevelGreaterThanOrEqualTo = depthLevelGreaterThanOrEqualTo;
            return this;
        }

        public Builder depthLevelLessThan(Integer depthLevelLessThan) {
            this.depthLevelLessThan = depthLevelLessThan;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListGrantsRequest o) {
            this.userAssessmentId(o.getUserAssessmentId());
            this.userKey(o.getUserKey());
            this.grantKey(o.getGrantKey());
            this.grantName(o.getGrantName());
            this.privilegeType(o.getPrivilegeType());
            this.privilegeCategory(o.getPrivilegeCategory());
            this.depthLevel(o.getDepthLevel());
            this.depthLevelGreaterThanOrEqualTo(o.getDepthLevelGreaterThanOrEqualTo());
            this.depthLevelLessThan(o.getDepthLevelLessThan());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListGrantsRequest build() {
            ListGrantsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListGrantsRequest buildWithoutInvocationCallback() {
            ListGrantsRequest request = new ListGrantsRequest();
            request.userAssessmentId = this.userAssessmentId;
            request.userKey = this.userKey;
            request.grantKey = this.grantKey;
            request.grantName = this.grantName;
            request.privilegeType = this.privilegeType;
            request.privilegeCategory = this.privilegeCategory;
            request.depthLevel = this.depthLevel;
            request.depthLevelGreaterThanOrEqualTo = this.depthLevelGreaterThanOrEqualTo;
            request.depthLevelLessThan = this.depthLevelLessThan;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        GrantName("grantName"),
        GrantType("grantType"),
        PrivilegeCategory("privilegeCategory"),
        DepthLevel("depthLevel"),
        Key("key");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

