/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListMaskingPolicyHealthReportLogsRequest
extends BmcRequest<Void> {
    private String maskingPolicyHealthReportId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private String opcRequestId;
    private SortBy sortBy;
    private MessageType messageType;

    public String getMaskingPolicyHealthReportId() {
        return this.maskingPolicyHealthReportId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Builder toBuilder() {
        return new Builder().maskingPolicyHealthReportId(this.maskingPolicyHealthReportId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId).sortBy(this.sortBy).messageType(this.messageType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maskingPolicyHealthReportId=").append(String.valueOf(this.maskingPolicyHealthReportId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",messageType=").append(String.valueOf((Object)this.messageType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMaskingPolicyHealthReportLogsRequest)) {
            return false;
        }
        ListMaskingPolicyHealthReportLogsRequest other = (ListMaskingPolicyHealthReportLogsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maskingPolicyHealthReportId, other.maskingPolicyHealthReportId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.messageType, (Object)other.messageType);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maskingPolicyHealthReportId == null ? 43 : this.maskingPolicyHealthReportId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.messageType == null ? 43 : this.messageType.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMaskingPolicyHealthReportLogsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maskingPolicyHealthReportId = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;
        private SortBy sortBy = null;
        private MessageType messageType = null;

        public Builder maskingPolicyHealthReportId(String maskingPolicyHealthReportId) {
            this.maskingPolicyHealthReportId = maskingPolicyHealthReportId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder messageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMaskingPolicyHealthReportLogsRequest o) {
            this.maskingPolicyHealthReportId(o.getMaskingPolicyHealthReportId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.sortBy(o.getSortBy());
            this.messageType(o.getMessageType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMaskingPolicyHealthReportLogsRequest build() {
            ListMaskingPolicyHealthReportLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListMaskingPolicyHealthReportLogsRequest buildWithoutInvocationCallback() {
            ListMaskingPolicyHealthReportLogsRequest request = new ListMaskingPolicyHealthReportLogsRequest();
            request.maskingPolicyHealthReportId = this.maskingPolicyHealthReportId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            request.sortBy = this.sortBy;
            request.messageType = this.messageType;
            return request;
        }
    }

    public static enum MessageType implements BmcEnum
    {
        Pass("PASS"),
        Warning("WARNING"),
        Error("ERROR");

        private final String value;
        private static Map<String, MessageType> map;

        private MessageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MessageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid MessageType: " + key);
        }

        static {
            map = new HashMap<String, MessageType>();
            for (MessageType v : MessageType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        LogType("logType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

