/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListWorkRequestsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String operationType;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String resourceId;
    private String targetDatabaseId;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getTargetDatabaseId() {
        return this.targetDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).operationType(this.operationType).sortBy(this.sortBy).sortOrder(this.sortOrder).resourceId(this.resourceId).targetDatabaseId(this.targetDatabaseId).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",operationType=").append(String.valueOf(this.operationType));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",resourceId=").append(String.valueOf(this.resourceId));
        sb.append(",targetDatabaseId=").append(String.valueOf(this.targetDatabaseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListWorkRequestsRequest)) {
            return false;
        }
        ListWorkRequestsRequest other = (ListWorkRequestsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.operationType, other.operationType) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.targetDatabaseId, other.targetDatabaseId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.targetDatabaseId == null ? 43 : this.targetDatabaseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWorkRequestsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String operationType = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String resourceId = null;
        private String targetDatabaseId = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder targetDatabaseId(String targetDatabaseId) {
            this.targetDatabaseId = targetDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.operationType(o.getOperationType());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.resourceId(o.getResourceId());
            this.targetDatabaseId(o.getTargetDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestsRequest build() {
            ListWorkRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListWorkRequestsRequest buildWithoutInvocationCallback() {
            ListWorkRequestsRequest request = new ListWorkRequestsRequest();
            request.compartmentId = this.compartmentId;
            request.operationType = this.operationType;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.resourceId = this.resourceId;
            request.targetDatabaseId = this.targetDatabaseId;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            return request;
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Starttime("STARTTIME"),
        Finishtime("FINISHTIME"),
        Acceptedtime("ACCEPTEDTIME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

