/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.PatchMaskingColumnsDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class PatchMaskingColumnsRequest
extends BmcRequest<PatchMaskingColumnsDetails> {
    private String maskingPolicyId;
    private PatchMaskingColumnsDetails patchMaskingColumnsDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getMaskingPolicyId() {
        return this.maskingPolicyId;
    }

    public PatchMaskingColumnsDetails getPatchMaskingColumnsDetails() {
        return this.patchMaskingColumnsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public PatchMaskingColumnsDetails getBody$() {
        return this.patchMaskingColumnsDetails;
    }

    public Builder toBuilder() {
        return new Builder().maskingPolicyId(this.maskingPolicyId).patchMaskingColumnsDetails(this.patchMaskingColumnsDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maskingPolicyId=").append(String.valueOf(this.maskingPolicyId));
        sb.append(",patchMaskingColumnsDetails=").append(String.valueOf((Object)this.patchMaskingColumnsDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchMaskingColumnsRequest)) {
            return false;
        }
        PatchMaskingColumnsRequest other = (PatchMaskingColumnsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maskingPolicyId, other.maskingPolicyId) && Objects.equals((Object)this.patchMaskingColumnsDetails, (Object)other.patchMaskingColumnsDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maskingPolicyId == null ? 43 : this.maskingPolicyId.hashCode());
        result = result * 59 + (this.patchMaskingColumnsDetails == null ? 43 : this.patchMaskingColumnsDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PatchMaskingColumnsRequest, PatchMaskingColumnsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maskingPolicyId = null;
        private PatchMaskingColumnsDetails patchMaskingColumnsDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder maskingPolicyId(String maskingPolicyId) {
            this.maskingPolicyId = maskingPolicyId;
            return this;
        }

        public Builder patchMaskingColumnsDetails(PatchMaskingColumnsDetails patchMaskingColumnsDetails) {
            this.patchMaskingColumnsDetails = patchMaskingColumnsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PatchMaskingColumnsRequest o) {
            this.maskingPolicyId(o.getMaskingPolicyId());
            this.patchMaskingColumnsDetails(o.getPatchMaskingColumnsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PatchMaskingColumnsRequest build() {
            PatchMaskingColumnsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PatchMaskingColumnsDetails body) {
            this.patchMaskingColumnsDetails(body);
            return this;
        }

        public PatchMaskingColumnsRequest buildWithoutInvocationCallback() {
            PatchMaskingColumnsRequest request = new PatchMaskingColumnsRequest();
            request.maskingPolicyId = this.maskingPolicyId;
            request.patchMaskingColumnsDetails = this.patchMaskingColumnsDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

