/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe;

import com.oracle.bmc.datasafe.DataSafe;
import com.oracle.bmc.datasafe.model.AlertLifecycleState;
import com.oracle.bmc.datasafe.model.AlertPolicyLifecycleState;
import com.oracle.bmc.datasafe.model.AlertPolicyRuleLifecycleState;
import com.oracle.bmc.datasafe.model.AuditArchiveRetrievalLifecycleState;
import com.oracle.bmc.datasafe.model.AuditPolicyLifecycleState;
import com.oracle.bmc.datasafe.model.AuditProfileLifecycleState;
import com.oracle.bmc.datasafe.model.AuditTrailLifecycleState;
import com.oracle.bmc.datasafe.model.DatabaseSecurityConfigLifecycleState;
import com.oracle.bmc.datasafe.model.DiscoveryLifecycleState;
import com.oracle.bmc.datasafe.model.LifecycleState;
import com.oracle.bmc.datasafe.model.MaskingColumnLifecycleState;
import com.oracle.bmc.datasafe.model.MaskingLifecycleState;
import com.oracle.bmc.datasafe.model.MaskingPolicyHealthReport;
import com.oracle.bmc.datasafe.model.ReportDefinitionLifecycleState;
import com.oracle.bmc.datasafe.model.ReportLifecycleState;
import com.oracle.bmc.datasafe.model.SdmMaskingPolicyDifference;
import com.oracle.bmc.datasafe.model.SecurityAssessmentComparison;
import com.oracle.bmc.datasafe.model.SecurityAssessmentLifecycleState;
import com.oracle.bmc.datasafe.model.SecurityPolicyDeploymentLifecycleState;
import com.oracle.bmc.datasafe.model.SecurityPolicyLifecycleState;
import com.oracle.bmc.datasafe.model.SecurityPolicyReportLifecycleState;
import com.oracle.bmc.datasafe.model.SensitiveColumnLifecycleState;
import com.oracle.bmc.datasafe.model.SqlCollectionLifecycleState;
import com.oracle.bmc.datasafe.model.SqlFirewallAllowedSqlLifecycleState;
import com.oracle.bmc.datasafe.model.SqlFirewallPolicyLifecycleState;
import com.oracle.bmc.datasafe.model.TargetDatabaseLifecycleState;
import com.oracle.bmc.datasafe.model.UserAssessmentComparison;
import com.oracle.bmc.datasafe.model.UserAssessmentLifecycleState;
import com.oracle.bmc.datasafe.requests.GetAlertPolicyRequest;
import com.oracle.bmc.datasafe.requests.GetAlertPolicyRuleRequest;
import com.oracle.bmc.datasafe.requests.GetAlertRequest;
import com.oracle.bmc.datasafe.requests.GetAuditArchiveRetrievalRequest;
import com.oracle.bmc.datasafe.requests.GetAuditPolicyRequest;
import com.oracle.bmc.datasafe.requests.GetAuditProfileRequest;
import com.oracle.bmc.datasafe.requests.GetAuditTrailRequest;
import com.oracle.bmc.datasafe.requests.GetDataSafeConfigurationRequest;
import com.oracle.bmc.datasafe.requests.GetDataSafePrivateEndpointRequest;
import com.oracle.bmc.datasafe.requests.GetDatabaseSecurityConfigRequest;
import com.oracle.bmc.datasafe.requests.GetDiscoveryJobRequest;
import com.oracle.bmc.datasafe.requests.GetLibraryMaskingFormatRequest;
import com.oracle.bmc.datasafe.requests.GetMaskingColumnRequest;
import com.oracle.bmc.datasafe.requests.GetMaskingPolicyHealthReportRequest;
import com.oracle.bmc.datasafe.requests.GetMaskingPolicyRequest;
import com.oracle.bmc.datasafe.requests.GetMaskingReportRequest;
import com.oracle.bmc.datasafe.requests.GetOnPremConnectorRequest;
import com.oracle.bmc.datasafe.requests.GetPeerTargetDatabaseRequest;
import com.oracle.bmc.datasafe.requests.GetReportDefinitionRequest;
import com.oracle.bmc.datasafe.requests.GetReportRequest;
import com.oracle.bmc.datasafe.requests.GetSdmMaskingPolicyDifferenceRequest;
import com.oracle.bmc.datasafe.requests.GetSecurityAssessmentComparisonRequest;
import com.oracle.bmc.datasafe.requests.GetSecurityAssessmentRequest;
import com.oracle.bmc.datasafe.requests.GetSecurityPolicyDeploymentRequest;
import com.oracle.bmc.datasafe.requests.GetSecurityPolicyReportRequest;
import com.oracle.bmc.datasafe.requests.GetSecurityPolicyRequest;
import com.oracle.bmc.datasafe.requests.GetSensitiveColumnRequest;
import com.oracle.bmc.datasafe.requests.GetSensitiveDataModelRequest;
import com.oracle.bmc.datasafe.requests.GetSensitiveTypeRequest;
import com.oracle.bmc.datasafe.requests.GetSqlCollectionRequest;
import com.oracle.bmc.datasafe.requests.GetSqlFirewallAllowedSqlRequest;
import com.oracle.bmc.datasafe.requests.GetSqlFirewallPolicyRequest;
import com.oracle.bmc.datasafe.requests.GetTargetAlertPolicyAssociationRequest;
import com.oracle.bmc.datasafe.requests.GetTargetDatabaseRequest;
import com.oracle.bmc.datasafe.requests.GetUserAssessmentComparisonRequest;
import com.oracle.bmc.datasafe.requests.GetUserAssessmentRequest;
import com.oracle.bmc.datasafe.requests.GetWorkRequestRequest;
import com.oracle.bmc.datasafe.responses.GetAlertPolicyResponse;
import com.oracle.bmc.datasafe.responses.GetAlertPolicyRuleResponse;
import com.oracle.bmc.datasafe.responses.GetAlertResponse;
import com.oracle.bmc.datasafe.responses.GetAuditArchiveRetrievalResponse;
import com.oracle.bmc.datasafe.responses.GetAuditPolicyResponse;
import com.oracle.bmc.datasafe.responses.GetAuditProfileResponse;
import com.oracle.bmc.datasafe.responses.GetAuditTrailResponse;
import com.oracle.bmc.datasafe.responses.GetDataSafeConfigurationResponse;
import com.oracle.bmc.datasafe.responses.GetDataSafePrivateEndpointResponse;
import com.oracle.bmc.datasafe.responses.GetDatabaseSecurityConfigResponse;
import com.oracle.bmc.datasafe.responses.GetDiscoveryJobResponse;
import com.oracle.bmc.datasafe.responses.GetLibraryMaskingFormatResponse;
import com.oracle.bmc.datasafe.responses.GetMaskingColumnResponse;
import com.oracle.bmc.datasafe.responses.GetMaskingPolicyHealthReportResponse;
import com.oracle.bmc.datasafe.responses.GetMaskingPolicyResponse;
import com.oracle.bmc.datasafe.responses.GetMaskingReportResponse;
import com.oracle.bmc.datasafe.responses.GetOnPremConnectorResponse;
import com.oracle.bmc.datasafe.responses.GetPeerTargetDatabaseResponse;
import com.oracle.bmc.datasafe.responses.GetReportDefinitionResponse;
import com.oracle.bmc.datasafe.responses.GetReportResponse;
import com.oracle.bmc.datasafe.responses.GetSdmMaskingPolicyDifferenceResponse;
import com.oracle.bmc.datasafe.responses.GetSecurityAssessmentComparisonResponse;
import com.oracle.bmc.datasafe.responses.GetSecurityAssessmentResponse;
import com.oracle.bmc.datasafe.responses.GetSecurityPolicyDeploymentResponse;
import com.oracle.bmc.datasafe.responses.GetSecurityPolicyReportResponse;
import com.oracle.bmc.datasafe.responses.GetSecurityPolicyResponse;
import com.oracle.bmc.datasafe.responses.GetSensitiveColumnResponse;
import com.oracle.bmc.datasafe.responses.GetSensitiveDataModelResponse;
import com.oracle.bmc.datasafe.responses.GetSensitiveTypeResponse;
import com.oracle.bmc.datasafe.responses.GetSqlCollectionResponse;
import com.oracle.bmc.datasafe.responses.GetSqlFirewallAllowedSqlResponse;
import com.oracle.bmc.datasafe.responses.GetSqlFirewallPolicyResponse;
import com.oracle.bmc.datasafe.responses.GetTargetAlertPolicyAssociationResponse;
import com.oracle.bmc.datasafe.responses.GetTargetDatabaseResponse;
import com.oracle.bmc.datasafe.responses.GetUserAssessmentComparisonResponse;
import com.oracle.bmc.datasafe.responses.GetUserAssessmentResponse;
import com.oracle.bmc.datasafe.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DataSafeWaiters {
    private final ExecutorService executorService;
    private final DataSafe client;

    public DataSafeWaiters(ExecutorService executorService, DataSafe client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAlertRequest, GetAlertResponse> forAlert(GetAlertRequest request, AlertLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAlert(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAlertRequest, GetAlertResponse> forAlert(GetAlertRequest request, AlertLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAlert(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAlertRequest, GetAlertResponse> forAlert(GetAlertRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AlertLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAlert(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAlertRequest, GetAlertResponse> forAlert(BmcGenericWaiter waiter, GetAlertRequest request, AlertLifecycleState ... targetStates) {
        final HashSet<AlertLifecycleState> targetStatesSet = new HashSet<AlertLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAlertRequest, GetAlertResponse>(){

            @Override
            public GetAlertResponse apply(GetAlertRequest request) {
                return DataSafeWaiters.this.client.getAlert(request);
            }
        }, (Predicate)new Predicate<GetAlertResponse>(){

            @Override
            public boolean test(GetAlertResponse response) {
                return targetStatesSet.contains((Object)response.getAlert().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetAlertPolicyRequest, GetAlertPolicyResponse> forAlertPolicy(GetAlertPolicyRequest request, AlertPolicyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAlertPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAlertPolicyRequest, GetAlertPolicyResponse> forAlertPolicy(GetAlertPolicyRequest request, AlertPolicyLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAlertPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAlertPolicyRequest, GetAlertPolicyResponse> forAlertPolicy(GetAlertPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AlertPolicyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAlertPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAlertPolicyRequest, GetAlertPolicyResponse> forAlertPolicy(BmcGenericWaiter waiter, GetAlertPolicyRequest request, AlertPolicyLifecycleState ... targetStates) {
        final HashSet<AlertPolicyLifecycleState> targetStatesSet = new HashSet<AlertPolicyLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAlertPolicyRequest, GetAlertPolicyResponse>(){

            @Override
            public GetAlertPolicyResponse apply(GetAlertPolicyRequest request) {
                return DataSafeWaiters.this.client.getAlertPolicy(request);
            }
        }, (Predicate)new Predicate<GetAlertPolicyResponse>(){

            @Override
            public boolean test(GetAlertPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getAlertPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AlertPolicyLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetAlertPolicyRuleRequest, GetAlertPolicyRuleResponse> forAlertPolicyRule(GetAlertPolicyRuleRequest request, AlertPolicyRuleLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAlertPolicyRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAlertPolicyRuleRequest, GetAlertPolicyRuleResponse> forAlertPolicyRule(GetAlertPolicyRuleRequest request, AlertPolicyRuleLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAlertPolicyRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAlertPolicyRuleRequest, GetAlertPolicyRuleResponse> forAlertPolicyRule(GetAlertPolicyRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AlertPolicyRuleLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAlertPolicyRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAlertPolicyRuleRequest, GetAlertPolicyRuleResponse> forAlertPolicyRule(BmcGenericWaiter waiter, GetAlertPolicyRuleRequest request, AlertPolicyRuleLifecycleState ... targetStates) {
        final HashSet<AlertPolicyRuleLifecycleState> targetStatesSet = new HashSet<AlertPolicyRuleLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAlertPolicyRuleRequest, GetAlertPolicyRuleResponse>(){

            @Override
            public GetAlertPolicyRuleResponse apply(GetAlertPolicyRuleRequest request) {
                return DataSafeWaiters.this.client.getAlertPolicyRule(request);
            }
        }, (Predicate)new Predicate<GetAlertPolicyRuleResponse>(){

            @Override
            public boolean test(GetAlertPolicyRuleResponse response) {
                return targetStatesSet.contains((Object)response.getAlertPolicyRule().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetAuditArchiveRetrievalRequest, GetAuditArchiveRetrievalResponse> forAuditArchiveRetrieval(GetAuditArchiveRetrievalRequest request, AuditArchiveRetrievalLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAuditArchiveRetrieval(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAuditArchiveRetrievalRequest, GetAuditArchiveRetrievalResponse> forAuditArchiveRetrieval(GetAuditArchiveRetrievalRequest request, AuditArchiveRetrievalLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAuditArchiveRetrieval(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAuditArchiveRetrievalRequest, GetAuditArchiveRetrievalResponse> forAuditArchiveRetrieval(GetAuditArchiveRetrievalRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AuditArchiveRetrievalLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAuditArchiveRetrieval(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAuditArchiveRetrievalRequest, GetAuditArchiveRetrievalResponse> forAuditArchiveRetrieval(BmcGenericWaiter waiter, GetAuditArchiveRetrievalRequest request, AuditArchiveRetrievalLifecycleState ... targetStates) {
        final HashSet<AuditArchiveRetrievalLifecycleState> targetStatesSet = new HashSet<AuditArchiveRetrievalLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAuditArchiveRetrievalRequest, GetAuditArchiveRetrievalResponse>(){

            @Override
            public GetAuditArchiveRetrievalResponse apply(GetAuditArchiveRetrievalRequest request) {
                return DataSafeWaiters.this.client.getAuditArchiveRetrieval(request);
            }
        }, (Predicate)new Predicate<GetAuditArchiveRetrievalResponse>(){

            @Override
            public boolean test(GetAuditArchiveRetrievalResponse response) {
                return targetStatesSet.contains((Object)response.getAuditArchiveRetrieval().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AuditArchiveRetrievalLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetAuditPolicyRequest, GetAuditPolicyResponse> forAuditPolicy(GetAuditPolicyRequest request, AuditPolicyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAuditPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAuditPolicyRequest, GetAuditPolicyResponse> forAuditPolicy(GetAuditPolicyRequest request, AuditPolicyLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAuditPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAuditPolicyRequest, GetAuditPolicyResponse> forAuditPolicy(GetAuditPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AuditPolicyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAuditPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAuditPolicyRequest, GetAuditPolicyResponse> forAuditPolicy(BmcGenericWaiter waiter, GetAuditPolicyRequest request, AuditPolicyLifecycleState ... targetStates) {
        final HashSet<AuditPolicyLifecycleState> targetStatesSet = new HashSet<AuditPolicyLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAuditPolicyRequest, GetAuditPolicyResponse>(){

            @Override
            public GetAuditPolicyResponse apply(GetAuditPolicyRequest request) {
                return DataSafeWaiters.this.client.getAuditPolicy(request);
            }
        }, (Predicate)new Predicate<GetAuditPolicyResponse>(){

            @Override
            public boolean test(GetAuditPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getAuditPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AuditPolicyLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetAuditProfileRequest, GetAuditProfileResponse> forAuditProfile(GetAuditProfileRequest request, AuditProfileLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAuditProfile(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAuditProfileRequest, GetAuditProfileResponse> forAuditProfile(GetAuditProfileRequest request, AuditProfileLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAuditProfile(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAuditProfileRequest, GetAuditProfileResponse> forAuditProfile(GetAuditProfileRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AuditProfileLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAuditProfile(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAuditProfileRequest, GetAuditProfileResponse> forAuditProfile(BmcGenericWaiter waiter, GetAuditProfileRequest request, AuditProfileLifecycleState ... targetStates) {
        final HashSet<AuditProfileLifecycleState> targetStatesSet = new HashSet<AuditProfileLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAuditProfileRequest, GetAuditProfileResponse>(){

            @Override
            public GetAuditProfileResponse apply(GetAuditProfileRequest request) {
                return DataSafeWaiters.this.client.getAuditProfile(request);
            }
        }, (Predicate)new Predicate<GetAuditProfileResponse>(){

            @Override
            public boolean test(GetAuditProfileResponse response) {
                return targetStatesSet.contains((Object)response.getAuditProfile().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AuditProfileLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetAuditTrailRequest, GetAuditTrailResponse> forAuditTrail(GetAuditTrailRequest request, AuditTrailLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAuditTrail(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAuditTrailRequest, GetAuditTrailResponse> forAuditTrail(GetAuditTrailRequest request, AuditTrailLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAuditTrail(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAuditTrailRequest, GetAuditTrailResponse> forAuditTrail(GetAuditTrailRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AuditTrailLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAuditTrail(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAuditTrailRequest, GetAuditTrailResponse> forAuditTrail(BmcGenericWaiter waiter, GetAuditTrailRequest request, AuditTrailLifecycleState ... targetStates) {
        final HashSet<AuditTrailLifecycleState> targetStatesSet = new HashSet<AuditTrailLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAuditTrailRequest, GetAuditTrailResponse>(){

            @Override
            public GetAuditTrailResponse apply(GetAuditTrailRequest request) {
                return DataSafeWaiters.this.client.getAuditTrail(request);
            }
        }, (Predicate)new Predicate<GetAuditTrailResponse>(){

            @Override
            public boolean test(GetAuditTrailResponse response) {
                return targetStatesSet.contains((Object)response.getAuditTrail().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse> forDataSafeConfiguration(GetDataSafeConfigurationRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataSafeConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse> forDataSafeConfiguration(GetDataSafeConfigurationRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataSafeConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse> forDataSafeConfiguration(GetDataSafeConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataSafeConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse> forDataSafeConfiguration(BmcGenericWaiter waiter, GetDataSafeConfigurationRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse>(){

            @Override
            public GetDataSafeConfigurationResponse apply(GetDataSafeConfigurationRequest request) {
                return DataSafeWaiters.this.client.getDataSafeConfiguration(request);
            }
        }, (Predicate)new Predicate<GetDataSafeConfigurationResponse>(){

            @Override
            public boolean test(GetDataSafeConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getDataSafeConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse> forDataSafePrivateEndpoint(GetDataSafePrivateEndpointRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataSafePrivateEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse> forDataSafePrivateEndpoint(GetDataSafePrivateEndpointRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataSafePrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse> forDataSafePrivateEndpoint(GetDataSafePrivateEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataSafePrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse> forDataSafePrivateEndpoint(BmcGenericWaiter waiter, GetDataSafePrivateEndpointRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse>(){

            @Override
            public GetDataSafePrivateEndpointResponse apply(GetDataSafePrivateEndpointRequest request) {
                return DataSafeWaiters.this.client.getDataSafePrivateEndpoint(request);
            }
        }, (Predicate)new Predicate<GetDataSafePrivateEndpointResponse>(){

            @Override
            public boolean test(GetDataSafePrivateEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getDataSafePrivateEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDatabaseSecurityConfigRequest, GetDatabaseSecurityConfigResponse> forDatabaseSecurityConfig(GetDatabaseSecurityConfigRequest request, DatabaseSecurityConfigLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseSecurityConfig(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDatabaseSecurityConfigRequest, GetDatabaseSecurityConfigResponse> forDatabaseSecurityConfig(GetDatabaseSecurityConfigRequest request, DatabaseSecurityConfigLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDatabaseSecurityConfig(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDatabaseSecurityConfigRequest, GetDatabaseSecurityConfigResponse> forDatabaseSecurityConfig(GetDatabaseSecurityConfigRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DatabaseSecurityConfigLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseSecurityConfig(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDatabaseSecurityConfigRequest, GetDatabaseSecurityConfigResponse> forDatabaseSecurityConfig(BmcGenericWaiter waiter, GetDatabaseSecurityConfigRequest request, DatabaseSecurityConfigLifecycleState ... targetStates) {
        final HashSet<DatabaseSecurityConfigLifecycleState> targetStatesSet = new HashSet<DatabaseSecurityConfigLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDatabaseSecurityConfigRequest, GetDatabaseSecurityConfigResponse>(){

            @Override
            public GetDatabaseSecurityConfigResponse apply(GetDatabaseSecurityConfigRequest request) {
                return DataSafeWaiters.this.client.getDatabaseSecurityConfig(request);
            }
        }, (Predicate)new Predicate<GetDatabaseSecurityConfigResponse>(){

            @Override
            public boolean test(GetDatabaseSecurityConfigResponse response) {
                return targetStatesSet.contains((Object)response.getDatabaseSecurityConfig().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DatabaseSecurityConfigLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDiscoveryJobRequest, GetDiscoveryJobResponse> forDiscoveryJob(GetDiscoveryJobRequest request, DiscoveryLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDiscoveryJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDiscoveryJobRequest, GetDiscoveryJobResponse> forDiscoveryJob(GetDiscoveryJobRequest request, DiscoveryLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDiscoveryJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDiscoveryJobRequest, GetDiscoveryJobResponse> forDiscoveryJob(GetDiscoveryJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DiscoveryLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDiscoveryJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDiscoveryJobRequest, GetDiscoveryJobResponse> forDiscoveryJob(BmcGenericWaiter waiter, GetDiscoveryJobRequest request, DiscoveryLifecycleState ... targetStates) {
        final HashSet<DiscoveryLifecycleState> targetStatesSet = new HashSet<DiscoveryLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDiscoveryJobRequest, GetDiscoveryJobResponse>(){

            @Override
            public GetDiscoveryJobResponse apply(GetDiscoveryJobRequest request) {
                return DataSafeWaiters.this.client.getDiscoveryJob(request);
            }
        }, (Predicate)new Predicate<GetDiscoveryJobResponse>(){

            @Override
            public boolean test(GetDiscoveryJobResponse response) {
                return targetStatesSet.contains((Object)response.getDiscoveryJob().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DiscoveryLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetLibraryMaskingFormatRequest, GetLibraryMaskingFormatResponse> forLibraryMaskingFormat(GetLibraryMaskingFormatRequest request, MaskingLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLibraryMaskingFormat(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLibraryMaskingFormatRequest, GetLibraryMaskingFormatResponse> forLibraryMaskingFormat(GetLibraryMaskingFormatRequest request, MaskingLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLibraryMaskingFormat(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLibraryMaskingFormatRequest, GetLibraryMaskingFormatResponse> forLibraryMaskingFormat(GetLibraryMaskingFormatRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MaskingLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLibraryMaskingFormat(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLibraryMaskingFormatRequest, GetLibraryMaskingFormatResponse> forLibraryMaskingFormat(BmcGenericWaiter waiter, GetLibraryMaskingFormatRequest request, MaskingLifecycleState ... targetStates) {
        final HashSet<MaskingLifecycleState> targetStatesSet = new HashSet<MaskingLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetLibraryMaskingFormatRequest, GetLibraryMaskingFormatResponse>(){

            @Override
            public GetLibraryMaskingFormatResponse apply(GetLibraryMaskingFormatRequest request) {
                return DataSafeWaiters.this.client.getLibraryMaskingFormat(request);
            }
        }, (Predicate)new Predicate<GetLibraryMaskingFormatResponse>(){

            @Override
            public boolean test(GetLibraryMaskingFormatResponse response) {
                return targetStatesSet.contains((Object)response.getLibraryMaskingFormat().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MaskingLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetMaskingColumnRequest, GetMaskingColumnResponse> forMaskingColumn(GetMaskingColumnRequest request, MaskingColumnLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMaskingColumn(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMaskingColumnRequest, GetMaskingColumnResponse> forMaskingColumn(GetMaskingColumnRequest request, MaskingColumnLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMaskingColumn(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMaskingColumnRequest, GetMaskingColumnResponse> forMaskingColumn(GetMaskingColumnRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MaskingColumnLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMaskingColumn(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMaskingColumnRequest, GetMaskingColumnResponse> forMaskingColumn(BmcGenericWaiter waiter, GetMaskingColumnRequest request, MaskingColumnLifecycleState ... targetStates) {
        final HashSet<MaskingColumnLifecycleState> targetStatesSet = new HashSet<MaskingColumnLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMaskingColumnRequest, GetMaskingColumnResponse>(){

            @Override
            public GetMaskingColumnResponse apply(GetMaskingColumnRequest request) {
                return DataSafeWaiters.this.client.getMaskingColumn(request);
            }
        }, (Predicate)new Predicate<GetMaskingColumnResponse>(){

            @Override
            public boolean test(GetMaskingColumnResponse response) {
                return targetStatesSet.contains((Object)response.getMaskingColumn().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetMaskingPolicyRequest, GetMaskingPolicyResponse> forMaskingPolicy(GetMaskingPolicyRequest request, MaskingLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMaskingPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMaskingPolicyRequest, GetMaskingPolicyResponse> forMaskingPolicy(GetMaskingPolicyRequest request, MaskingLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMaskingPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMaskingPolicyRequest, GetMaskingPolicyResponse> forMaskingPolicy(GetMaskingPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MaskingLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMaskingPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMaskingPolicyRequest, GetMaskingPolicyResponse> forMaskingPolicy(BmcGenericWaiter waiter, GetMaskingPolicyRequest request, MaskingLifecycleState ... targetStates) {
        final HashSet<MaskingLifecycleState> targetStatesSet = new HashSet<MaskingLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMaskingPolicyRequest, GetMaskingPolicyResponse>(){

            @Override
            public GetMaskingPolicyResponse apply(GetMaskingPolicyRequest request) {
                return DataSafeWaiters.this.client.getMaskingPolicy(request);
            }
        }, (Predicate)new Predicate<GetMaskingPolicyResponse>(){

            @Override
            public boolean test(GetMaskingPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getMaskingPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MaskingLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetMaskingPolicyHealthReportRequest, GetMaskingPolicyHealthReportResponse> forMaskingPolicyHealthReport(GetMaskingPolicyHealthReportRequest request, MaskingPolicyHealthReport.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMaskingPolicyHealthReport(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMaskingPolicyHealthReportRequest, GetMaskingPolicyHealthReportResponse> forMaskingPolicyHealthReport(GetMaskingPolicyHealthReportRequest request, MaskingPolicyHealthReport.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMaskingPolicyHealthReport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMaskingPolicyHealthReportRequest, GetMaskingPolicyHealthReportResponse> forMaskingPolicyHealthReport(GetMaskingPolicyHealthReportRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MaskingPolicyHealthReport.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMaskingPolicyHealthReport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMaskingPolicyHealthReportRequest, GetMaskingPolicyHealthReportResponse> forMaskingPolicyHealthReport(BmcGenericWaiter waiter, GetMaskingPolicyHealthReportRequest request, MaskingPolicyHealthReport.LifecycleState ... targetStates) {
        final HashSet<MaskingPolicyHealthReport.LifecycleState> targetStatesSet = new HashSet<MaskingPolicyHealthReport.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMaskingPolicyHealthReportRequest, GetMaskingPolicyHealthReportResponse>(){

            @Override
            public GetMaskingPolicyHealthReportResponse apply(GetMaskingPolicyHealthReportRequest request) {
                return DataSafeWaiters.this.client.getMaskingPolicyHealthReport(request);
            }
        }, (Predicate)new Predicate<GetMaskingPolicyHealthReportResponse>(){

            @Override
            public boolean test(GetMaskingPolicyHealthReportResponse response) {
                return targetStatesSet.contains((Object)response.getMaskingPolicyHealthReport().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetMaskingReportRequest, GetMaskingReportResponse> forMaskingReport(GetMaskingReportRequest request, MaskingLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMaskingReport(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMaskingReportRequest, GetMaskingReportResponse> forMaskingReport(GetMaskingReportRequest request, MaskingLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMaskingReport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMaskingReportRequest, GetMaskingReportResponse> forMaskingReport(GetMaskingReportRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MaskingLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMaskingReport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMaskingReportRequest, GetMaskingReportResponse> forMaskingReport(BmcGenericWaiter waiter, GetMaskingReportRequest request, MaskingLifecycleState ... targetStates) {
        final HashSet<MaskingLifecycleState> targetStatesSet = new HashSet<MaskingLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMaskingReportRequest, GetMaskingReportResponse>(){

            @Override
            public GetMaskingReportResponse apply(GetMaskingReportRequest request) {
                return DataSafeWaiters.this.client.getMaskingReport(request);
            }
        }, (Predicate)new Predicate<GetMaskingReportResponse>(){

            @Override
            public boolean test(GetMaskingReportResponse response) {
                return targetStatesSet.contains((Object)response.getMaskingReport().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MaskingLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOnPremConnectorRequest, GetOnPremConnectorResponse> forOnPremConnector(GetOnPremConnectorRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOnPremConnector(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOnPremConnectorRequest, GetOnPremConnectorResponse> forOnPremConnector(GetOnPremConnectorRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOnPremConnector(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOnPremConnectorRequest, GetOnPremConnectorResponse> forOnPremConnector(GetOnPremConnectorRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOnPremConnector(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOnPremConnectorRequest, GetOnPremConnectorResponse> forOnPremConnector(BmcGenericWaiter waiter, GetOnPremConnectorRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOnPremConnectorRequest, GetOnPremConnectorResponse>(){

            @Override
            public GetOnPremConnectorResponse apply(GetOnPremConnectorRequest request) {
                return DataSafeWaiters.this.client.getOnPremConnector(request);
            }
        }, (Predicate)new Predicate<GetOnPremConnectorResponse>(){

            @Override
            public boolean test(GetOnPremConnectorResponse response) {
                return targetStatesSet.contains((Object)response.getOnPremConnector().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetPeerTargetDatabaseRequest, GetPeerTargetDatabaseResponse> forPeerTargetDatabase(GetPeerTargetDatabaseRequest request, TargetDatabaseLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPeerTargetDatabase(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPeerTargetDatabaseRequest, GetPeerTargetDatabaseResponse> forPeerTargetDatabase(GetPeerTargetDatabaseRequest request, TargetDatabaseLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPeerTargetDatabase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPeerTargetDatabaseRequest, GetPeerTargetDatabaseResponse> forPeerTargetDatabase(GetPeerTargetDatabaseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TargetDatabaseLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPeerTargetDatabase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPeerTargetDatabaseRequest, GetPeerTargetDatabaseResponse> forPeerTargetDatabase(BmcGenericWaiter waiter, GetPeerTargetDatabaseRequest request, TargetDatabaseLifecycleState ... targetStates) {
        final HashSet<TargetDatabaseLifecycleState> targetStatesSet = new HashSet<TargetDatabaseLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPeerTargetDatabaseRequest, GetPeerTargetDatabaseResponse>(){

            @Override
            public GetPeerTargetDatabaseResponse apply(GetPeerTargetDatabaseRequest request) {
                return DataSafeWaiters.this.client.getPeerTargetDatabase(request);
            }
        }, (Predicate)new Predicate<GetPeerTargetDatabaseResponse>(){

            @Override
            public boolean test(GetPeerTargetDatabaseResponse response) {
                return targetStatesSet.contains((Object)response.getPeerTargetDatabase().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TargetDatabaseLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetReportRequest, GetReportResponse> forReport(GetReportRequest request, ReportLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forReport(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetReportRequest, GetReportResponse> forReport(GetReportRequest request, ReportLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forReport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetReportRequest, GetReportResponse> forReport(GetReportRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ReportLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forReport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetReportRequest, GetReportResponse> forReport(BmcGenericWaiter waiter, GetReportRequest request, ReportLifecycleState ... targetStates) {
        final HashSet<ReportLifecycleState> targetStatesSet = new HashSet<ReportLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetReportRequest, GetReportResponse>(){

            @Override
            public GetReportResponse apply(GetReportRequest request) {
                return DataSafeWaiters.this.client.getReport(request);
            }
        }, (Predicate)new Predicate<GetReportResponse>(){

            @Override
            public boolean test(GetReportResponse response) {
                return targetStatesSet.contains((Object)response.getReport().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetReportDefinitionRequest, GetReportDefinitionResponse> forReportDefinition(GetReportDefinitionRequest request, ReportDefinitionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forReportDefinition(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetReportDefinitionRequest, GetReportDefinitionResponse> forReportDefinition(GetReportDefinitionRequest request, ReportDefinitionLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forReportDefinition(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetReportDefinitionRequest, GetReportDefinitionResponse> forReportDefinition(GetReportDefinitionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ReportDefinitionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forReportDefinition(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetReportDefinitionRequest, GetReportDefinitionResponse> forReportDefinition(BmcGenericWaiter waiter, GetReportDefinitionRequest request, ReportDefinitionLifecycleState ... targetStates) {
        final HashSet<ReportDefinitionLifecycleState> targetStatesSet = new HashSet<ReportDefinitionLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetReportDefinitionRequest, GetReportDefinitionResponse>(){

            @Override
            public GetReportDefinitionResponse apply(GetReportDefinitionRequest request) {
                return DataSafeWaiters.this.client.getReportDefinition(request);
            }
        }, (Predicate)new Predicate<GetReportDefinitionResponse>(){

            @Override
            public boolean test(GetReportDefinitionResponse response) {
                return targetStatesSet.contains((Object)response.getReportDefinition().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ReportDefinitionLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSdmMaskingPolicyDifferenceRequest, GetSdmMaskingPolicyDifferenceResponse> forSdmMaskingPolicyDifference(GetSdmMaskingPolicyDifferenceRequest request, SdmMaskingPolicyDifference.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSdmMaskingPolicyDifference(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSdmMaskingPolicyDifferenceRequest, GetSdmMaskingPolicyDifferenceResponse> forSdmMaskingPolicyDifference(GetSdmMaskingPolicyDifferenceRequest request, SdmMaskingPolicyDifference.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSdmMaskingPolicyDifference(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSdmMaskingPolicyDifferenceRequest, GetSdmMaskingPolicyDifferenceResponse> forSdmMaskingPolicyDifference(GetSdmMaskingPolicyDifferenceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SdmMaskingPolicyDifference.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSdmMaskingPolicyDifference(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSdmMaskingPolicyDifferenceRequest, GetSdmMaskingPolicyDifferenceResponse> forSdmMaskingPolicyDifference(BmcGenericWaiter waiter, GetSdmMaskingPolicyDifferenceRequest request, SdmMaskingPolicyDifference.LifecycleState ... targetStates) {
        final HashSet<SdmMaskingPolicyDifference.LifecycleState> targetStatesSet = new HashSet<SdmMaskingPolicyDifference.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSdmMaskingPolicyDifferenceRequest, GetSdmMaskingPolicyDifferenceResponse>(){

            @Override
            public GetSdmMaskingPolicyDifferenceResponse apply(GetSdmMaskingPolicyDifferenceRequest request) {
                return DataSafeWaiters.this.client.getSdmMaskingPolicyDifference(request);
            }
        }, (Predicate)new Predicate<GetSdmMaskingPolicyDifferenceResponse>(){

            @Override
            public boolean test(GetSdmMaskingPolicyDifferenceResponse response) {
                return targetStatesSet.contains((Object)response.getSdmMaskingPolicyDifference().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SdmMaskingPolicyDifference.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSecurityAssessmentRequest, GetSecurityAssessmentResponse> forSecurityAssessment(GetSecurityAssessmentRequest request, SecurityAssessmentLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityAssessment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityAssessmentRequest, GetSecurityAssessmentResponse> forSecurityAssessment(GetSecurityAssessmentRequest request, SecurityAssessmentLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityAssessment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityAssessmentRequest, GetSecurityAssessmentResponse> forSecurityAssessment(GetSecurityAssessmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SecurityAssessmentLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityAssessment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityAssessmentRequest, GetSecurityAssessmentResponse> forSecurityAssessment(BmcGenericWaiter waiter, GetSecurityAssessmentRequest request, SecurityAssessmentLifecycleState ... targetStates) {
        final HashSet<SecurityAssessmentLifecycleState> targetStatesSet = new HashSet<SecurityAssessmentLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityAssessmentRequest, GetSecurityAssessmentResponse>(){

            @Override
            public GetSecurityAssessmentResponse apply(GetSecurityAssessmentRequest request) {
                return DataSafeWaiters.this.client.getSecurityAssessment(request);
            }
        }, (Predicate)new Predicate<GetSecurityAssessmentResponse>(){

            @Override
            public boolean test(GetSecurityAssessmentResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityAssessment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SecurityAssessmentLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSecurityAssessmentComparisonRequest, GetSecurityAssessmentComparisonResponse> forSecurityAssessmentComparison(GetSecurityAssessmentComparisonRequest request, SecurityAssessmentComparison.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityAssessmentComparison(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityAssessmentComparisonRequest, GetSecurityAssessmentComparisonResponse> forSecurityAssessmentComparison(GetSecurityAssessmentComparisonRequest request, SecurityAssessmentComparison.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityAssessmentComparison(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityAssessmentComparisonRequest, GetSecurityAssessmentComparisonResponse> forSecurityAssessmentComparison(GetSecurityAssessmentComparisonRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SecurityAssessmentComparison.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSecurityAssessmentComparison(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityAssessmentComparisonRequest, GetSecurityAssessmentComparisonResponse> forSecurityAssessmentComparison(BmcGenericWaiter waiter, GetSecurityAssessmentComparisonRequest request, SecurityAssessmentComparison.LifecycleState ... targetStates) {
        final HashSet<SecurityAssessmentComparison.LifecycleState> targetStatesSet = new HashSet<SecurityAssessmentComparison.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityAssessmentComparisonRequest, GetSecurityAssessmentComparisonResponse>(){

            @Override
            public GetSecurityAssessmentComparisonResponse apply(GetSecurityAssessmentComparisonRequest request) {
                return DataSafeWaiters.this.client.getSecurityAssessmentComparison(request);
            }
        }, (Predicate)new Predicate<GetSecurityAssessmentComparisonResponse>(){

            @Override
            public boolean test(GetSecurityAssessmentComparisonResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityAssessmentComparison().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetSecurityPolicyRequest, GetSecurityPolicyResponse> forSecurityPolicy(GetSecurityPolicyRequest request, SecurityPolicyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityPolicyRequest, GetSecurityPolicyResponse> forSecurityPolicy(GetSecurityPolicyRequest request, SecurityPolicyLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityPolicyRequest, GetSecurityPolicyResponse> forSecurityPolicy(GetSecurityPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SecurityPolicyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityPolicyRequest, GetSecurityPolicyResponse> forSecurityPolicy(BmcGenericWaiter waiter, GetSecurityPolicyRequest request, SecurityPolicyLifecycleState ... targetStates) {
        final HashSet<SecurityPolicyLifecycleState> targetStatesSet = new HashSet<SecurityPolicyLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityPolicyRequest, GetSecurityPolicyResponse>(){

            @Override
            public GetSecurityPolicyResponse apply(GetSecurityPolicyRequest request) {
                return DataSafeWaiters.this.client.getSecurityPolicy(request);
            }
        }, (Predicate)new Predicate<GetSecurityPolicyResponse>(){

            @Override
            public boolean test(GetSecurityPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SecurityPolicyLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSecurityPolicyDeploymentRequest, GetSecurityPolicyDeploymentResponse> forSecurityPolicyDeployment(GetSecurityPolicyDeploymentRequest request, SecurityPolicyDeploymentLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityPolicyDeployment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityPolicyDeploymentRequest, GetSecurityPolicyDeploymentResponse> forSecurityPolicyDeployment(GetSecurityPolicyDeploymentRequest request, SecurityPolicyDeploymentLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityPolicyDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityPolicyDeploymentRequest, GetSecurityPolicyDeploymentResponse> forSecurityPolicyDeployment(GetSecurityPolicyDeploymentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SecurityPolicyDeploymentLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityPolicyDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityPolicyDeploymentRequest, GetSecurityPolicyDeploymentResponse> forSecurityPolicyDeployment(BmcGenericWaiter waiter, GetSecurityPolicyDeploymentRequest request, SecurityPolicyDeploymentLifecycleState ... targetStates) {
        final HashSet<SecurityPolicyDeploymentLifecycleState> targetStatesSet = new HashSet<SecurityPolicyDeploymentLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityPolicyDeploymentRequest, GetSecurityPolicyDeploymentResponse>(){

            @Override
            public GetSecurityPolicyDeploymentResponse apply(GetSecurityPolicyDeploymentRequest request) {
                return DataSafeWaiters.this.client.getSecurityPolicyDeployment(request);
            }
        }, (Predicate)new Predicate<GetSecurityPolicyDeploymentResponse>(){

            @Override
            public boolean test(GetSecurityPolicyDeploymentResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityPolicyDeployment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SecurityPolicyDeploymentLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSecurityPolicyReportRequest, GetSecurityPolicyReportResponse> forSecurityPolicyReport(GetSecurityPolicyReportRequest request, SecurityPolicyReportLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityPolicyReport(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityPolicyReportRequest, GetSecurityPolicyReportResponse> forSecurityPolicyReport(GetSecurityPolicyReportRequest request, SecurityPolicyReportLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityPolicyReport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityPolicyReportRequest, GetSecurityPolicyReportResponse> forSecurityPolicyReport(GetSecurityPolicyReportRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SecurityPolicyReportLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityPolicyReport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityPolicyReportRequest, GetSecurityPolicyReportResponse> forSecurityPolicyReport(BmcGenericWaiter waiter, GetSecurityPolicyReportRequest request, SecurityPolicyReportLifecycleState ... targetStates) {
        final HashSet<SecurityPolicyReportLifecycleState> targetStatesSet = new HashSet<SecurityPolicyReportLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityPolicyReportRequest, GetSecurityPolicyReportResponse>(){

            @Override
            public GetSecurityPolicyReportResponse apply(GetSecurityPolicyReportRequest request) {
                return DataSafeWaiters.this.client.getSecurityPolicyReport(request);
            }
        }, (Predicate)new Predicate<GetSecurityPolicyReportResponse>(){

            @Override
            public boolean test(GetSecurityPolicyReportResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityPolicyReport().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SecurityPolicyReportLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSensitiveColumnRequest, GetSensitiveColumnResponse> forSensitiveColumn(GetSensitiveColumnRequest request, SensitiveColumnLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSensitiveColumn(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSensitiveColumnRequest, GetSensitiveColumnResponse> forSensitiveColumn(GetSensitiveColumnRequest request, SensitiveColumnLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSensitiveColumn(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSensitiveColumnRequest, GetSensitiveColumnResponse> forSensitiveColumn(GetSensitiveColumnRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SensitiveColumnLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSensitiveColumn(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSensitiveColumnRequest, GetSensitiveColumnResponse> forSensitiveColumn(BmcGenericWaiter waiter, GetSensitiveColumnRequest request, SensitiveColumnLifecycleState ... targetStates) {
        final HashSet<SensitiveColumnLifecycleState> targetStatesSet = new HashSet<SensitiveColumnLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSensitiveColumnRequest, GetSensitiveColumnResponse>(){

            @Override
            public GetSensitiveColumnResponse apply(GetSensitiveColumnRequest request) {
                return DataSafeWaiters.this.client.getSensitiveColumn(request);
            }
        }, (Predicate)new Predicate<GetSensitiveColumnResponse>(){

            @Override
            public boolean test(GetSensitiveColumnResponse response) {
                return targetStatesSet.contains((Object)response.getSensitiveColumn().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetSensitiveDataModelRequest, GetSensitiveDataModelResponse> forSensitiveDataModel(GetSensitiveDataModelRequest request, DiscoveryLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSensitiveDataModel(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSensitiveDataModelRequest, GetSensitiveDataModelResponse> forSensitiveDataModel(GetSensitiveDataModelRequest request, DiscoveryLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSensitiveDataModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSensitiveDataModelRequest, GetSensitiveDataModelResponse> forSensitiveDataModel(GetSensitiveDataModelRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DiscoveryLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSensitiveDataModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSensitiveDataModelRequest, GetSensitiveDataModelResponse> forSensitiveDataModel(BmcGenericWaiter waiter, GetSensitiveDataModelRequest request, DiscoveryLifecycleState ... targetStates) {
        final HashSet<DiscoveryLifecycleState> targetStatesSet = new HashSet<DiscoveryLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSensitiveDataModelRequest, GetSensitiveDataModelResponse>(){

            @Override
            public GetSensitiveDataModelResponse apply(GetSensitiveDataModelRequest request) {
                return DataSafeWaiters.this.client.getSensitiveDataModel(request);
            }
        }, (Predicate)new Predicate<GetSensitiveDataModelResponse>(){

            @Override
            public boolean test(GetSensitiveDataModelResponse response) {
                return targetStatesSet.contains((Object)response.getSensitiveDataModel().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DiscoveryLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSensitiveTypeRequest, GetSensitiveTypeResponse> forSensitiveType(GetSensitiveTypeRequest request, DiscoveryLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSensitiveType(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSensitiveTypeRequest, GetSensitiveTypeResponse> forSensitiveType(GetSensitiveTypeRequest request, DiscoveryLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSensitiveType(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSensitiveTypeRequest, GetSensitiveTypeResponse> forSensitiveType(GetSensitiveTypeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DiscoveryLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSensitiveType(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSensitiveTypeRequest, GetSensitiveTypeResponse> forSensitiveType(BmcGenericWaiter waiter, GetSensitiveTypeRequest request, DiscoveryLifecycleState ... targetStates) {
        final HashSet<DiscoveryLifecycleState> targetStatesSet = new HashSet<DiscoveryLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSensitiveTypeRequest, GetSensitiveTypeResponse>(){

            @Override
            public GetSensitiveTypeResponse apply(GetSensitiveTypeRequest request) {
                return DataSafeWaiters.this.client.getSensitiveType(request);
            }
        }, (Predicate)new Predicate<GetSensitiveTypeResponse>(){

            @Override
            public boolean test(GetSensitiveTypeResponse response) {
                return targetStatesSet.contains((Object)response.getSensitiveType().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DiscoveryLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSqlCollectionRequest, GetSqlCollectionResponse> forSqlCollection(GetSqlCollectionRequest request, SqlCollectionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSqlCollection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSqlCollectionRequest, GetSqlCollectionResponse> forSqlCollection(GetSqlCollectionRequest request, SqlCollectionLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSqlCollection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSqlCollectionRequest, GetSqlCollectionResponse> forSqlCollection(GetSqlCollectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SqlCollectionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSqlCollection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSqlCollectionRequest, GetSqlCollectionResponse> forSqlCollection(BmcGenericWaiter waiter, GetSqlCollectionRequest request, SqlCollectionLifecycleState ... targetStates) {
        final HashSet<SqlCollectionLifecycleState> targetStatesSet = new HashSet<SqlCollectionLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSqlCollectionRequest, GetSqlCollectionResponse>(){

            @Override
            public GetSqlCollectionResponse apply(GetSqlCollectionRequest request) {
                return DataSafeWaiters.this.client.getSqlCollection(request);
            }
        }, (Predicate)new Predicate<GetSqlCollectionResponse>(){

            @Override
            public boolean test(GetSqlCollectionResponse response) {
                return targetStatesSet.contains((Object)response.getSqlCollection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SqlCollectionLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSqlFirewallAllowedSqlRequest, GetSqlFirewallAllowedSqlResponse> forSqlFirewallAllowedSql(GetSqlFirewallAllowedSqlRequest request, SqlFirewallAllowedSqlLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSqlFirewallAllowedSql(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSqlFirewallAllowedSqlRequest, GetSqlFirewallAllowedSqlResponse> forSqlFirewallAllowedSql(GetSqlFirewallAllowedSqlRequest request, SqlFirewallAllowedSqlLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSqlFirewallAllowedSql(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSqlFirewallAllowedSqlRequest, GetSqlFirewallAllowedSqlResponse> forSqlFirewallAllowedSql(GetSqlFirewallAllowedSqlRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SqlFirewallAllowedSqlLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSqlFirewallAllowedSql(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSqlFirewallAllowedSqlRequest, GetSqlFirewallAllowedSqlResponse> forSqlFirewallAllowedSql(BmcGenericWaiter waiter, GetSqlFirewallAllowedSqlRequest request, SqlFirewallAllowedSqlLifecycleState ... targetStates) {
        final HashSet<SqlFirewallAllowedSqlLifecycleState> targetStatesSet = new HashSet<SqlFirewallAllowedSqlLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSqlFirewallAllowedSqlRequest, GetSqlFirewallAllowedSqlResponse>(){

            @Override
            public GetSqlFirewallAllowedSqlResponse apply(GetSqlFirewallAllowedSqlRequest request) {
                return DataSafeWaiters.this.client.getSqlFirewallAllowedSql(request);
            }
        }, (Predicate)new Predicate<GetSqlFirewallAllowedSqlResponse>(){

            @Override
            public boolean test(GetSqlFirewallAllowedSqlResponse response) {
                return targetStatesSet.contains((Object)response.getSqlFirewallAllowedSql().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SqlFirewallAllowedSqlLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSqlFirewallPolicyRequest, GetSqlFirewallPolicyResponse> forSqlFirewallPolicy(GetSqlFirewallPolicyRequest request, SqlFirewallPolicyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSqlFirewallPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSqlFirewallPolicyRequest, GetSqlFirewallPolicyResponse> forSqlFirewallPolicy(GetSqlFirewallPolicyRequest request, SqlFirewallPolicyLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSqlFirewallPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSqlFirewallPolicyRequest, GetSqlFirewallPolicyResponse> forSqlFirewallPolicy(GetSqlFirewallPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SqlFirewallPolicyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSqlFirewallPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSqlFirewallPolicyRequest, GetSqlFirewallPolicyResponse> forSqlFirewallPolicy(BmcGenericWaiter waiter, GetSqlFirewallPolicyRequest request, SqlFirewallPolicyLifecycleState ... targetStates) {
        final HashSet<SqlFirewallPolicyLifecycleState> targetStatesSet = new HashSet<SqlFirewallPolicyLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSqlFirewallPolicyRequest, GetSqlFirewallPolicyResponse>(){

            @Override
            public GetSqlFirewallPolicyResponse apply(GetSqlFirewallPolicyRequest request) {
                return DataSafeWaiters.this.client.getSqlFirewallPolicy(request);
            }
        }, (Predicate)new Predicate<GetSqlFirewallPolicyResponse>(){

            @Override
            public boolean test(GetSqlFirewallPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getSqlFirewallPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SqlFirewallPolicyLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTargetAlertPolicyAssociationRequest, GetTargetAlertPolicyAssociationResponse> forTargetAlertPolicyAssociation(GetTargetAlertPolicyAssociationRequest request, AlertPolicyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetAlertPolicyAssociation(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTargetAlertPolicyAssociationRequest, GetTargetAlertPolicyAssociationResponse> forTargetAlertPolicyAssociation(GetTargetAlertPolicyAssociationRequest request, AlertPolicyLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTargetAlertPolicyAssociation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTargetAlertPolicyAssociationRequest, GetTargetAlertPolicyAssociationResponse> forTargetAlertPolicyAssociation(GetTargetAlertPolicyAssociationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AlertPolicyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetAlertPolicyAssociation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTargetAlertPolicyAssociationRequest, GetTargetAlertPolicyAssociationResponse> forTargetAlertPolicyAssociation(BmcGenericWaiter waiter, GetTargetAlertPolicyAssociationRequest request, AlertPolicyLifecycleState ... targetStates) {
        final HashSet<AlertPolicyLifecycleState> targetStatesSet = new HashSet<AlertPolicyLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTargetAlertPolicyAssociationRequest, GetTargetAlertPolicyAssociationResponse>(){

            @Override
            public GetTargetAlertPolicyAssociationResponse apply(GetTargetAlertPolicyAssociationRequest request) {
                return DataSafeWaiters.this.client.getTargetAlertPolicyAssociation(request);
            }
        }, (Predicate)new Predicate<GetTargetAlertPolicyAssociationResponse>(){

            @Override
            public boolean test(GetTargetAlertPolicyAssociationResponse response) {
                return targetStatesSet.contains((Object)response.getTargetAlertPolicyAssociation().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AlertPolicyLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTargetDatabaseRequest, GetTargetDatabaseResponse> forTargetDatabase(GetTargetDatabaseRequest request, TargetDatabaseLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetDatabase(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTargetDatabaseRequest, GetTargetDatabaseResponse> forTargetDatabase(GetTargetDatabaseRequest request, TargetDatabaseLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTargetDatabase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTargetDatabaseRequest, GetTargetDatabaseResponse> forTargetDatabase(GetTargetDatabaseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TargetDatabaseLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetDatabase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTargetDatabaseRequest, GetTargetDatabaseResponse> forTargetDatabase(BmcGenericWaiter waiter, GetTargetDatabaseRequest request, TargetDatabaseLifecycleState ... targetStates) {
        final HashSet<TargetDatabaseLifecycleState> targetStatesSet = new HashSet<TargetDatabaseLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTargetDatabaseRequest, GetTargetDatabaseResponse>(){

            @Override
            public GetTargetDatabaseResponse apply(GetTargetDatabaseRequest request) {
                return DataSafeWaiters.this.client.getTargetDatabase(request);
            }
        }, (Predicate)new Predicate<GetTargetDatabaseResponse>(){

            @Override
            public boolean test(GetTargetDatabaseResponse response) {
                return targetStatesSet.contains((Object)response.getTargetDatabase().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TargetDatabaseLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetUserAssessmentRequest, GetUserAssessmentResponse> forUserAssessment(GetUserAssessmentRequest request, UserAssessmentLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forUserAssessment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetUserAssessmentRequest, GetUserAssessmentResponse> forUserAssessment(GetUserAssessmentRequest request, UserAssessmentLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forUserAssessment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetUserAssessmentRequest, GetUserAssessmentResponse> forUserAssessment(GetUserAssessmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, UserAssessmentLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forUserAssessment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetUserAssessmentRequest, GetUserAssessmentResponse> forUserAssessment(BmcGenericWaiter waiter, GetUserAssessmentRequest request, UserAssessmentLifecycleState ... targetStates) {
        final HashSet<UserAssessmentLifecycleState> targetStatesSet = new HashSet<UserAssessmentLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetUserAssessmentRequest, GetUserAssessmentResponse>(){

            @Override
            public GetUserAssessmentResponse apply(GetUserAssessmentRequest request) {
                return DataSafeWaiters.this.client.getUserAssessment(request);
            }
        }, (Predicate)new Predicate<GetUserAssessmentResponse>(){

            @Override
            public boolean test(GetUserAssessmentResponse response) {
                return targetStatesSet.contains((Object)response.getUserAssessment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)UserAssessmentLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetUserAssessmentComparisonRequest, GetUserAssessmentComparisonResponse> forUserAssessmentComparison(GetUserAssessmentComparisonRequest request, UserAssessmentComparison.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forUserAssessmentComparison(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetUserAssessmentComparisonRequest, GetUserAssessmentComparisonResponse> forUserAssessmentComparison(GetUserAssessmentComparisonRequest request, UserAssessmentComparison.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forUserAssessmentComparison(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetUserAssessmentComparisonRequest, GetUserAssessmentComparisonResponse> forUserAssessmentComparison(GetUserAssessmentComparisonRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, UserAssessmentComparison.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forUserAssessmentComparison(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetUserAssessmentComparisonRequest, GetUserAssessmentComparisonResponse> forUserAssessmentComparison(BmcGenericWaiter waiter, GetUserAssessmentComparisonRequest request, UserAssessmentComparison.LifecycleState ... targetStates) {
        final HashSet<UserAssessmentComparison.LifecycleState> targetStatesSet = new HashSet<UserAssessmentComparison.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetUserAssessmentComparisonRequest, GetUserAssessmentComparisonResponse>(){

            @Override
            public GetUserAssessmentComparisonResponse apply(GetUserAssessmentComparisonRequest request) {
                return DataSafeWaiters.this.client.getUserAssessmentComparison(request);
            }
        }, (Predicate)new Predicate<GetUserAssessmentComparisonResponse>(){

            @Override
            public boolean test(GetUserAssessmentComparisonResponse response) {
                return targetStatesSet.contains((Object)response.getUserAssessmentComparison().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DataSafeWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

