/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AccessType implements BmcEnum
{
    Select("SELECT"),
    Update("UPDATE"),
    Insert("INSERT"),
    Delete("DELETE"),
    Owner("OWNER"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, AccessType> map;

    private AccessType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static AccessType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'AccessType', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(AccessType.class);
        map = new HashMap<String, AccessType>();
        for (AccessType v : AccessType.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

