/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AuditTrailSource implements BmcEnum
{
    Table("TABLE"),
    File("FILE"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, AuditTrailSource> map;

    private AuditTrailSource(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static AuditTrailSource create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'AuditTrailSource', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(AuditTrailSource.class);
        map = new HashMap<String, AuditTrailSource>();
        for (AuditTrailSource v : AuditTrailSource.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

