/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.AlertPolicyType;
import com.oracle.bmc.datasafe.model.AlertSeverity;
import com.oracle.bmc.datasafe.model.CreateAlertPolicyRuleDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateAlertPolicyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="alertPolicyType")
    private final AlertPolicyType alertPolicyType;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="severity")
    private final AlertSeverity severity;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="alertPolicyRuleDetails")
    private final List<CreateAlertPolicyRuleDetails> alertPolicyRuleDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"alertPolicyType", "displayName", "description", "severity", "compartmentId", "alertPolicyRuleDetails", "freeformTags", "definedTags"})
    public CreateAlertPolicyDetails(AlertPolicyType alertPolicyType, String displayName, String description, AlertSeverity severity, String compartmentId, List<CreateAlertPolicyRuleDetails> alertPolicyRuleDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.alertPolicyType = alertPolicyType;
        this.displayName = displayName;
        this.description = description;
        this.severity = severity;
        this.compartmentId = compartmentId;
        this.alertPolicyRuleDetails = alertPolicyRuleDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AlertPolicyType getAlertPolicyType() {
        return this.alertPolicyType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public AlertSeverity getSeverity() {
        return this.severity;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<CreateAlertPolicyRuleDetails> getAlertPolicyRuleDetails() {
        return this.alertPolicyRuleDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateAlertPolicyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("alertPolicyType=").append(String.valueOf((Object)this.alertPolicyType));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", alertPolicyRuleDetails=").append(String.valueOf(this.alertPolicyRuleDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAlertPolicyDetails)) {
            return false;
        }
        CreateAlertPolicyDetails other = (CreateAlertPolicyDetails)((Object)o);
        return Objects.equals((Object)this.alertPolicyType, (Object)other.alertPolicyType) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.alertPolicyRuleDetails, other.alertPolicyRuleDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.alertPolicyType == null ? 43 : this.alertPolicyType.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.alertPolicyRuleDetails == null ? 43 : this.alertPolicyRuleDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="alertPolicyType")
        private AlertPolicyType alertPolicyType;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="severity")
        private AlertSeverity severity;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="alertPolicyRuleDetails")
        private List<CreateAlertPolicyRuleDetails> alertPolicyRuleDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder alertPolicyType(AlertPolicyType alertPolicyType) {
            this.alertPolicyType = alertPolicyType;
            this.__explicitlySet__.add("alertPolicyType");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder severity(AlertSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder alertPolicyRuleDetails(List<CreateAlertPolicyRuleDetails> alertPolicyRuleDetails) {
            this.alertPolicyRuleDetails = alertPolicyRuleDetails;
            this.__explicitlySet__.add("alertPolicyRuleDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateAlertPolicyDetails build() {
            CreateAlertPolicyDetails model = new CreateAlertPolicyDetails(this.alertPolicyType, this.displayName, this.description, this.severity, this.compartmentId, this.alertPolicyRuleDetails, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateAlertPolicyDetails model) {
            if (model.wasPropertyExplicitlySet("alertPolicyType")) {
                this.alertPolicyType(model.getAlertPolicyType());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("alertPolicyRuleDetails")) {
                this.alertPolicyRuleDetails(model.getAlertPolicyRuleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

