/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.AccessType;
import com.oracle.bmc.datasafe.model.PrivilegeGrantableOption;
import com.oracle.bmc.datasafe.model.PrivilegeName;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseViewAccessEntry
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="grantee")
    private final String grantee;
    @JsonProperty(value="accessType")
    private final AccessType accessType;
    @JsonProperty(value="tableSchema")
    private final String tableSchema;
    @JsonProperty(value="tableName")
    private final String tableName;
    @JsonProperty(value="privilegeType")
    private final String privilegeType;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="privilege")
    private final PrivilegeName privilege;
    @JsonProperty(value="privilegeGrantable")
    private final PrivilegeGrantableOption privilegeGrantable;
    @JsonProperty(value="grantFromRole")
    private final String grantFromRole;
    @JsonProperty(value="viewSchema")
    private final String viewSchema;
    @JsonProperty(value="viewName")
    private final String viewName;
    @JsonProperty(value="viewText")
    private final String viewText;
    @JsonProperty(value="columnName")
    private final String columnName;
    @JsonProperty(value="grantor")
    private final String grantor;
    @JsonProperty(value="isAccessConstrainedByDatabaseVault")
    private final Boolean isAccessConstrainedByDatabaseVault;
    @JsonProperty(value="isAccessConstrainedByVirtualPrivateDatabase")
    private final Boolean isAccessConstrainedByVirtualPrivateDatabase;
    @JsonProperty(value="isAccessConstrainedByRedaction")
    private final Boolean isAccessConstrainedByRedaction;
    @JsonProperty(value="isAccessConstrainedByRealApplicationSecurity")
    private final Boolean isAccessConstrainedByRealApplicationSecurity;
    @JsonProperty(value="isAccessConstrainedBySqlFirewall")
    private final Boolean isAccessConstrainedBySqlFirewall;

    @Deprecated
    @ConstructorProperties(value={"key", "grantee", "accessType", "tableSchema", "tableName", "privilegeType", "targetId", "privilege", "privilegeGrantable", "grantFromRole", "viewSchema", "viewName", "viewText", "columnName", "grantor", "isAccessConstrainedByDatabaseVault", "isAccessConstrainedByVirtualPrivateDatabase", "isAccessConstrainedByRedaction", "isAccessConstrainedByRealApplicationSecurity", "isAccessConstrainedBySqlFirewall"})
    public DatabaseViewAccessEntry(String key, String grantee, AccessType accessType, String tableSchema, String tableName, String privilegeType, String targetId, PrivilegeName privilege, PrivilegeGrantableOption privilegeGrantable, String grantFromRole, String viewSchema, String viewName, String viewText, String columnName, String grantor, Boolean isAccessConstrainedByDatabaseVault, Boolean isAccessConstrainedByVirtualPrivateDatabase, Boolean isAccessConstrainedByRedaction, Boolean isAccessConstrainedByRealApplicationSecurity, Boolean isAccessConstrainedBySqlFirewall) {
        this.key = key;
        this.grantee = grantee;
        this.accessType = accessType;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
        this.privilegeType = privilegeType;
        this.targetId = targetId;
        this.privilege = privilege;
        this.privilegeGrantable = privilegeGrantable;
        this.grantFromRole = grantFromRole;
        this.viewSchema = viewSchema;
        this.viewName = viewName;
        this.viewText = viewText;
        this.columnName = columnName;
        this.grantor = grantor;
        this.isAccessConstrainedByDatabaseVault = isAccessConstrainedByDatabaseVault;
        this.isAccessConstrainedByVirtualPrivateDatabase = isAccessConstrainedByVirtualPrivateDatabase;
        this.isAccessConstrainedByRedaction = isAccessConstrainedByRedaction;
        this.isAccessConstrainedByRealApplicationSecurity = isAccessConstrainedByRealApplicationSecurity;
        this.isAccessConstrainedBySqlFirewall = isAccessConstrainedBySqlFirewall;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrivilegeType() {
        return this.privilegeType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public PrivilegeName getPrivilege() {
        return this.privilege;
    }

    public PrivilegeGrantableOption getPrivilegeGrantable() {
        return this.privilegeGrantable;
    }

    public String getGrantFromRole() {
        return this.grantFromRole;
    }

    public String getViewSchema() {
        return this.viewSchema;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getViewText() {
        return this.viewText;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public Boolean getIsAccessConstrainedByDatabaseVault() {
        return this.isAccessConstrainedByDatabaseVault;
    }

    public Boolean getIsAccessConstrainedByVirtualPrivateDatabase() {
        return this.isAccessConstrainedByVirtualPrivateDatabase;
    }

    public Boolean getIsAccessConstrainedByRedaction() {
        return this.isAccessConstrainedByRedaction;
    }

    public Boolean getIsAccessConstrainedByRealApplicationSecurity() {
        return this.isAccessConstrainedByRealApplicationSecurity;
    }

    public Boolean getIsAccessConstrainedBySqlFirewall() {
        return this.isAccessConstrainedBySqlFirewall;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseViewAccessEntry(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", grantee=").append(String.valueOf(this.grantee));
        sb.append(", accessType=").append(String.valueOf((Object)this.accessType));
        sb.append(", tableSchema=").append(String.valueOf(this.tableSchema));
        sb.append(", tableName=").append(String.valueOf(this.tableName));
        sb.append(", privilegeType=").append(String.valueOf(this.privilegeType));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", privilege=").append(String.valueOf((Object)this.privilege));
        sb.append(", privilegeGrantable=").append(String.valueOf((Object)this.privilegeGrantable));
        sb.append(", grantFromRole=").append(String.valueOf(this.grantFromRole));
        sb.append(", viewSchema=").append(String.valueOf(this.viewSchema));
        sb.append(", viewName=").append(String.valueOf(this.viewName));
        sb.append(", viewText=").append(String.valueOf(this.viewText));
        sb.append(", columnName=").append(String.valueOf(this.columnName));
        sb.append(", grantor=").append(String.valueOf(this.grantor));
        sb.append(", isAccessConstrainedByDatabaseVault=").append(String.valueOf(this.isAccessConstrainedByDatabaseVault));
        sb.append(", isAccessConstrainedByVirtualPrivateDatabase=").append(String.valueOf(this.isAccessConstrainedByVirtualPrivateDatabase));
        sb.append(", isAccessConstrainedByRedaction=").append(String.valueOf(this.isAccessConstrainedByRedaction));
        sb.append(", isAccessConstrainedByRealApplicationSecurity=").append(String.valueOf(this.isAccessConstrainedByRealApplicationSecurity));
        sb.append(", isAccessConstrainedBySqlFirewall=").append(String.valueOf(this.isAccessConstrainedBySqlFirewall));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseViewAccessEntry)) {
            return false;
        }
        DatabaseViewAccessEntry other = (DatabaseViewAccessEntry)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.grantee, other.grantee) && Objects.equals((Object)this.accessType, (Object)other.accessType) && Objects.equals(this.tableSchema, other.tableSchema) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.privilegeType, other.privilegeType) && Objects.equals(this.targetId, other.targetId) && Objects.equals((Object)this.privilege, (Object)other.privilege) && Objects.equals((Object)this.privilegeGrantable, (Object)other.privilegeGrantable) && Objects.equals(this.grantFromRole, other.grantFromRole) && Objects.equals(this.viewSchema, other.viewSchema) && Objects.equals(this.viewName, other.viewName) && Objects.equals(this.viewText, other.viewText) && Objects.equals(this.columnName, other.columnName) && Objects.equals(this.grantor, other.grantor) && Objects.equals(this.isAccessConstrainedByDatabaseVault, other.isAccessConstrainedByDatabaseVault) && Objects.equals(this.isAccessConstrainedByVirtualPrivateDatabase, other.isAccessConstrainedByVirtualPrivateDatabase) && Objects.equals(this.isAccessConstrainedByRedaction, other.isAccessConstrainedByRedaction) && Objects.equals(this.isAccessConstrainedByRealApplicationSecurity, other.isAccessConstrainedByRealApplicationSecurity) && Objects.equals(this.isAccessConstrainedBySqlFirewall, other.isAccessConstrainedBySqlFirewall) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.grantee == null ? 43 : this.grantee.hashCode());
        result = result * 59 + (this.accessType == null ? 43 : this.accessType.hashCode());
        result = result * 59 + (this.tableSchema == null ? 43 : this.tableSchema.hashCode());
        result = result * 59 + (this.tableName == null ? 43 : this.tableName.hashCode());
        result = result * 59 + (this.privilegeType == null ? 43 : this.privilegeType.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.privilege == null ? 43 : this.privilege.hashCode());
        result = result * 59 + (this.privilegeGrantable == null ? 43 : this.privilegeGrantable.hashCode());
        result = result * 59 + (this.grantFromRole == null ? 43 : this.grantFromRole.hashCode());
        result = result * 59 + (this.viewSchema == null ? 43 : this.viewSchema.hashCode());
        result = result * 59 + (this.viewName == null ? 43 : this.viewName.hashCode());
        result = result * 59 + (this.viewText == null ? 43 : this.viewText.hashCode());
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.grantor == null ? 43 : this.grantor.hashCode());
        result = result * 59 + (this.isAccessConstrainedByDatabaseVault == null ? 43 : this.isAccessConstrainedByDatabaseVault.hashCode());
        result = result * 59 + (this.isAccessConstrainedByVirtualPrivateDatabase == null ? 43 : this.isAccessConstrainedByVirtualPrivateDatabase.hashCode());
        result = result * 59 + (this.isAccessConstrainedByRedaction == null ? 43 : this.isAccessConstrainedByRedaction.hashCode());
        result = result * 59 + (this.isAccessConstrainedByRealApplicationSecurity == null ? 43 : this.isAccessConstrainedByRealApplicationSecurity.hashCode());
        result = result * 59 + (this.isAccessConstrainedBySqlFirewall == null ? 43 : this.isAccessConstrainedBySqlFirewall.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="grantee")
        private String grantee;
        @JsonProperty(value="accessType")
        private AccessType accessType;
        @JsonProperty(value="tableSchema")
        private String tableSchema;
        @JsonProperty(value="tableName")
        private String tableName;
        @JsonProperty(value="privilegeType")
        private String privilegeType;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="privilege")
        private PrivilegeName privilege;
        @JsonProperty(value="privilegeGrantable")
        private PrivilegeGrantableOption privilegeGrantable;
        @JsonProperty(value="grantFromRole")
        private String grantFromRole;
        @JsonProperty(value="viewSchema")
        private String viewSchema;
        @JsonProperty(value="viewName")
        private String viewName;
        @JsonProperty(value="viewText")
        private String viewText;
        @JsonProperty(value="columnName")
        private String columnName;
        @JsonProperty(value="grantor")
        private String grantor;
        @JsonProperty(value="isAccessConstrainedByDatabaseVault")
        private Boolean isAccessConstrainedByDatabaseVault;
        @JsonProperty(value="isAccessConstrainedByVirtualPrivateDatabase")
        private Boolean isAccessConstrainedByVirtualPrivateDatabase;
        @JsonProperty(value="isAccessConstrainedByRedaction")
        private Boolean isAccessConstrainedByRedaction;
        @JsonProperty(value="isAccessConstrainedByRealApplicationSecurity")
        private Boolean isAccessConstrainedByRealApplicationSecurity;
        @JsonProperty(value="isAccessConstrainedBySqlFirewall")
        private Boolean isAccessConstrainedBySqlFirewall;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder grantee(String grantee) {
            this.grantee = grantee;
            this.__explicitlySet__.add("grantee");
            return this;
        }

        public Builder accessType(AccessType accessType) {
            this.accessType = accessType;
            this.__explicitlySet__.add("accessType");
            return this;
        }

        public Builder tableSchema(String tableSchema) {
            this.tableSchema = tableSchema;
            this.__explicitlySet__.add("tableSchema");
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            this.__explicitlySet__.add("tableName");
            return this;
        }

        public Builder privilegeType(String privilegeType) {
            this.privilegeType = privilegeType;
            this.__explicitlySet__.add("privilegeType");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder privilege(PrivilegeName privilege) {
            this.privilege = privilege;
            this.__explicitlySet__.add("privilege");
            return this;
        }

        public Builder privilegeGrantable(PrivilegeGrantableOption privilegeGrantable) {
            this.privilegeGrantable = privilegeGrantable;
            this.__explicitlySet__.add("privilegeGrantable");
            return this;
        }

        public Builder grantFromRole(String grantFromRole) {
            this.grantFromRole = grantFromRole;
            this.__explicitlySet__.add("grantFromRole");
            return this;
        }

        public Builder viewSchema(String viewSchema) {
            this.viewSchema = viewSchema;
            this.__explicitlySet__.add("viewSchema");
            return this;
        }

        public Builder viewName(String viewName) {
            this.viewName = viewName;
            this.__explicitlySet__.add("viewName");
            return this;
        }

        public Builder viewText(String viewText) {
            this.viewText = viewText;
            this.__explicitlySet__.add("viewText");
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            this.__explicitlySet__.add("columnName");
            return this;
        }

        public Builder grantor(String grantor) {
            this.grantor = grantor;
            this.__explicitlySet__.add("grantor");
            return this;
        }

        public Builder isAccessConstrainedByDatabaseVault(Boolean isAccessConstrainedByDatabaseVault) {
            this.isAccessConstrainedByDatabaseVault = isAccessConstrainedByDatabaseVault;
            this.__explicitlySet__.add("isAccessConstrainedByDatabaseVault");
            return this;
        }

        public Builder isAccessConstrainedByVirtualPrivateDatabase(Boolean isAccessConstrainedByVirtualPrivateDatabase) {
            this.isAccessConstrainedByVirtualPrivateDatabase = isAccessConstrainedByVirtualPrivateDatabase;
            this.__explicitlySet__.add("isAccessConstrainedByVirtualPrivateDatabase");
            return this;
        }

        public Builder isAccessConstrainedByRedaction(Boolean isAccessConstrainedByRedaction) {
            this.isAccessConstrainedByRedaction = isAccessConstrainedByRedaction;
            this.__explicitlySet__.add("isAccessConstrainedByRedaction");
            return this;
        }

        public Builder isAccessConstrainedByRealApplicationSecurity(Boolean isAccessConstrainedByRealApplicationSecurity) {
            this.isAccessConstrainedByRealApplicationSecurity = isAccessConstrainedByRealApplicationSecurity;
            this.__explicitlySet__.add("isAccessConstrainedByRealApplicationSecurity");
            return this;
        }

        public Builder isAccessConstrainedBySqlFirewall(Boolean isAccessConstrainedBySqlFirewall) {
            this.isAccessConstrainedBySqlFirewall = isAccessConstrainedBySqlFirewall;
            this.__explicitlySet__.add("isAccessConstrainedBySqlFirewall");
            return this;
        }

        public DatabaseViewAccessEntry build() {
            DatabaseViewAccessEntry model = new DatabaseViewAccessEntry(this.key, this.grantee, this.accessType, this.tableSchema, this.tableName, this.privilegeType, this.targetId, this.privilege, this.privilegeGrantable, this.grantFromRole, this.viewSchema, this.viewName, this.viewText, this.columnName, this.grantor, this.isAccessConstrainedByDatabaseVault, this.isAccessConstrainedByVirtualPrivateDatabase, this.isAccessConstrainedByRedaction, this.isAccessConstrainedByRealApplicationSecurity, this.isAccessConstrainedBySqlFirewall);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseViewAccessEntry model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("grantee")) {
                this.grantee(model.getGrantee());
            }
            if (model.wasPropertyExplicitlySet("accessType")) {
                this.accessType(model.getAccessType());
            }
            if (model.wasPropertyExplicitlySet("tableSchema")) {
                this.tableSchema(model.getTableSchema());
            }
            if (model.wasPropertyExplicitlySet("tableName")) {
                this.tableName(model.getTableName());
            }
            if (model.wasPropertyExplicitlySet("privilegeType")) {
                this.privilegeType(model.getPrivilegeType());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("privilege")) {
                this.privilege(model.getPrivilege());
            }
            if (model.wasPropertyExplicitlySet("privilegeGrantable")) {
                this.privilegeGrantable(model.getPrivilegeGrantable());
            }
            if (model.wasPropertyExplicitlySet("grantFromRole")) {
                this.grantFromRole(model.getGrantFromRole());
            }
            if (model.wasPropertyExplicitlySet("viewSchema")) {
                this.viewSchema(model.getViewSchema());
            }
            if (model.wasPropertyExplicitlySet("viewName")) {
                this.viewName(model.getViewName());
            }
            if (model.wasPropertyExplicitlySet("viewText")) {
                this.viewText(model.getViewText());
            }
            if (model.wasPropertyExplicitlySet("columnName")) {
                this.columnName(model.getColumnName());
            }
            if (model.wasPropertyExplicitlySet("grantor")) {
                this.grantor(model.getGrantor());
            }
            if (model.wasPropertyExplicitlySet("isAccessConstrainedByDatabaseVault")) {
                this.isAccessConstrainedByDatabaseVault(model.getIsAccessConstrainedByDatabaseVault());
            }
            if (model.wasPropertyExplicitlySet("isAccessConstrainedByVirtualPrivateDatabase")) {
                this.isAccessConstrainedByVirtualPrivateDatabase(model.getIsAccessConstrainedByVirtualPrivateDatabase());
            }
            if (model.wasPropertyExplicitlySet("isAccessConstrainedByRedaction")) {
                this.isAccessConstrainedByRedaction(model.getIsAccessConstrainedByRedaction());
            }
            if (model.wasPropertyExplicitlySet("isAccessConstrainedByRealApplicationSecurity")) {
                this.isAccessConstrainedByRealApplicationSecurity(model.getIsAccessConstrainedByRealApplicationSecurity());
            }
            if (model.wasPropertyExplicitlySet("isAccessConstrainedBySqlFirewall")) {
                this.isAccessConstrainedBySqlFirewall(model.getIsAccessConstrainedBySqlFirewall());
            }
            return this;
        }
    }
}

