/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GenerateReportDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="targetIds")
    private final List<String> targetIds;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="mimeType")
    private final MimeType mimeType;
    @JsonProperty(value="timeLessThan")
    private final Date timeLessThan;
    @JsonProperty(value="timeGreaterThan")
    private final Date timeGreaterThan;
    @JsonProperty(value="rowLimit")
    private final Integer rowLimit;

    @Deprecated
    @ConstructorProperties(value={"displayName", "targetIds", "description", "compartmentId", "mimeType", "timeLessThan", "timeGreaterThan", "rowLimit"})
    public GenerateReportDetails(String displayName, List<String> targetIds, String description, String compartmentId, MimeType mimeType, Date timeLessThan, Date timeGreaterThan, Integer rowLimit) {
        this.displayName = displayName;
        this.targetIds = targetIds;
        this.description = description;
        this.compartmentId = compartmentId;
        this.mimeType = mimeType;
        this.timeLessThan = timeLessThan;
        this.timeGreaterThan = timeGreaterThan;
        this.rowLimit = rowLimit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getTargetIds() {
        return this.targetIds;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public Date getTimeLessThan() {
        return this.timeLessThan;
    }

    public Date getTimeGreaterThan() {
        return this.timeGreaterThan;
    }

    public Integer getRowLimit() {
        return this.rowLimit;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GenerateReportDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", targetIds=").append(String.valueOf(this.targetIds));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", mimeType=").append(String.valueOf((Object)this.mimeType));
        sb.append(", timeLessThan=").append(String.valueOf(this.timeLessThan));
        sb.append(", timeGreaterThan=").append(String.valueOf(this.timeGreaterThan));
        sb.append(", rowLimit=").append(String.valueOf(this.rowLimit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateReportDetails)) {
            return false;
        }
        GenerateReportDetails other = (GenerateReportDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.targetIds, other.targetIds) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.mimeType, (Object)other.mimeType) && Objects.equals(this.timeLessThan, other.timeLessThan) && Objects.equals(this.timeGreaterThan, other.timeGreaterThan) && Objects.equals(this.rowLimit, other.rowLimit) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.targetIds == null ? 43 : this.targetIds.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.mimeType == null ? 43 : this.mimeType.hashCode());
        result = result * 59 + (this.timeLessThan == null ? 43 : this.timeLessThan.hashCode());
        result = result * 59 + (this.timeGreaterThan == null ? 43 : this.timeGreaterThan.hashCode());
        result = result * 59 + (this.rowLimit == null ? 43 : this.rowLimit.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MimeType implements BmcEnum
    {
        Pdf("PDF"),
        Xls("XLS"),
        Json("JSON");

        private final String value;
        private static Map<String, MimeType> map;

        private MimeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MimeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid MimeType: " + key);
        }

        static {
            map = new HashMap<String, MimeType>();
            for (MimeType v : MimeType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="targetIds")
        private List<String> targetIds;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="mimeType")
        private MimeType mimeType;
        @JsonProperty(value="timeLessThan")
        private Date timeLessThan;
        @JsonProperty(value="timeGreaterThan")
        private Date timeGreaterThan;
        @JsonProperty(value="rowLimit")
        private Integer rowLimit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder targetIds(List<String> targetIds) {
            this.targetIds = targetIds;
            this.__explicitlySet__.add("targetIds");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder mimeType(MimeType mimeType) {
            this.mimeType = mimeType;
            this.__explicitlySet__.add("mimeType");
            return this;
        }

        public Builder timeLessThan(Date timeLessThan) {
            this.timeLessThan = timeLessThan;
            this.__explicitlySet__.add("timeLessThan");
            return this;
        }

        public Builder timeGreaterThan(Date timeGreaterThan) {
            this.timeGreaterThan = timeGreaterThan;
            this.__explicitlySet__.add("timeGreaterThan");
            return this;
        }

        public Builder rowLimit(Integer rowLimit) {
            this.rowLimit = rowLimit;
            this.__explicitlySet__.add("rowLimit");
            return this;
        }

        public GenerateReportDetails build() {
            GenerateReportDetails model = new GenerateReportDetails(this.displayName, this.targetIds, this.description, this.compartmentId, this.mimeType, this.timeLessThan, this.timeGreaterThan, this.rowLimit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GenerateReportDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("targetIds")) {
                this.targetIds(model.getTargetIds());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("mimeType")) {
                this.mimeType(model.getMimeType());
            }
            if (model.wasPropertyExplicitlySet("timeLessThan")) {
                this.timeLessThan(model.getTimeLessThan());
            }
            if (model.wasPropertyExplicitlySet("timeGreaterThan")) {
                this.timeGreaterThan(model.getTimeGreaterThan());
            }
            if (model.wasPropertyExplicitlySet("rowLimit")) {
                this.rowLimit(model.getRowLimit());
            }
            return this;
        }
    }
}

