/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.DatabaseDetails;
import com.oracle.bmc.datasafe.model.InfrastructureType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="databaseType")
@JsonFilter(value="explicitlySetFilter")
public final class InstalledDatabaseDetails
extends DatabaseDetails {
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="ipAddresses")
    private final List<String> ipAddresses;
    @JsonProperty(value="listenerPort")
    private final Integer listenerPort;
    @JsonProperty(value="serviceName")
    private final String serviceName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public InstalledDatabaseDetails(InfrastructureType infrastructureType, String instanceId, List<String> ipAddresses, Integer listenerPort, String serviceName) {
        super(infrastructureType);
        this.instanceId = instanceId;
        this.ipAddresses = ipAddresses;
        this.listenerPort = listenerPort;
        this.serviceName = serviceName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public Integer getListenerPort() {
        return this.listenerPort;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstalledDatabaseDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", ipAddresses=").append(String.valueOf(this.ipAddresses));
        sb.append(", listenerPort=").append(String.valueOf(this.listenerPort));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstalledDatabaseDetails)) {
            return false;
        }
        InstalledDatabaseDetails other = (InstalledDatabaseDetails)((Object)o);
        return Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.ipAddresses, other.ipAddresses) && Objects.equals(this.listenerPort, other.listenerPort) && Objects.equals(this.serviceName, other.serviceName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.ipAddresses == null ? 43 : this.ipAddresses.hashCode());
        result = result * 59 + (this.listenerPort == null ? 43 : this.listenerPort.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="infrastructureType")
        private InfrastructureType infrastructureType;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="ipAddresses")
        private List<String> ipAddresses;
        @JsonProperty(value="listenerPort")
        private Integer listenerPort;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder infrastructureType(InfrastructureType infrastructureType) {
            this.infrastructureType = infrastructureType;
            this.__explicitlySet__.add("infrastructureType");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder ipAddresses(List<String> ipAddresses) {
            this.ipAddresses = ipAddresses;
            this.__explicitlySet__.add("ipAddresses");
            return this;
        }

        public Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            this.__explicitlySet__.add("listenerPort");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public InstalledDatabaseDetails build() {
            InstalledDatabaseDetails model = new InstalledDatabaseDetails(this.infrastructureType, this.instanceId, this.ipAddresses, this.listenerPort, this.serviceName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstalledDatabaseDetails model) {
            if (model.wasPropertyExplicitlySet("infrastructureType")) {
                this.infrastructureType(model.getInfrastructureType());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("ipAddresses")) {
                this.ipAddresses(model.getIpAddresses());
            }
            if (model.wasPropertyExplicitlySet("listenerPort")) {
                this.listenerPort(model.getListenerPort());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            return this;
        }
    }
}

