/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.Column;
import com.oracle.bmc.datasafe.model.ColumnFilter;
import com.oracle.bmc.datasafe.model.ColumnSorting;
import com.oracle.bmc.datasafe.model.ReportDefinitionDataSource;
import com.oracle.bmc.datasafe.model.ReportDefinitionLifecycleState;
import com.oracle.bmc.datasafe.model.Summary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ReportDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="parentId")
    private final String parentId;
    @JsonProperty(value="category")
    private final Category category;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="dataSource")
    private final ReportDefinitionDataSource dataSource;
    @JsonProperty(value="isSeeded")
    private final Boolean isSeeded;
    @JsonProperty(value="displayOrder")
    private final Integer displayOrder;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="scimFilter")
    private final String scimFilter;
    @JsonProperty(value="columnInfo")
    private final List<Column> columnInfo;
    @JsonProperty(value="columnFilters")
    private final List<ColumnFilter> columnFilters;
    @JsonProperty(value="columnSortings")
    private final List<ColumnSorting> columnSortings;
    @JsonProperty(value="summary")
    private final List<Summary> summary;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="lifecycleState")
    private final ReportDefinitionLifecycleState lifecycleState;
    @JsonProperty(value="schedule")
    private final String schedule;
    @JsonProperty(value="scheduledReportMimeType")
    private final ScheduledReportMimeType scheduledReportMimeType;
    @JsonProperty(value="scheduledReportRowLimit")
    private final Integer scheduledReportRowLimit;
    @JsonProperty(value="scheduledReportName")
    private final String scheduledReportName;
    @JsonProperty(value="scheduledReportCompartmentId")
    private final String scheduledReportCompartmentId;
    @JsonProperty(value="recordTimeSpan")
    private final String recordTimeSpan;
    @JsonProperty(value="complianceStandards")
    private final List<String> complianceStandards;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "id", "parentId", "category", "description", "dataSource", "isSeeded", "displayOrder", "timeCreated", "timeUpdated", "scimFilter", "columnInfo", "columnFilters", "columnSortings", "summary", "compartmentId", "lifecycleState", "schedule", "scheduledReportMimeType", "scheduledReportRowLimit", "scheduledReportName", "scheduledReportCompartmentId", "recordTimeSpan", "complianceStandards", "lifecycleDetails", "freeformTags", "definedTags", "systemTags"})
    public ReportDefinition(String displayName, String id, String parentId, Category category, String description, ReportDefinitionDataSource dataSource, Boolean isSeeded, Integer displayOrder, Date timeCreated, Date timeUpdated, String scimFilter, List<Column> columnInfo, List<ColumnFilter> columnFilters, List<ColumnSorting> columnSortings, List<Summary> summary, String compartmentId, ReportDefinitionLifecycleState lifecycleState, String schedule, ScheduledReportMimeType scheduledReportMimeType, Integer scheduledReportRowLimit, String scheduledReportName, String scheduledReportCompartmentId, String recordTimeSpan, List<String> complianceStandards, String lifecycleDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.displayName = displayName;
        this.id = id;
        this.parentId = parentId;
        this.category = category;
        this.description = description;
        this.dataSource = dataSource;
        this.isSeeded = isSeeded;
        this.displayOrder = displayOrder;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.scimFilter = scimFilter;
        this.columnInfo = columnInfo;
        this.columnFilters = columnFilters;
        this.columnSortings = columnSortings;
        this.summary = summary;
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
        this.schedule = schedule;
        this.scheduledReportMimeType = scheduledReportMimeType;
        this.scheduledReportRowLimit = scheduledReportRowLimit;
        this.scheduledReportName = scheduledReportName;
        this.scheduledReportCompartmentId = scheduledReportCompartmentId;
        this.recordTimeSpan = recordTimeSpan;
        this.complianceStandards = complianceStandards;
        this.lifecycleDetails = lifecycleDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public ReportDefinitionDataSource getDataSource() {
        return this.dataSource;
    }

    public Boolean getIsSeeded() {
        return this.isSeeded;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getScimFilter() {
        return this.scimFilter;
    }

    public List<Column> getColumnInfo() {
        return this.columnInfo;
    }

    public List<ColumnFilter> getColumnFilters() {
        return this.columnFilters;
    }

    public List<ColumnSorting> getColumnSortings() {
        return this.columnSortings;
    }

    public List<Summary> getSummary() {
        return this.summary;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ReportDefinitionLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public ScheduledReportMimeType getScheduledReportMimeType() {
        return this.scheduledReportMimeType;
    }

    public Integer getScheduledReportRowLimit() {
        return this.scheduledReportRowLimit;
    }

    public String getScheduledReportName() {
        return this.scheduledReportName;
    }

    public String getScheduledReportCompartmentId() {
        return this.scheduledReportCompartmentId;
    }

    public String getRecordTimeSpan() {
        return this.recordTimeSpan;
    }

    public List<String> getComplianceStandards() {
        return this.complianceStandards;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReportDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", parentId=").append(String.valueOf(this.parentId));
        sb.append(", category=").append(String.valueOf((Object)this.category));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", dataSource=").append(String.valueOf((Object)this.dataSource));
        sb.append(", isSeeded=").append(String.valueOf(this.isSeeded));
        sb.append(", displayOrder=").append(String.valueOf(this.displayOrder));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", scimFilter=").append(String.valueOf(this.scimFilter));
        sb.append(", columnInfo=").append(String.valueOf(this.columnInfo));
        sb.append(", columnFilters=").append(String.valueOf(this.columnFilters));
        sb.append(", columnSortings=").append(String.valueOf(this.columnSortings));
        sb.append(", summary=").append(String.valueOf(this.summary));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", schedule=").append(String.valueOf(this.schedule));
        sb.append(", scheduledReportMimeType=").append(String.valueOf((Object)this.scheduledReportMimeType));
        sb.append(", scheduledReportRowLimit=").append(String.valueOf(this.scheduledReportRowLimit));
        sb.append(", scheduledReportName=").append(String.valueOf(this.scheduledReportName));
        sb.append(", scheduledReportCompartmentId=").append(String.valueOf(this.scheduledReportCompartmentId));
        sb.append(", recordTimeSpan=").append(String.valueOf(this.recordTimeSpan));
        sb.append(", complianceStandards=").append(String.valueOf(this.complianceStandards));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReportDefinition)) {
            return false;
        }
        ReportDefinition other = (ReportDefinition)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.id, other.id) && Objects.equals(this.parentId, other.parentId) && Objects.equals((Object)this.category, (Object)other.category) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.dataSource, (Object)other.dataSource) && Objects.equals(this.isSeeded, other.isSeeded) && Objects.equals(this.displayOrder, other.displayOrder) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.scimFilter, other.scimFilter) && Objects.equals(this.columnInfo, other.columnInfo) && Objects.equals(this.columnFilters, other.columnFilters) && Objects.equals(this.columnSortings, other.columnSortings) && Objects.equals(this.summary, other.summary) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.schedule, other.schedule) && Objects.equals((Object)this.scheduledReportMimeType, (Object)other.scheduledReportMimeType) && Objects.equals(this.scheduledReportRowLimit, other.scheduledReportRowLimit) && Objects.equals(this.scheduledReportName, other.scheduledReportName) && Objects.equals(this.scheduledReportCompartmentId, other.scheduledReportCompartmentId) && Objects.equals(this.recordTimeSpan, other.recordTimeSpan) && Objects.equals(this.complianceStandards, other.complianceStandards) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.parentId == null ? 43 : this.parentId.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.dataSource == null ? 43 : this.dataSource.hashCode());
        result = result * 59 + (this.isSeeded == null ? 43 : this.isSeeded.hashCode());
        result = result * 59 + (this.displayOrder == null ? 43 : this.displayOrder.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.scimFilter == null ? 43 : this.scimFilter.hashCode());
        result = result * 59 + (this.columnInfo == null ? 43 : this.columnInfo.hashCode());
        result = result * 59 + (this.columnFilters == null ? 43 : this.columnFilters.hashCode());
        result = result * 59 + (this.columnSortings == null ? 43 : this.columnSortings.hashCode());
        result = result * 59 + (this.summary == null ? 43 : this.summary.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.schedule == null ? 43 : this.schedule.hashCode());
        result = result * 59 + (this.scheduledReportMimeType == null ? 43 : this.scheduledReportMimeType.hashCode());
        result = result * 59 + (this.scheduledReportRowLimit == null ? 43 : this.scheduledReportRowLimit.hashCode());
        result = result * 59 + (this.scheduledReportName == null ? 43 : this.scheduledReportName.hashCode());
        result = result * 59 + (this.scheduledReportCompartmentId == null ? 43 : this.scheduledReportCompartmentId.hashCode());
        result = result * 59 + (this.recordTimeSpan == null ? 43 : this.recordTimeSpan.hashCode());
        result = result * 59 + (this.complianceStandards == null ? 43 : this.complianceStandards.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ScheduledReportMimeType implements BmcEnum
    {
        Pdf("PDF"),
        Xls("XLS"),
        Json("JSON"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ScheduledReportMimeType> map;

        private ScheduledReportMimeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ScheduledReportMimeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ScheduledReportMimeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ScheduledReportMimeType.class);
            map = new HashMap<String, ScheduledReportMimeType>();
            for (ScheduledReportMimeType v : ScheduledReportMimeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Category implements BmcEnum
    {
        CustomReports("CUSTOM_REPORTS"),
        Summary("SUMMARY"),
        ActivityAuditing("ACTIVITY_AUDITING"),
        FirewallViolations("FIREWALL_VIOLATIONS"),
        AllowedSql("ALLOWED_SQL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Category> map;

        private Category(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Category create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Category', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Category.class);
            map = new HashMap<String, Category>();
            for (Category v : Category.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="parentId")
        private String parentId;
        @JsonProperty(value="category")
        private Category category;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="dataSource")
        private ReportDefinitionDataSource dataSource;
        @JsonProperty(value="isSeeded")
        private Boolean isSeeded;
        @JsonProperty(value="displayOrder")
        private Integer displayOrder;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="scimFilter")
        private String scimFilter;
        @JsonProperty(value="columnInfo")
        private List<Column> columnInfo;
        @JsonProperty(value="columnFilters")
        private List<ColumnFilter> columnFilters;
        @JsonProperty(value="columnSortings")
        private List<ColumnSorting> columnSortings;
        @JsonProperty(value="summary")
        private List<Summary> summary;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private ReportDefinitionLifecycleState lifecycleState;
        @JsonProperty(value="schedule")
        private String schedule;
        @JsonProperty(value="scheduledReportMimeType")
        private ScheduledReportMimeType scheduledReportMimeType;
        @JsonProperty(value="scheduledReportRowLimit")
        private Integer scheduledReportRowLimit;
        @JsonProperty(value="scheduledReportName")
        private String scheduledReportName;
        @JsonProperty(value="scheduledReportCompartmentId")
        private String scheduledReportCompartmentId;
        @JsonProperty(value="recordTimeSpan")
        private String recordTimeSpan;
        @JsonProperty(value="complianceStandards")
        private List<String> complianceStandards;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            this.__explicitlySet__.add("parentId");
            return this;
        }

        public Builder category(Category category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder dataSource(ReportDefinitionDataSource dataSource) {
            this.dataSource = dataSource;
            this.__explicitlySet__.add("dataSource");
            return this;
        }

        public Builder isSeeded(Boolean isSeeded) {
            this.isSeeded = isSeeded;
            this.__explicitlySet__.add("isSeeded");
            return this;
        }

        public Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            this.__explicitlySet__.add("displayOrder");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder scimFilter(String scimFilter) {
            this.scimFilter = scimFilter;
            this.__explicitlySet__.add("scimFilter");
            return this;
        }

        public Builder columnInfo(List<Column> columnInfo) {
            this.columnInfo = columnInfo;
            this.__explicitlySet__.add("columnInfo");
            return this;
        }

        public Builder columnFilters(List<ColumnFilter> columnFilters) {
            this.columnFilters = columnFilters;
            this.__explicitlySet__.add("columnFilters");
            return this;
        }

        public Builder columnSortings(List<ColumnSorting> columnSortings) {
            this.columnSortings = columnSortings;
            this.__explicitlySet__.add("columnSortings");
            return this;
        }

        public Builder summary(List<Summary> summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(ReportDefinitionLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder schedule(String schedule) {
            this.schedule = schedule;
            this.__explicitlySet__.add("schedule");
            return this;
        }

        public Builder scheduledReportMimeType(ScheduledReportMimeType scheduledReportMimeType) {
            this.scheduledReportMimeType = scheduledReportMimeType;
            this.__explicitlySet__.add("scheduledReportMimeType");
            return this;
        }

        public Builder scheduledReportRowLimit(Integer scheduledReportRowLimit) {
            this.scheduledReportRowLimit = scheduledReportRowLimit;
            this.__explicitlySet__.add("scheduledReportRowLimit");
            return this;
        }

        public Builder scheduledReportName(String scheduledReportName) {
            this.scheduledReportName = scheduledReportName;
            this.__explicitlySet__.add("scheduledReportName");
            return this;
        }

        public Builder scheduledReportCompartmentId(String scheduledReportCompartmentId) {
            this.scheduledReportCompartmentId = scheduledReportCompartmentId;
            this.__explicitlySet__.add("scheduledReportCompartmentId");
            return this;
        }

        public Builder recordTimeSpan(String recordTimeSpan) {
            this.recordTimeSpan = recordTimeSpan;
            this.__explicitlySet__.add("recordTimeSpan");
            return this;
        }

        public Builder complianceStandards(List<String> complianceStandards) {
            this.complianceStandards = complianceStandards;
            this.__explicitlySet__.add("complianceStandards");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public ReportDefinition build() {
            ReportDefinition model = new ReportDefinition(this.displayName, this.id, this.parentId, this.category, this.description, this.dataSource, this.isSeeded, this.displayOrder, this.timeCreated, this.timeUpdated, this.scimFilter, this.columnInfo, this.columnFilters, this.columnSortings, this.summary, this.compartmentId, this.lifecycleState, this.schedule, this.scheduledReportMimeType, this.scheduledReportRowLimit, this.scheduledReportName, this.scheduledReportCompartmentId, this.recordTimeSpan, this.complianceStandards, this.lifecycleDetails, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReportDefinition model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("parentId")) {
                this.parentId(model.getParentId());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("dataSource")) {
                this.dataSource(model.getDataSource());
            }
            if (model.wasPropertyExplicitlySet("isSeeded")) {
                this.isSeeded(model.getIsSeeded());
            }
            if (model.wasPropertyExplicitlySet("displayOrder")) {
                this.displayOrder(model.getDisplayOrder());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("scimFilter")) {
                this.scimFilter(model.getScimFilter());
            }
            if (model.wasPropertyExplicitlySet("columnInfo")) {
                this.columnInfo(model.getColumnInfo());
            }
            if (model.wasPropertyExplicitlySet("columnFilters")) {
                this.columnFilters(model.getColumnFilters());
            }
            if (model.wasPropertyExplicitlySet("columnSortings")) {
                this.columnSortings(model.getColumnSortings());
            }
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("schedule")) {
                this.schedule(model.getSchedule());
            }
            if (model.wasPropertyExplicitlySet("scheduledReportMimeType")) {
                this.scheduledReportMimeType(model.getScheduledReportMimeType());
            }
            if (model.wasPropertyExplicitlySet("scheduledReportRowLimit")) {
                this.scheduledReportRowLimit(model.getScheduledReportRowLimit());
            }
            if (model.wasPropertyExplicitlySet("scheduledReportName")) {
                this.scheduledReportName(model.getScheduledReportName());
            }
            if (model.wasPropertyExplicitlySet("scheduledReportCompartmentId")) {
                this.scheduledReportCompartmentId(model.getScheduledReportCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("recordTimeSpan")) {
                this.recordTimeSpan(model.getRecordTimeSpan());
            }
            if (model.wasPropertyExplicitlySet("complianceStandards")) {
                this.complianceStandards(model.getComplianceStandards());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

