/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecurityFeatureAnalyticsDimensions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="securityFeature")
    private final SecurityFeature securityFeature;

    @Deprecated
    @ConstructorProperties(value={"securityFeature"})
    public SecurityFeatureAnalyticsDimensions(SecurityFeature securityFeature) {
        this.securityFeature = securityFeature;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public SecurityFeature getSecurityFeature() {
        return this.securityFeature;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecurityFeatureAnalyticsDimensions(");
        sb.append("super=").append(super.toString());
        sb.append("securityFeature=").append(String.valueOf((Object)this.securityFeature));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityFeatureAnalyticsDimensions)) {
            return false;
        }
        SecurityFeatureAnalyticsDimensions other = (SecurityFeatureAnalyticsDimensions)((Object)o);
        return Objects.equals((Object)this.securityFeature, (Object)other.securityFeature) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.securityFeature == null ? 43 : this.securityFeature.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SecurityFeature implements BmcEnum
    {
        UnifiedAudit("UNIFIED_AUDIT"),
        FineGrainedAudit("FINE_GRAINED_AUDIT"),
        TraditionalAudit("TRADITIONAL_AUDIT"),
        DatabaseVault("DATABASE_VAULT"),
        PrivilegeAnalysis("PRIVILEGE_ANALYSIS"),
        TablespaceEncryption("TABLESPACE_ENCRYPTION"),
        ColumnEncryption("COLUMN_ENCRYPTION"),
        NetworkEncryption("NETWORK_ENCRYPTION"),
        PasswordAuthentication("PASSWORD_AUTHENTICATION"),
        GlobalAuthentication("GLOBAL_AUTHENTICATION"),
        ExternalAuthentication("EXTERNAL_AUTHENTICATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SecurityFeature> map;

        private SecurityFeature(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SecurityFeature create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SecurityFeature', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SecurityFeature.class);
            map = new HashMap<String, SecurityFeature>();
            for (SecurityFeature v : SecurityFeature.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="securityFeature")
        private SecurityFeature securityFeature;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder securityFeature(SecurityFeature securityFeature) {
            this.securityFeature = securityFeature;
            this.__explicitlySet__.add("securityFeature");
            return this;
        }

        public SecurityFeatureAnalyticsDimensions build() {
            SecurityFeatureAnalyticsDimensions model = new SecurityFeatureAnalyticsDimensions(this.securityFeature);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecurityFeatureAnalyticsDimensions model) {
            if (model.wasPropertyExplicitlySet("securityFeature")) {
                this.securityFeature(model.getSecurityFeature());
            }
            return this;
        }
    }
}

