/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.SqlFirewallAllowedSqlLifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlFirewallAllowedSqlDimensions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sqlFirewallPolicyId")
    private final String sqlFirewallPolicyId;
    @JsonProperty(value="sqlLevel")
    private final SqlLevel sqlLevel;
    @JsonProperty(value="dbUserName")
    private final String dbUserName;
    @JsonProperty(value="lifecycleState")
    private final SqlFirewallAllowedSqlLifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"sqlFirewallPolicyId", "sqlLevel", "dbUserName", "lifecycleState"})
    public SqlFirewallAllowedSqlDimensions(String sqlFirewallPolicyId, SqlLevel sqlLevel, String dbUserName, SqlFirewallAllowedSqlLifecycleState lifecycleState) {
        this.sqlFirewallPolicyId = sqlFirewallPolicyId;
        this.sqlLevel = sqlLevel;
        this.dbUserName = dbUserName;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSqlFirewallPolicyId() {
        return this.sqlFirewallPolicyId;
    }

    public SqlLevel getSqlLevel() {
        return this.sqlLevel;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public SqlFirewallAllowedSqlLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlFirewallAllowedSqlDimensions(");
        sb.append("super=").append(super.toString());
        sb.append("sqlFirewallPolicyId=").append(String.valueOf(this.sqlFirewallPolicyId));
        sb.append(", sqlLevel=").append(String.valueOf((Object)this.sqlLevel));
        sb.append(", dbUserName=").append(String.valueOf(this.dbUserName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlFirewallAllowedSqlDimensions)) {
            return false;
        }
        SqlFirewallAllowedSqlDimensions other = (SqlFirewallAllowedSqlDimensions)((Object)o);
        return Objects.equals(this.sqlFirewallPolicyId, other.sqlFirewallPolicyId) && Objects.equals((Object)this.sqlLevel, (Object)other.sqlLevel) && Objects.equals(this.dbUserName, other.dbUserName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sqlFirewallPolicyId == null ? 43 : this.sqlFirewallPolicyId.hashCode());
        result = result * 59 + (this.sqlLevel == null ? 43 : this.sqlLevel.hashCode());
        result = result * 59 + (this.dbUserName == null ? 43 : this.dbUserName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SqlLevel implements BmcEnum
    {
        UserIssuedSql("USER_ISSUED_SQL"),
        AllSql("ALL_SQL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SqlLevel> map;

        private SqlLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SqlLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SqlLevel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SqlLevel.class);
            map = new HashMap<String, SqlLevel>();
            for (SqlLevel v : SqlLevel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sqlFirewallPolicyId")
        private String sqlFirewallPolicyId;
        @JsonProperty(value="sqlLevel")
        private SqlLevel sqlLevel;
        @JsonProperty(value="dbUserName")
        private String dbUserName;
        @JsonProperty(value="lifecycleState")
        private SqlFirewallAllowedSqlLifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sqlFirewallPolicyId(String sqlFirewallPolicyId) {
            this.sqlFirewallPolicyId = sqlFirewallPolicyId;
            this.__explicitlySet__.add("sqlFirewallPolicyId");
            return this;
        }

        public Builder sqlLevel(SqlLevel sqlLevel) {
            this.sqlLevel = sqlLevel;
            this.__explicitlySet__.add("sqlLevel");
            return this;
        }

        public Builder dbUserName(String dbUserName) {
            this.dbUserName = dbUserName;
            this.__explicitlySet__.add("dbUserName");
            return this;
        }

        public Builder lifecycleState(SqlFirewallAllowedSqlLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public SqlFirewallAllowedSqlDimensions build() {
            SqlFirewallAllowedSqlDimensions model = new SqlFirewallAllowedSqlDimensions(this.sqlFirewallPolicyId, this.sqlLevel, this.dbUserName, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlFirewallAllowedSqlDimensions model) {
            if (model.wasPropertyExplicitlySet("sqlFirewallPolicyId")) {
                this.sqlFirewallPolicyId(model.getSqlFirewallPolicyId());
            }
            if (model.wasPropertyExplicitlySet("sqlLevel")) {
                this.sqlLevel(model.getSqlLevel());
            }
            if (model.wasPropertyExplicitlySet("dbUserName")) {
                this.dbUserName(model.getDbUserName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

