/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TablesForDiscovery
extends ExplicitlySetBmcModel {
    @JsonProperty(value="schemaName")
    private final String schemaName;
    @JsonProperty(value="tableNames")
    private final List<String> tableNames;

    @Deprecated
    @ConstructorProperties(value={"schemaName", "tableNames"})
    public TablesForDiscovery(String schemaName, List<String> tableNames) {
        this.schemaName = schemaName;
        this.tableNames = tableNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TablesForDiscovery(");
        sb.append("super=").append(super.toString());
        sb.append("schemaName=").append(String.valueOf(this.schemaName));
        sb.append(", tableNames=").append(String.valueOf(this.tableNames));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TablesForDiscovery)) {
            return false;
        }
        TablesForDiscovery other = (TablesForDiscovery)((Object)o);
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableNames, other.tableNames) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.tableNames == null ? 43 : this.tableNames.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="schemaName")
        private String schemaName;
        @JsonProperty(value="tableNames")
        private List<String> tableNames;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.__explicitlySet__.add("schemaName");
            return this;
        }

        public Builder tableNames(List<String> tableNames) {
            this.tableNames = tableNames;
            this.__explicitlySet__.add("tableNames");
            return this;
        }

        public TablesForDiscovery build() {
            TablesForDiscovery model = new TablesForDiscovery(this.schemaName, this.tableNames);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TablesForDiscovery model) {
            if (model.wasPropertyExplicitlySet("schemaName")) {
                this.schemaName(model.getSchemaName());
            }
            if (model.wasPropertyExplicitlySet("tableNames")) {
                this.tableNames(model.getTableNames());
            }
            return this;
        }
    }
}

