/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.GenerateReportDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GenerateReportRequest
extends BmcRequest<GenerateReportDetails> {
    private String reportDefinitionId;
    private GenerateReportDetails generateReportDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;
    private String scimQuery;

    public String getReportDefinitionId() {
        return this.reportDefinitionId;
    }

    public GenerateReportDetails getGenerateReportDetails() {
        return this.generateReportDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getScimQuery() {
        return this.scimQuery;
    }

    @InternalSdk
    public GenerateReportDetails getBody$() {
        return this.generateReportDetails;
    }

    public Builder toBuilder() {
        return new Builder().reportDefinitionId(this.reportDefinitionId).generateReportDetails(this.generateReportDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).scimQuery(this.scimQuery);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",reportDefinitionId=").append(String.valueOf(this.reportDefinitionId));
        sb.append(",generateReportDetails=").append(String.valueOf((Object)this.generateReportDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",scimQuery=").append(String.valueOf(this.scimQuery));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateReportRequest)) {
            return false;
        }
        GenerateReportRequest other = (GenerateReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.reportDefinitionId, other.reportDefinitionId) && Objects.equals((Object)this.generateReportDetails, (Object)other.generateReportDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.scimQuery, other.scimQuery);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.reportDefinitionId == null ? 43 : this.reportDefinitionId.hashCode());
        result = result * 59 + (this.generateReportDetails == null ? 43 : this.generateReportDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.scimQuery == null ? 43 : this.scimQuery.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GenerateReportRequest, GenerateReportDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String reportDefinitionId = null;
        private GenerateReportDetails generateReportDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String scimQuery = null;

        public Builder reportDefinitionId(String reportDefinitionId) {
            this.reportDefinitionId = reportDefinitionId;
            return this;
        }

        public Builder generateReportDetails(GenerateReportDetails generateReportDetails) {
            this.generateReportDetails = generateReportDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder scimQuery(String scimQuery) {
            this.scimQuery = scimQuery;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GenerateReportRequest o) {
            this.reportDefinitionId(o.getReportDefinitionId());
            this.generateReportDetails(o.getGenerateReportDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.scimQuery(o.getScimQuery());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GenerateReportRequest build() {
            GenerateReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(GenerateReportDetails body) {
            this.generateReportDetails(body);
            return this;
        }

        public GenerateReportRequest buildWithoutInvocationCallback() {
            GenerateReportRequest request = new GenerateReportRequest();
            request.reportDefinitionId = this.reportDefinitionId;
            request.generateReportDetails = this.generateReportDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.scimQuery = this.scimQuery;
            return request;
        }
    }
}

