/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetTargetAlertPolicyAssociationRequest
extends BmcRequest<Void> {
    private String targetAlertPolicyAssociationId;
    private String opcRequestId;

    public String getTargetAlertPolicyAssociationId() {
        return this.targetAlertPolicyAssociationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().targetAlertPolicyAssociationId(this.targetAlertPolicyAssociationId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",targetAlertPolicyAssociationId=").append(String.valueOf(this.targetAlertPolicyAssociationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTargetAlertPolicyAssociationRequest)) {
            return false;
        }
        GetTargetAlertPolicyAssociationRequest other = (GetTargetAlertPolicyAssociationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.targetAlertPolicyAssociationId, other.targetAlertPolicyAssociationId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.targetAlertPolicyAssociationId == null ? 43 : this.targetAlertPolicyAssociationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTargetAlertPolicyAssociationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String targetAlertPolicyAssociationId = null;
        private String opcRequestId = null;

        public Builder targetAlertPolicyAssociationId(String targetAlertPolicyAssociationId) {
            this.targetAlertPolicyAssociationId = targetAlertPolicyAssociationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTargetAlertPolicyAssociationRequest o) {
            this.targetAlertPolicyAssociationId(o.getTargetAlertPolicyAssociationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTargetAlertPolicyAssociationRequest build() {
            GetTargetAlertPolicyAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTargetAlertPolicyAssociationRequest buildWithoutInvocationCallback() {
            GetTargetAlertPolicyAssociationRequest request = new GetTargetAlertPolicyAssociationRequest();
            request.targetAlertPolicyAssociationId = this.targetAlertPolicyAssociationId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

