/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datasafe.model.DiscoveryJob;
import com.oracle.bmc.datasafe.model.DiscoveryJobResult;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListDiscoveryJobResultsRequest
extends BmcRequest<Void> {
    private String discoveryJobId;
    private DiscoveryJob.DiscoveryType discoveryType;
    private DiscoveryJobResult.PlannedAction plannedAction;
    private Boolean isResultApplied;
    private List<String> schemaName;
    private List<String> objectName;
    private List<String> columnName;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;
    private Integer limit;
    private String page;

    public String getDiscoveryJobId() {
        return this.discoveryJobId;
    }

    public DiscoveryJob.DiscoveryType getDiscoveryType() {
        return this.discoveryType;
    }

    public DiscoveryJobResult.PlannedAction getPlannedAction() {
        return this.plannedAction;
    }

    public Boolean getIsResultApplied() {
        return this.isResultApplied;
    }

    public List<String> getSchemaName() {
        return this.schemaName;
    }

    public List<String> getObjectName() {
        return this.objectName;
    }

    public List<String> getColumnName() {
        return this.columnName;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().discoveryJobId(this.discoveryJobId).discoveryType(this.discoveryType).plannedAction(this.plannedAction).isResultApplied(this.isResultApplied).schemaName(this.schemaName).objectName(this.objectName).columnName(this.columnName).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",discoveryJobId=").append(String.valueOf(this.discoveryJobId));
        sb.append(",discoveryType=").append(String.valueOf((Object)this.discoveryType));
        sb.append(",plannedAction=").append(String.valueOf((Object)this.plannedAction));
        sb.append(",isResultApplied=").append(String.valueOf(this.isResultApplied));
        sb.append(",schemaName=").append(String.valueOf(this.schemaName));
        sb.append(",objectName=").append(String.valueOf(this.objectName));
        sb.append(",columnName=").append(String.valueOf(this.columnName));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDiscoveryJobResultsRequest)) {
            return false;
        }
        ListDiscoveryJobResultsRequest other = (ListDiscoveryJobResultsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.discoveryJobId, other.discoveryJobId) && Objects.equals((Object)this.discoveryType, (Object)other.discoveryType) && Objects.equals((Object)this.plannedAction, (Object)other.plannedAction) && Objects.equals(this.isResultApplied, other.isResultApplied) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.columnName, other.columnName) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.discoveryJobId == null ? 43 : this.discoveryJobId.hashCode());
        result = result * 59 + (this.discoveryType == null ? 43 : this.discoveryType.hashCode());
        result = result * 59 + (this.plannedAction == null ? 43 : this.plannedAction.hashCode());
        result = result * 59 + (this.isResultApplied == null ? 43 : this.isResultApplied.hashCode());
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDiscoveryJobResultsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String discoveryJobId = null;
        private DiscoveryJob.DiscoveryType discoveryType = null;
        private DiscoveryJobResult.PlannedAction plannedAction = null;
        private Boolean isResultApplied = null;
        private List<String> schemaName = null;
        private List<String> objectName = null;
        private List<String> columnName = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;

        public Builder discoveryJobId(String discoveryJobId) {
            this.discoveryJobId = discoveryJobId;
            return this;
        }

        public Builder discoveryType(DiscoveryJob.DiscoveryType discoveryType) {
            this.discoveryType = discoveryType;
            return this;
        }

        public Builder plannedAction(DiscoveryJobResult.PlannedAction plannedAction) {
            this.plannedAction = plannedAction;
            return this;
        }

        public Builder isResultApplied(Boolean isResultApplied) {
            this.isResultApplied = isResultApplied;
            return this;
        }

        public Builder schemaName(List<String> schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder schemaName(String singularValue) {
            return this.schemaName(Arrays.asList(singularValue));
        }

        public Builder objectName(List<String> objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder objectName(String singularValue) {
            return this.objectName(Arrays.asList(singularValue));
        }

        public Builder columnName(List<String> columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder columnName(String singularValue) {
            return this.columnName(Arrays.asList(singularValue));
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDiscoveryJobResultsRequest o) {
            this.discoveryJobId(o.getDiscoveryJobId());
            this.discoveryType(o.getDiscoveryType());
            this.plannedAction(o.getPlannedAction());
            this.isResultApplied(o.getIsResultApplied());
            this.schemaName(o.getSchemaName());
            this.objectName(o.getObjectName());
            this.columnName(o.getColumnName());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDiscoveryJobResultsRequest build() {
            ListDiscoveryJobResultsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDiscoveryJobResultsRequest buildWithoutInvocationCallback() {
            ListDiscoveryJobResultsRequest request = new ListDiscoveryJobResultsRequest();
            request.discoveryJobId = this.discoveryJobId;
            request.discoveryType = this.discoveryType;
            request.plannedAction = this.plannedAction;
            request.isResultApplied = this.isResultApplied;
            request.schemaName = this.schemaName;
            request.objectName = this.objectName;
            request.columnName = this.columnName;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DiscoveryType("discoveryType"),
        TimeFinished("timeFinished"),
        SchemaName("schemaName"),
        ObjectName("objectName"),
        ColumnName("columnName"),
        PlannedAction("plannedAction");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

