/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datasafe.model.FindingLifecycleState;
import com.oracle.bmc.datasafe.model.SecurityAssessmentReferences;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListFindingsRequest
extends BmcRequest<Void> {
    private String securityAssessmentId;
    private String opcRequestId;
    private Boolean isTopFinding;
    private Severity severity;
    private FindingLifecycleState lifecycleState;
    private SecurityAssessmentReferences references;
    private Integer limit;
    private String page;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private String targetId;
    private String findingKey;

    public String getSecurityAssessmentId() {
        return this.securityAssessmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsTopFinding() {
        return this.isTopFinding;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public FindingLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SecurityAssessmentReferences getReferences() {
        return this.references;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getFindingKey() {
        return this.findingKey;
    }

    public Builder toBuilder() {
        return new Builder().securityAssessmentId(this.securityAssessmentId).opcRequestId(this.opcRequestId).isTopFinding(this.isTopFinding).severity(this.severity).lifecycleState(this.lifecycleState).references(this.references).limit(this.limit).page(this.page).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel).targetId(this.targetId).findingKey(this.findingKey);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityAssessmentId=").append(String.valueOf(this.securityAssessmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isTopFinding=").append(String.valueOf(this.isTopFinding));
        sb.append(",severity=").append(String.valueOf((Object)this.severity));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",references=").append(String.valueOf((Object)this.references));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",targetId=").append(String.valueOf(this.targetId));
        sb.append(",findingKey=").append(String.valueOf(this.findingKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListFindingsRequest)) {
            return false;
        }
        ListFindingsRequest other = (ListFindingsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityAssessmentId, other.securityAssessmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isTopFinding, other.isTopFinding) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.references, (Object)other.references) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.findingKey, other.findingKey);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityAssessmentId == null ? 43 : this.securityAssessmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isTopFinding == null ? 43 : this.isTopFinding.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.references == null ? 43 : this.references.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.findingKey == null ? 43 : this.findingKey.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListFindingsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityAssessmentId = null;
        private String opcRequestId = null;
        private Boolean isTopFinding = null;
        private Severity severity = null;
        private FindingLifecycleState lifecycleState = null;
        private SecurityAssessmentReferences references = null;
        private Integer limit = null;
        private String page = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;
        private String targetId = null;
        private String findingKey = null;

        public Builder securityAssessmentId(String securityAssessmentId) {
            this.securityAssessmentId = securityAssessmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isTopFinding(Boolean isTopFinding) {
            this.isTopFinding = isTopFinding;
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder lifecycleState(FindingLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder references(SecurityAssessmentReferences references) {
            this.references = references;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder findingKey(String findingKey) {
            this.findingKey = findingKey;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListFindingsRequest o) {
            this.securityAssessmentId(o.getSecurityAssessmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.isTopFinding(o.getIsTopFinding());
            this.severity(o.getSeverity());
            this.lifecycleState(o.getLifecycleState());
            this.references(o.getReferences());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.targetId(o.getTargetId());
            this.findingKey(o.getFindingKey());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListFindingsRequest build() {
            ListFindingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListFindingsRequest buildWithoutInvocationCallback() {
            ListFindingsRequest request = new ListFindingsRequest();
            request.securityAssessmentId = this.securityAssessmentId;
            request.opcRequestId = this.opcRequestId;
            request.isTopFinding = this.isTopFinding;
            request.severity = this.severity;
            request.lifecycleState = this.lifecycleState;
            request.references = this.references;
            request.limit = this.limit;
            request.page = this.page;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            request.targetId = this.targetId;
            request.findingKey = this.findingKey;
            return request;
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Severity implements BmcEnum
    {
        High("HIGH"),
        Medium("MEDIUM"),
        Low("LOW"),
        Evaluate("EVALUATE"),
        Advisory("ADVISORY"),
        Pass("PASS"),
        Deferred("DEFERRED");

        private final String value;
        private static Map<String, Severity> map;

        private Severity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Severity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Severity: " + key);
        }

        static {
            map = new HashMap<String, Severity>();
            for (Severity v : Severity.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

