/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datasafe.model.ReportLifecycleState;
import com.oracle.bmc.datasafe.model.ReportType;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListReportsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private String displayName;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private MimeType mimeType;
    private String reportDefinitionId;
    private Date timeGeneratedGreaterThanOrEqualTo;
    private Date timeGeneratedLessThan;
    private String opcRequestId;
    private ReportLifecycleState lifecycleState;
    private ReportType type;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public String getReportDefinitionId() {
        return this.reportDefinitionId;
    }

    public Date getTimeGeneratedGreaterThanOrEqualTo() {
        return this.timeGeneratedGreaterThanOrEqualTo;
    }

    public Date getTimeGeneratedLessThan() {
        return this.timeGeneratedLessThan;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ReportLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public ReportType getType() {
        return this.type;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel).displayName(this.displayName).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).mimeType(this.mimeType).reportDefinitionId(this.reportDefinitionId).timeGeneratedGreaterThanOrEqualTo(this.timeGeneratedGreaterThanOrEqualTo).timeGeneratedLessThan(this.timeGeneratedLessThan).opcRequestId(this.opcRequestId).lifecycleState(this.lifecycleState).type(this.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",mimeType=").append(String.valueOf((Object)this.mimeType));
        sb.append(",reportDefinitionId=").append(String.valueOf(this.reportDefinitionId));
        sb.append(",timeGeneratedGreaterThanOrEqualTo=").append(String.valueOf(this.timeGeneratedGreaterThanOrEqualTo));
        sb.append(",timeGeneratedLessThan=").append(String.valueOf(this.timeGeneratedLessThan));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",type=").append(String.valueOf((Object)this.type));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListReportsRequest)) {
            return false;
        }
        ListReportsRequest other = (ListReportsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.mimeType, (Object)other.mimeType) && Objects.equals(this.reportDefinitionId, other.reportDefinitionId) && Objects.equals(this.timeGeneratedGreaterThanOrEqualTo, other.timeGeneratedGreaterThanOrEqualTo) && Objects.equals(this.timeGeneratedLessThan, other.timeGeneratedLessThan) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.type, (Object)other.type);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.mimeType == null ? 43 : this.mimeType.hashCode());
        result = result * 59 + (this.reportDefinitionId == null ? 43 : this.reportDefinitionId.hashCode());
        result = result * 59 + (this.timeGeneratedGreaterThanOrEqualTo == null ? 43 : this.timeGeneratedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeGeneratedLessThan == null ? 43 : this.timeGeneratedLessThan.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListReportsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;
        private String displayName = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private MimeType mimeType = null;
        private String reportDefinitionId = null;
        private Date timeGeneratedGreaterThanOrEqualTo = null;
        private Date timeGeneratedLessThan = null;
        private String opcRequestId = null;
        private ReportLifecycleState lifecycleState = null;
        private ReportType type = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder mimeType(MimeType mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder reportDefinitionId(String reportDefinitionId) {
            this.reportDefinitionId = reportDefinitionId;
            return this;
        }

        public Builder timeGeneratedGreaterThanOrEqualTo(Date timeGeneratedGreaterThanOrEqualTo) {
            this.timeGeneratedGreaterThanOrEqualTo = timeGeneratedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeGeneratedLessThan(Date timeGeneratedLessThan) {
            this.timeGeneratedLessThan = timeGeneratedLessThan;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder lifecycleState(ReportLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder type(ReportType type) {
            this.type = type;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListReportsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.displayName(o.getDisplayName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.mimeType(o.getMimeType());
            this.reportDefinitionId(o.getReportDefinitionId());
            this.timeGeneratedGreaterThanOrEqualTo(o.getTimeGeneratedGreaterThanOrEqualTo());
            this.timeGeneratedLessThan(o.getTimeGeneratedLessThan());
            this.opcRequestId(o.getOpcRequestId());
            this.lifecycleState(o.getLifecycleState());
            this.type(o.getType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListReportsRequest build() {
            ListReportsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListReportsRequest buildWithoutInvocationCallback() {
            ListReportsRequest request = new ListReportsRequest();
            request.compartmentId = this.compartmentId;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            request.displayName = this.displayName;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.mimeType = this.mimeType;
            request.reportDefinitionId = this.reportDefinitionId;
            request.timeGeneratedGreaterThanOrEqualTo = this.timeGeneratedGreaterThanOrEqualTo;
            request.timeGeneratedLessThan = this.timeGeneratedLessThan;
            request.opcRequestId = this.opcRequestId;
            request.lifecycleState = this.lifecycleState;
            request.type = this.type;
            return request;
        }
    }

    public static enum MimeType implements BmcEnum
    {
        Pdf("PDF"),
        Xls("XLS"),
        Json("JSON");

        private final String value;
        private static Map<String, MimeType> map;

        private MimeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MimeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid MimeType: " + key);
        }

        static {
            map = new HashMap<String, MimeType>();
            for (MimeType v : MimeType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeGenerated("timeGenerated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

