/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.UpdateTargetDatabaseDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateTargetDatabaseRequest
extends BmcRequest<UpdateTargetDatabaseDetails> {
    private String targetDatabaseId;
    private UpdateTargetDatabaseDetails updateTargetDatabaseDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    public String getTargetDatabaseId() {
        return this.targetDatabaseId;
    }

    public UpdateTargetDatabaseDetails getUpdateTargetDatabaseDetails() {
        return this.updateTargetDatabaseDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public UpdateTargetDatabaseDetails getBody$() {
        return this.updateTargetDatabaseDetails;
    }

    public Builder toBuilder() {
        return new Builder().targetDatabaseId(this.targetDatabaseId).updateTargetDatabaseDetails(this.updateTargetDatabaseDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",targetDatabaseId=").append(String.valueOf(this.targetDatabaseId));
        sb.append(",updateTargetDatabaseDetails=").append(String.valueOf((Object)this.updateTargetDatabaseDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTargetDatabaseRequest)) {
            return false;
        }
        UpdateTargetDatabaseRequest other = (UpdateTargetDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.targetDatabaseId, other.targetDatabaseId) && Objects.equals((Object)this.updateTargetDatabaseDetails, (Object)other.updateTargetDatabaseDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.targetDatabaseId == null ? 43 : this.targetDatabaseId.hashCode());
        result = result * 59 + (this.updateTargetDatabaseDetails == null ? 43 : this.updateTargetDatabaseDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateTargetDatabaseRequest, UpdateTargetDatabaseDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String targetDatabaseId = null;
        private UpdateTargetDatabaseDetails updateTargetDatabaseDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;

        public Builder targetDatabaseId(String targetDatabaseId) {
            this.targetDatabaseId = targetDatabaseId;
            return this;
        }

        public Builder updateTargetDatabaseDetails(UpdateTargetDatabaseDetails updateTargetDatabaseDetails) {
            this.updateTargetDatabaseDetails = updateTargetDatabaseDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTargetDatabaseRequest o) {
            this.targetDatabaseId(o.getTargetDatabaseId());
            this.updateTargetDatabaseDetails(o.getUpdateTargetDatabaseDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTargetDatabaseRequest build() {
            UpdateTargetDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateTargetDatabaseDetails body) {
            this.updateTargetDatabaseDetails(body);
            return this;
        }

        public UpdateTargetDatabaseRequest buildWithoutInvocationCallback() {
            UpdateTargetDatabaseRequest request = new UpdateTargetDatabaseRequest();
            request.targetDatabaseId = this.targetDatabaseId;
            request.updateTargetDatabaseDetails = this.updateTargetDatabaseDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

