/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datascience.DataScienceAsync;
import com.oracle.bmc.datascience.internal.http.ActivateModelConverter;
import com.oracle.bmc.datascience.internal.http.ActivateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.ActivateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.datascience.internal.http.ChangeModelCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeModelDeploymentCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeNotebookSessionCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeProjectCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelArtifactConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.CreateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.CreateProjectConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateModelConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.DeleteModelConverter;
import com.oracle.bmc.datascience.internal.http.DeleteModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.DeleteNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.DeleteProjectConverter;
import com.oracle.bmc.datascience.internal.http.GetModelArtifactContentConverter;
import com.oracle.bmc.datascience.internal.http.GetModelConverter;
import com.oracle.bmc.datascience.internal.http.GetModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.GetModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.GetNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.GetProjectConverter;
import com.oracle.bmc.datascience.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.datascience.internal.http.HeadModelArtifactConverter;
import com.oracle.bmc.datascience.internal.http.ListModelDeploymentShapesConverter;
import com.oracle.bmc.datascience.internal.http.ListModelDeploymentsConverter;
import com.oracle.bmc.datascience.internal.http.ListModelsConverter;
import com.oracle.bmc.datascience.internal.http.ListNotebookSessionShapesConverter;
import com.oracle.bmc.datascience.internal.http.ListNotebookSessionsConverter;
import com.oracle.bmc.datascience.internal.http.ListProjectsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.UpdateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.UpdateProjectConverter;
import com.oracle.bmc.datascience.requests.ActivateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.ActivateModelRequest;
import com.oracle.bmc.datascience.requests.ActivateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.CancelWorkRequestRequest;
import com.oracle.bmc.datascience.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeModelDeploymentCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeNotebookSessionCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.datascience.requests.CreateModelArtifactRequest;
import com.oracle.bmc.datascience.requests.CreateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.CreateModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.CreateModelRequest;
import com.oracle.bmc.datascience.requests.CreateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.CreateProjectRequest;
import com.oracle.bmc.datascience.requests.DeactivateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.DeactivateModelRequest;
import com.oracle.bmc.datascience.requests.DeactivateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.DeleteModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.DeleteModelRequest;
import com.oracle.bmc.datascience.requests.DeleteNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.DeleteProjectRequest;
import com.oracle.bmc.datascience.requests.GetModelArtifactContentRequest;
import com.oracle.bmc.datascience.requests.GetModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.GetModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.GetModelRequest;
import com.oracle.bmc.datascience.requests.GetNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.GetProjectRequest;
import com.oracle.bmc.datascience.requests.GetWorkRequestRequest;
import com.oracle.bmc.datascience.requests.HeadModelArtifactRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentShapesRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentsRequest;
import com.oracle.bmc.datascience.requests.ListModelsRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionShapesRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionsRequest;
import com.oracle.bmc.datascience.requests.ListProjectsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datascience.requests.UpdateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.UpdateModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.UpdateModelRequest;
import com.oracle.bmc.datascience.requests.UpdateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.UpdateProjectRequest;
import com.oracle.bmc.datascience.responses.ActivateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.ActivateModelResponse;
import com.oracle.bmc.datascience.responses.ActivateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.CancelWorkRequestResponse;
import com.oracle.bmc.datascience.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeModelDeploymentCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeNotebookSessionCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.datascience.responses.CreateModelArtifactResponse;
import com.oracle.bmc.datascience.responses.CreateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.CreateModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.CreateModelResponse;
import com.oracle.bmc.datascience.responses.CreateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.CreateProjectResponse;
import com.oracle.bmc.datascience.responses.DeactivateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.DeactivateModelResponse;
import com.oracle.bmc.datascience.responses.DeactivateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.DeleteModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.DeleteModelResponse;
import com.oracle.bmc.datascience.responses.DeleteNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.DeleteProjectResponse;
import com.oracle.bmc.datascience.responses.GetModelArtifactContentResponse;
import com.oracle.bmc.datascience.responses.GetModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.GetModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.GetModelResponse;
import com.oracle.bmc.datascience.responses.GetNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.GetProjectResponse;
import com.oracle.bmc.datascience.responses.GetWorkRequestResponse;
import com.oracle.bmc.datascience.responses.HeadModelArtifactResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentShapesResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentsResponse;
import com.oracle.bmc.datascience.responses.ListModelsResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionShapesResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionsResponse;
import com.oracle.bmc.datascience.responses.ListProjectsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datascience.responses.UpdateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.UpdateModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.UpdateModelResponse;
import com.oracle.bmc.datascience.responses.UpdateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.UpdateProjectResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.responses.internal.StreamClosingAsyncHandler;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataScienceAsyncClient
implements DataScienceAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DataScienceAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATASCIENCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datascience.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DataScienceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataScienceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataScienceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataScienceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataScienceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataScienceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataScienceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DataScienceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ActivateModelResponse> activateModel(ActivateModelRequest request, AsyncHandler<ActivateModelRequest, ActivateModelResponse> handler) {
        LOG.trace("Called async activateModel");
        ActivateModelRequest interceptedRequest = ActivateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ActivateModelResponse> transformer = ActivateModelConverter.fromResponse();
        AsyncHandler<ActivateModelRequest, ActivateModelResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ActivateModelRequest, ActivateModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ActivateModelDeploymentResponse> activateModelDeployment(ActivateModelDeploymentRequest request, AsyncHandler<ActivateModelDeploymentRequest, ActivateModelDeploymentResponse> handler) {
        LOG.trace("Called async activateModelDeployment");
        ActivateModelDeploymentRequest interceptedRequest = ActivateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ActivateModelDeploymentResponse> transformer = ActivateModelDeploymentConverter.fromResponse();
        AsyncHandler<ActivateModelDeploymentRequest, ActivateModelDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ActivateModelDeploymentRequest, ActivateModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ActivateNotebookSessionResponse> activateNotebookSession(ActivateNotebookSessionRequest request, AsyncHandler<ActivateNotebookSessionRequest, ActivateNotebookSessionResponse> handler) {
        LOG.trace("Called async activateNotebookSession");
        ActivateNotebookSessionRequest interceptedRequest = ActivateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ActivateNotebookSessionResponse> transformer = ActivateNotebookSessionConverter.fromResponse();
        AsyncHandler<ActivateNotebookSessionRequest, ActivateNotebookSessionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ActivateNotebookSessionRequest, ActivateNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        LOG.trace("Called async cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelWorkRequestRequest, CancelWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeModelCompartmentResponse> changeModelCompartment(ChangeModelCompartmentRequest request, AsyncHandler<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse> handler) {
        LOG.trace("Called async changeModelCompartment");
        ChangeModelCompartmentRequest interceptedRequest = ChangeModelCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeModelCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeModelCompartmentResponse> transformer = ChangeModelCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeModelDeploymentCompartmentResponse> changeModelDeploymentCompartment(ChangeModelDeploymentCompartmentRequest request, AsyncHandler<ChangeModelDeploymentCompartmentRequest, ChangeModelDeploymentCompartmentResponse> handler) {
        LOG.trace("Called async changeModelDeploymentCompartment");
        ChangeModelDeploymentCompartmentRequest interceptedRequest = ChangeModelDeploymentCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeModelDeploymentCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeModelDeploymentCompartmentResponse> transformer = ChangeModelDeploymentCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeModelDeploymentCompartmentRequest, ChangeModelDeploymentCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeModelDeploymentCompartmentRequest, ChangeModelDeploymentCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeNotebookSessionCompartmentResponse> changeNotebookSessionCompartment(ChangeNotebookSessionCompartmentRequest request, AsyncHandler<ChangeNotebookSessionCompartmentRequest, ChangeNotebookSessionCompartmentResponse> handler) {
        LOG.trace("Called async changeNotebookSessionCompartment");
        ChangeNotebookSessionCompartmentRequest interceptedRequest = ChangeNotebookSessionCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeNotebookSessionCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeNotebookSessionCompartmentResponse> transformer = ChangeNotebookSessionCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeNotebookSessionCompartmentRequest, ChangeNotebookSessionCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeNotebookSessionCompartmentRequest, ChangeNotebookSessionCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeProjectCompartmentResponse> changeProjectCompartment(ChangeProjectCompartmentRequest request, AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handler) {
        LOG.trace("Called async changeProjectCompartment");
        ChangeProjectCompartmentRequest interceptedRequest = ChangeProjectCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeProjectCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeProjectCompartmentResponse> transformer = ChangeProjectCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateModelResponse> createModel(CreateModelRequest request, AsyncHandler<CreateModelRequest, CreateModelResponse> handler) {
        LOG.trace("Called async createModel");
        CreateModelRequest interceptedRequest = CreateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateModelResponse> transformer = CreateModelConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateModelRequest, CreateModelResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateModelRequest, CreateModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateModelArtifactResponse> createModelArtifact(CreateModelArtifactRequest request, AsyncHandler<CreateModelArtifactRequest, CreateModelArtifactResponse> handler) {
        LOG.trace("Called async createModelArtifact");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (CreateModelArtifactRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)CreateModelArtifactRequest.builder());
        }
        final CreateModelArtifactRequest interceptedRequest = CreateModelArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelArtifactConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateModelArtifactResponse> transformer = CreateModelArtifactConverter.fromResponse();
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateModelArtifactRequest, CreateModelArtifactResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getModelArtifact(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateModelDeploymentResponse> createModelDeployment(CreateModelDeploymentRequest request, AsyncHandler<CreateModelDeploymentRequest, CreateModelDeploymentResponse> handler) {
        LOG.trace("Called async createModelDeployment");
        CreateModelDeploymentRequest interceptedRequest = CreateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateModelDeploymentResponse> transformer = CreateModelDeploymentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateModelDeploymentRequest, CreateModelDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateModelDeploymentRequest, CreateModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateModelProvenanceResponse> createModelProvenance(CreateModelProvenanceRequest request, AsyncHandler<CreateModelProvenanceRequest, CreateModelProvenanceResponse> handler) {
        LOG.trace("Called async createModelProvenance");
        CreateModelProvenanceRequest interceptedRequest = CreateModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateModelProvenanceResponse> transformer = CreateModelProvenanceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateModelProvenanceRequest, CreateModelProvenanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateModelProvenanceRequest, CreateModelProvenanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateNotebookSessionResponse> createNotebookSession(CreateNotebookSessionRequest request, AsyncHandler<CreateNotebookSessionRequest, CreateNotebookSessionResponse> handler) {
        LOG.trace("Called async createNotebookSession");
        CreateNotebookSessionRequest interceptedRequest = CreateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateNotebookSessionResponse> transformer = CreateNotebookSessionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateNotebookSessionRequest, CreateNotebookSessionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateNotebookSessionRequest, CreateNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateProjectResponse> createProject(CreateProjectRequest request, AsyncHandler<CreateProjectRequest, CreateProjectResponse> handler) {
        LOG.trace("Called async createProject");
        CreateProjectRequest interceptedRequest = CreateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateProjectResponse> transformer = CreateProjectConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateProjectRequest, CreateProjectResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateProjectRequest, CreateProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeactivateModelResponse> deactivateModel(DeactivateModelRequest request, AsyncHandler<DeactivateModelRequest, DeactivateModelResponse> handler) {
        LOG.trace("Called async deactivateModel");
        DeactivateModelRequest interceptedRequest = DeactivateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeactivateModelResponse> transformer = DeactivateModelConverter.fromResponse();
        AsyncHandler<DeactivateModelRequest, DeactivateModelResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeactivateModelRequest, DeactivateModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeactivateModelDeploymentResponse> deactivateModelDeployment(DeactivateModelDeploymentRequest request, AsyncHandler<DeactivateModelDeploymentRequest, DeactivateModelDeploymentResponse> handler) {
        LOG.trace("Called async deactivateModelDeployment");
        DeactivateModelDeploymentRequest interceptedRequest = DeactivateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeactivateModelDeploymentResponse> transformer = DeactivateModelDeploymentConverter.fromResponse();
        AsyncHandler<DeactivateModelDeploymentRequest, DeactivateModelDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeactivateModelDeploymentRequest, DeactivateModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeactivateNotebookSessionResponse> deactivateNotebookSession(DeactivateNotebookSessionRequest request, AsyncHandler<DeactivateNotebookSessionRequest, DeactivateNotebookSessionResponse> handler) {
        LOG.trace("Called async deactivateNotebookSession");
        DeactivateNotebookSessionRequest interceptedRequest = DeactivateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeactivateNotebookSessionResponse> transformer = DeactivateNotebookSessionConverter.fromResponse();
        AsyncHandler<DeactivateNotebookSessionRequest, DeactivateNotebookSessionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeactivateNotebookSessionRequest, DeactivateNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteModelResponse> deleteModel(DeleteModelRequest request, AsyncHandler<DeleteModelRequest, DeleteModelResponse> handler) {
        LOG.trace("Called async deleteModel");
        DeleteModelRequest interceptedRequest = DeleteModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteModelResponse> transformer = DeleteModelConverter.fromResponse();
        AsyncHandler<DeleteModelRequest, DeleteModelResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteModelRequest, DeleteModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteModelDeploymentResponse> deleteModelDeployment(DeleteModelDeploymentRequest request, AsyncHandler<DeleteModelDeploymentRequest, DeleteModelDeploymentResponse> handler) {
        LOG.trace("Called async deleteModelDeployment");
        DeleteModelDeploymentRequest interceptedRequest = DeleteModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteModelDeploymentResponse> transformer = DeleteModelDeploymentConverter.fromResponse();
        AsyncHandler<DeleteModelDeploymentRequest, DeleteModelDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteModelDeploymentRequest, DeleteModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteNotebookSessionResponse> deleteNotebookSession(DeleteNotebookSessionRequest request, AsyncHandler<DeleteNotebookSessionRequest, DeleteNotebookSessionResponse> handler) {
        LOG.trace("Called async deleteNotebookSession");
        DeleteNotebookSessionRequest interceptedRequest = DeleteNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteNotebookSessionResponse> transformer = DeleteNotebookSessionConverter.fromResponse();
        AsyncHandler<DeleteNotebookSessionRequest, DeleteNotebookSessionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteNotebookSessionRequest, DeleteNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteProjectResponse> deleteProject(DeleteProjectRequest request, AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handler) {
        LOG.trace("Called async deleteProject");
        DeleteProjectRequest interceptedRequest = DeleteProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteProjectResponse> transformer = DeleteProjectConverter.fromResponse();
        AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteProjectRequest, DeleteProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetModelResponse> getModel(GetModelRequest request, AsyncHandler<GetModelRequest, GetModelResponse> handler) {
        LOG.trace("Called async getModel");
        GetModelRequest interceptedRequest = GetModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetModelResponse> transformer = GetModelConverter.fromResponse();
        AsyncHandler<GetModelRequest, GetModelResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetModelRequest, GetModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetModelArtifactContentResponse> getModelArtifactContent(GetModelArtifactContentRequest request, AsyncHandler<GetModelArtifactContentRequest, GetModelArtifactContentResponse> handler) {
        LOG.trace("Called async getModelArtifactContent");
        GetModelArtifactContentRequest interceptedRequest = GetModelArtifactContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelArtifactContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetModelArtifactContentResponse> transformer = GetModelArtifactContentConverter.fromResponse();
        AsyncHandler<GetModelArtifactContentRequest, GetModelArtifactContentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetModelArtifactContentRequest, GetModelArtifactContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetModelDeploymentResponse> getModelDeployment(GetModelDeploymentRequest request, AsyncHandler<GetModelDeploymentRequest, GetModelDeploymentResponse> handler) {
        LOG.trace("Called async getModelDeployment");
        GetModelDeploymentRequest interceptedRequest = GetModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetModelDeploymentResponse> transformer = GetModelDeploymentConverter.fromResponse();
        AsyncHandler<GetModelDeploymentRequest, GetModelDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetModelDeploymentRequest, GetModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetModelProvenanceResponse> getModelProvenance(GetModelProvenanceRequest request, AsyncHandler<GetModelProvenanceRequest, GetModelProvenanceResponse> handler) {
        LOG.trace("Called async getModelProvenance");
        GetModelProvenanceRequest interceptedRequest = GetModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetModelProvenanceResponse> transformer = GetModelProvenanceConverter.fromResponse();
        AsyncHandler<GetModelProvenanceRequest, GetModelProvenanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetModelProvenanceRequest, GetModelProvenanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetNotebookSessionResponse> getNotebookSession(GetNotebookSessionRequest request, AsyncHandler<GetNotebookSessionRequest, GetNotebookSessionResponse> handler) {
        LOG.trace("Called async getNotebookSession");
        GetNotebookSessionRequest interceptedRequest = GetNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNotebookSessionResponse> transformer = GetNotebookSessionConverter.fromResponse();
        AsyncHandler<GetNotebookSessionRequest, GetNotebookSessionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetNotebookSessionRequest, GetNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetProjectResponse> getProject(GetProjectRequest request, AsyncHandler<GetProjectRequest, GetProjectResponse> handler) {
        LOG.trace("Called async getProject");
        GetProjectRequest interceptedRequest = GetProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetProjectResponse> transformer = GetProjectConverter.fromResponse();
        AsyncHandler<GetProjectRequest, GetProjectResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetProjectRequest, GetProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<HeadModelArtifactResponse> headModelArtifact(HeadModelArtifactRequest request, AsyncHandler<HeadModelArtifactRequest, HeadModelArtifactResponse> handler) {
        LOG.trace("Called async headModelArtifact");
        HeadModelArtifactRequest interceptedRequest = HeadModelArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadModelArtifactConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, HeadModelArtifactResponse> transformer = HeadModelArtifactConverter.fromResponse();
        AsyncHandler<HeadModelArtifactRequest, HeadModelArtifactResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.headFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<HeadModelArtifactRequest, HeadModelArtifactResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListModelDeploymentShapesResponse> listModelDeploymentShapes(ListModelDeploymentShapesRequest request, AsyncHandler<ListModelDeploymentShapesRequest, ListModelDeploymentShapesResponse> handler) {
        LOG.trace("Called async listModelDeploymentShapes");
        ListModelDeploymentShapesRequest interceptedRequest = ListModelDeploymentShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelDeploymentShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListModelDeploymentShapesResponse> transformer = ListModelDeploymentShapesConverter.fromResponse();
        AsyncHandler<ListModelDeploymentShapesRequest, ListModelDeploymentShapesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListModelDeploymentShapesRequest, ListModelDeploymentShapesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListModelDeploymentsResponse> listModelDeployments(ListModelDeploymentsRequest request, AsyncHandler<ListModelDeploymentsRequest, ListModelDeploymentsResponse> handler) {
        LOG.trace("Called async listModelDeployments");
        ListModelDeploymentsRequest interceptedRequest = ListModelDeploymentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelDeploymentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListModelDeploymentsResponse> transformer = ListModelDeploymentsConverter.fromResponse();
        AsyncHandler<ListModelDeploymentsRequest, ListModelDeploymentsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListModelDeploymentsRequest, ListModelDeploymentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListModelsResponse> listModels(ListModelsRequest request, AsyncHandler<ListModelsRequest, ListModelsResponse> handler) {
        LOG.trace("Called async listModels");
        ListModelsRequest interceptedRequest = ListModelsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListModelsResponse> transformer = ListModelsConverter.fromResponse();
        AsyncHandler<ListModelsRequest, ListModelsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListModelsRequest, ListModelsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListNotebookSessionShapesResponse> listNotebookSessionShapes(ListNotebookSessionShapesRequest request, AsyncHandler<ListNotebookSessionShapesRequest, ListNotebookSessionShapesResponse> handler) {
        LOG.trace("Called async listNotebookSessionShapes");
        ListNotebookSessionShapesRequest interceptedRequest = ListNotebookSessionShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNotebookSessionShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNotebookSessionShapesResponse> transformer = ListNotebookSessionShapesConverter.fromResponse();
        AsyncHandler<ListNotebookSessionShapesRequest, ListNotebookSessionShapesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListNotebookSessionShapesRequest, ListNotebookSessionShapesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListNotebookSessionsResponse> listNotebookSessions(ListNotebookSessionsRequest request, AsyncHandler<ListNotebookSessionsRequest, ListNotebookSessionsResponse> handler) {
        LOG.trace("Called async listNotebookSessions");
        ListNotebookSessionsRequest interceptedRequest = ListNotebookSessionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNotebookSessionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNotebookSessionsResponse> transformer = ListNotebookSessionsConverter.fromResponse();
        AsyncHandler<ListNotebookSessionsRequest, ListNotebookSessionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListNotebookSessionsRequest, ListNotebookSessionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListProjectsResponse> listProjects(ListProjectsRequest request, AsyncHandler<ListProjectsRequest, ListProjectsResponse> handler) {
        LOG.trace("Called async listProjects");
        ListProjectsRequest interceptedRequest = ListProjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProjectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListProjectsResponse> transformer = ListProjectsConverter.fromResponse();
        AsyncHandler<ListProjectsRequest, ListProjectsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListProjectsRequest, ListProjectsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateModelResponse> updateModel(UpdateModelRequest request, AsyncHandler<UpdateModelRequest, UpdateModelResponse> handler) {
        LOG.trace("Called async updateModel");
        UpdateModelRequest interceptedRequest = UpdateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateModelResponse> transformer = UpdateModelConverter.fromResponse();
        AsyncHandler<UpdateModelRequest, UpdateModelResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateModelRequest, UpdateModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateModelDeploymentResponse> updateModelDeployment(UpdateModelDeploymentRequest request, AsyncHandler<UpdateModelDeploymentRequest, UpdateModelDeploymentResponse> handler) {
        LOG.trace("Called async updateModelDeployment");
        UpdateModelDeploymentRequest interceptedRequest = UpdateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateModelDeploymentResponse> transformer = UpdateModelDeploymentConverter.fromResponse();
        AsyncHandler<UpdateModelDeploymentRequest, UpdateModelDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateModelDeploymentRequest, UpdateModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateModelProvenanceResponse> updateModelProvenance(UpdateModelProvenanceRequest request, AsyncHandler<UpdateModelProvenanceRequest, UpdateModelProvenanceResponse> handler) {
        LOG.trace("Called async updateModelProvenance");
        UpdateModelProvenanceRequest interceptedRequest = UpdateModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateModelProvenanceResponse> transformer = UpdateModelProvenanceConverter.fromResponse();
        AsyncHandler<UpdateModelProvenanceRequest, UpdateModelProvenanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateModelProvenanceRequest, UpdateModelProvenanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateNotebookSessionResponse> updateNotebookSession(UpdateNotebookSessionRequest request, AsyncHandler<UpdateNotebookSessionRequest, UpdateNotebookSessionResponse> handler) {
        LOG.trace("Called async updateNotebookSession");
        UpdateNotebookSessionRequest interceptedRequest = UpdateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNotebookSessionResponse> transformer = UpdateNotebookSessionConverter.fromResponse();
        AsyncHandler<UpdateNotebookSessionRequest, UpdateNotebookSessionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateNotebookSessionRequest, UpdateNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateProjectResponse> updateProject(UpdateProjectRequest request, AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handler) {
        LOG.trace("Called async updateProject");
        UpdateProjectRequest interceptedRequest = UpdateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateProjectResponse> transformer = UpdateProjectConverter.fromResponse();
        AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateProjectRequest, UpdateProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataScienceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DataScienceAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DataScienceAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

