/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import javax.ws.rs.client.Invocation;

public class CreateModelArtifactRequest
extends BmcRequest<InputStream> {
    private String modelId;
    private Long contentLength;
    private InputStream modelArtifact;
    private String opcRequestId;
    private String opcRetryToken;
    private String contentDisposition;

    @InternalSdk
    public InputStream getBody$() {
        return this.modelArtifact;
    }

    @ConstructorProperties(value={"modelId", "contentLength", "modelArtifact", "opcRequestId", "opcRetryToken", "contentDisposition"})
    CreateModelArtifactRequest(String modelId, Long contentLength, InputStream modelArtifact, String opcRequestId, String opcRetryToken, String contentDisposition) {
        this.modelId = modelId;
        this.contentLength = contentLength;
        this.modelArtifact = modelArtifact;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
        this.contentDisposition = contentDisposition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getModelId() {
        return this.modelId;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getModelArtifact() {
        return this.modelArtifact;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateModelArtifactRequest, InputStream> {
        private String modelId;
        private Long contentLength;
        private InputStream modelArtifact;
        private String opcRequestId;
        private String opcRetryToken;
        private String contentDisposition;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateModelArtifactRequest o) {
            this.modelId(o.getModelId());
            this.contentLength(o.getContentLength());
            this.modelArtifact(o.getModelArtifact());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.contentDisposition(o.getContentDisposition());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateModelArtifactRequest build() {
            CreateModelArtifactRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.modelArtifact(body);
            return this;
        }

        Builder() {
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder modelArtifact(InputStream modelArtifact) {
            this.modelArtifact = modelArtifact;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public CreateModelArtifactRequest buildWithoutInvocationCallback() {
            return new CreateModelArtifactRequest(this.modelId, this.contentLength, this.modelArtifact, this.opcRequestId, this.opcRetryToken, this.contentDisposition);
        }

        public String toString() {
            return "CreateModelArtifactRequest.Builder(modelId=" + this.modelId + ", contentLength=" + this.contentLength + ", modelArtifact=" + this.modelArtifact + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ", contentDisposition=" + this.contentDisposition + ")";
        }
    }
}

