/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeactivateModelDeploymentRequest
extends BmcRequest<Void> {
    private String modelDeploymentId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"modelDeploymentId", "ifMatch", "opcRequestId"})
    DeactivateModelDeploymentRequest(String modelDeploymentId, String ifMatch, String opcRequestId) {
        this.modelDeploymentId = modelDeploymentId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getModelDeploymentId() {
        return this.modelDeploymentId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeactivateModelDeploymentRequest, Void> {
        private String modelDeploymentId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeactivateModelDeploymentRequest o) {
            this.modelDeploymentId(o.getModelDeploymentId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeactivateModelDeploymentRequest build() {
            DeactivateModelDeploymentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder modelDeploymentId(String modelDeploymentId) {
            this.modelDeploymentId = modelDeploymentId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeactivateModelDeploymentRequest buildWithoutInvocationCallback() {
            return new DeactivateModelDeploymentRequest(this.modelDeploymentId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeactivateModelDeploymentRequest.Builder(modelDeploymentId=" + this.modelDeploymentId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

