/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.model.Range;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetModelArtifactContentRequest
extends BmcRequest<Void> {
    private String modelId;
    private String opcRequestId;
    private Range range;

    @ConstructorProperties(value={"modelId", "opcRequestId", "range"})
    GetModelArtifactContentRequest(String modelId, String opcRequestId, Range range) {
        this.modelId = modelId;
        this.opcRequestId = opcRequestId;
        this.range = range;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Range getRange() {
        return this.range;
    }

    public static class Builder
    implements BmcRequest.Builder<GetModelArtifactContentRequest, Void> {
        private String modelId;
        private String opcRequestId;
        private Range range;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetModelArtifactContentRequest o) {
            this.modelId(o.getModelId());
            this.opcRequestId(o.getOpcRequestId());
            this.range(o.getRange());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetModelArtifactContentRequest build() {
            GetModelArtifactContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder range(Range range) {
            this.range = range;
            return this;
        }

        public GetModelArtifactContentRequest buildWithoutInvocationCallback() {
            return new GetModelArtifactContentRequest(this.modelId, this.opcRequestId, this.range);
        }

        public String toString() {
            return "GetModelArtifactContentRequest.Builder(modelId=" + this.modelId + ", opcRequestId=" + this.opcRequestId + ", range=" + this.range + ")";
        }
    }
}

