/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datascience.DataScienceAsync;
import com.oracle.bmc.datascience.internal.http.ActivateModelConverter;
import com.oracle.bmc.datascience.internal.http.ActivateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.ActivateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.CancelJobRunConverter;
import com.oracle.bmc.datascience.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.datascience.internal.http.ChangeJobCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeJobRunCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeModelCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeModelDeploymentCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeNotebookSessionCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeProjectCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.CreateJobArtifactConverter;
import com.oracle.bmc.datascience.internal.http.CreateJobConverter;
import com.oracle.bmc.datascience.internal.http.CreateJobRunConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelArtifactConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.CreateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.CreateProjectConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateModelConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.DeleteJobConverter;
import com.oracle.bmc.datascience.internal.http.DeleteJobRunConverter;
import com.oracle.bmc.datascience.internal.http.DeleteModelConverter;
import com.oracle.bmc.datascience.internal.http.DeleteModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.DeleteNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.DeleteProjectConverter;
import com.oracle.bmc.datascience.internal.http.GetJobArtifactContentConverter;
import com.oracle.bmc.datascience.internal.http.GetJobConverter;
import com.oracle.bmc.datascience.internal.http.GetJobRunConverter;
import com.oracle.bmc.datascience.internal.http.GetModelArtifactContentConverter;
import com.oracle.bmc.datascience.internal.http.GetModelConverter;
import com.oracle.bmc.datascience.internal.http.GetModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.GetModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.GetNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.GetProjectConverter;
import com.oracle.bmc.datascience.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.datascience.internal.http.HeadJobArtifactConverter;
import com.oracle.bmc.datascience.internal.http.HeadModelArtifactConverter;
import com.oracle.bmc.datascience.internal.http.ListJobRunsConverter;
import com.oracle.bmc.datascience.internal.http.ListJobShapesConverter;
import com.oracle.bmc.datascience.internal.http.ListJobsConverter;
import com.oracle.bmc.datascience.internal.http.ListModelDeploymentShapesConverter;
import com.oracle.bmc.datascience.internal.http.ListModelDeploymentsConverter;
import com.oracle.bmc.datascience.internal.http.ListModelsConverter;
import com.oracle.bmc.datascience.internal.http.ListNotebookSessionShapesConverter;
import com.oracle.bmc.datascience.internal.http.ListNotebookSessionsConverter;
import com.oracle.bmc.datascience.internal.http.ListProjectsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.datascience.internal.http.UpdateJobConverter;
import com.oracle.bmc.datascience.internal.http.UpdateJobRunConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.UpdateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.UpdateProjectConverter;
import com.oracle.bmc.datascience.requests.ActivateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.ActivateModelRequest;
import com.oracle.bmc.datascience.requests.ActivateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.CancelJobRunRequest;
import com.oracle.bmc.datascience.requests.CancelWorkRequestRequest;
import com.oracle.bmc.datascience.requests.ChangeJobCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeJobRunCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeModelDeploymentCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeNotebookSessionCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.datascience.requests.CreateJobArtifactRequest;
import com.oracle.bmc.datascience.requests.CreateJobRequest;
import com.oracle.bmc.datascience.requests.CreateJobRunRequest;
import com.oracle.bmc.datascience.requests.CreateModelArtifactRequest;
import com.oracle.bmc.datascience.requests.CreateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.CreateModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.CreateModelRequest;
import com.oracle.bmc.datascience.requests.CreateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.CreateProjectRequest;
import com.oracle.bmc.datascience.requests.DeactivateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.DeactivateModelRequest;
import com.oracle.bmc.datascience.requests.DeactivateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.DeleteJobRequest;
import com.oracle.bmc.datascience.requests.DeleteJobRunRequest;
import com.oracle.bmc.datascience.requests.DeleteModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.DeleteModelRequest;
import com.oracle.bmc.datascience.requests.DeleteNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.DeleteProjectRequest;
import com.oracle.bmc.datascience.requests.GetJobArtifactContentRequest;
import com.oracle.bmc.datascience.requests.GetJobRequest;
import com.oracle.bmc.datascience.requests.GetJobRunRequest;
import com.oracle.bmc.datascience.requests.GetModelArtifactContentRequest;
import com.oracle.bmc.datascience.requests.GetModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.GetModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.GetModelRequest;
import com.oracle.bmc.datascience.requests.GetNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.GetProjectRequest;
import com.oracle.bmc.datascience.requests.GetWorkRequestRequest;
import com.oracle.bmc.datascience.requests.HeadJobArtifactRequest;
import com.oracle.bmc.datascience.requests.HeadModelArtifactRequest;
import com.oracle.bmc.datascience.requests.ListJobRunsRequest;
import com.oracle.bmc.datascience.requests.ListJobShapesRequest;
import com.oracle.bmc.datascience.requests.ListJobsRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentShapesRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentsRequest;
import com.oracle.bmc.datascience.requests.ListModelsRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionShapesRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionsRequest;
import com.oracle.bmc.datascience.requests.ListProjectsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datascience.requests.UpdateJobRequest;
import com.oracle.bmc.datascience.requests.UpdateJobRunRequest;
import com.oracle.bmc.datascience.requests.UpdateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.UpdateModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.UpdateModelRequest;
import com.oracle.bmc.datascience.requests.UpdateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.UpdateProjectRequest;
import com.oracle.bmc.datascience.responses.ActivateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.ActivateModelResponse;
import com.oracle.bmc.datascience.responses.ActivateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.CancelJobRunResponse;
import com.oracle.bmc.datascience.responses.CancelWorkRequestResponse;
import com.oracle.bmc.datascience.responses.ChangeJobCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeJobRunCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeModelDeploymentCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeNotebookSessionCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.datascience.responses.CreateJobArtifactResponse;
import com.oracle.bmc.datascience.responses.CreateJobResponse;
import com.oracle.bmc.datascience.responses.CreateJobRunResponse;
import com.oracle.bmc.datascience.responses.CreateModelArtifactResponse;
import com.oracle.bmc.datascience.responses.CreateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.CreateModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.CreateModelResponse;
import com.oracle.bmc.datascience.responses.CreateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.CreateProjectResponse;
import com.oracle.bmc.datascience.responses.DeactivateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.DeactivateModelResponse;
import com.oracle.bmc.datascience.responses.DeactivateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.DeleteJobResponse;
import com.oracle.bmc.datascience.responses.DeleteJobRunResponse;
import com.oracle.bmc.datascience.responses.DeleteModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.DeleteModelResponse;
import com.oracle.bmc.datascience.responses.DeleteNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.DeleteProjectResponse;
import com.oracle.bmc.datascience.responses.GetJobArtifactContentResponse;
import com.oracle.bmc.datascience.responses.GetJobResponse;
import com.oracle.bmc.datascience.responses.GetJobRunResponse;
import com.oracle.bmc.datascience.responses.GetModelArtifactContentResponse;
import com.oracle.bmc.datascience.responses.GetModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.GetModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.GetModelResponse;
import com.oracle.bmc.datascience.responses.GetNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.GetProjectResponse;
import com.oracle.bmc.datascience.responses.GetWorkRequestResponse;
import com.oracle.bmc.datascience.responses.HeadJobArtifactResponse;
import com.oracle.bmc.datascience.responses.HeadModelArtifactResponse;
import com.oracle.bmc.datascience.responses.ListJobRunsResponse;
import com.oracle.bmc.datascience.responses.ListJobShapesResponse;
import com.oracle.bmc.datascience.responses.ListJobsResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentShapesResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentsResponse;
import com.oracle.bmc.datascience.responses.ListModelsResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionShapesResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionsResponse;
import com.oracle.bmc.datascience.responses.ListProjectsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datascience.responses.UpdateJobResponse;
import com.oracle.bmc.datascience.responses.UpdateJobRunResponse;
import com.oracle.bmc.datascience.responses.UpdateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.UpdateModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.UpdateModelResponse;
import com.oracle.bmc.datascience.responses.UpdateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.UpdateProjectResponse;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.responses.internal.StreamClosingAsyncHandler;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataScienceAsyncClient
implements DataScienceAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DataScienceAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATASCIENCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datascience.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    public DataScienceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataScienceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataScienceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataScienceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataScienceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataScienceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataScienceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DataScienceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration, isNonBufferingApacheClient);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ActivateModelResponse> activateModel(ActivateModelRequest request, AsyncHandler<ActivateModelRequest, ActivateModelResponse> handler) {
        LOG.trace("Called async activateModel");
        ActivateModelRequest interceptedRequest = ActivateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateModelConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ActivateModelResponse> transformer = ActivateModelConverter.fromResponse();
        AsyncHandler<ActivateModelRequest, ActivateModelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ActivateModelRequest, ActivateModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ActivateModelDeploymentResponse> activateModelDeployment(ActivateModelDeploymentRequest request, AsyncHandler<ActivateModelDeploymentRequest, ActivateModelDeploymentResponse> handler) {
        LOG.trace("Called async activateModelDeployment");
        ActivateModelDeploymentRequest interceptedRequest = ActivateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ActivateModelDeploymentResponse> transformer = ActivateModelDeploymentConverter.fromResponse();
        AsyncHandler<ActivateModelDeploymentRequest, ActivateModelDeploymentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ActivateModelDeploymentRequest, ActivateModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ActivateNotebookSessionResponse> activateNotebookSession(ActivateNotebookSessionRequest request, AsyncHandler<ActivateNotebookSessionRequest, ActivateNotebookSessionResponse> handler) {
        LOG.trace("Called async activateNotebookSession");
        ActivateNotebookSessionRequest interceptedRequest = ActivateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ActivateNotebookSessionResponse> transformer = ActivateNotebookSessionConverter.fromResponse();
        AsyncHandler<ActivateNotebookSessionRequest, ActivateNotebookSessionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ActivateNotebookSessionRequest, ActivateNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelJobRunResponse> cancelJobRun(CancelJobRunRequest request, AsyncHandler<CancelJobRunRequest, CancelJobRunResponse> handler) {
        LOG.trace("Called async cancelJobRun");
        CancelJobRunRequest interceptedRequest = CancelJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelJobRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CancelJobRunResponse> transformer = CancelJobRunConverter.fromResponse();
        AsyncHandler<CancelJobRunRequest, CancelJobRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelJobRunRequest, CancelJobRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        LOG.trace("Called async cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelWorkRequestRequest, CancelWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeJobCompartmentResponse> changeJobCompartment(ChangeJobCompartmentRequest request, AsyncHandler<ChangeJobCompartmentRequest, ChangeJobCompartmentResponse> handler) {
        LOG.trace("Called async changeJobCompartment");
        ChangeJobCompartmentRequest interceptedRequest = ChangeJobCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeJobCompartmentResponse> transformer = ChangeJobCompartmentConverter.fromResponse();
        AsyncHandler<ChangeJobCompartmentRequest, ChangeJobCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeJobCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeJobCompartmentRequest, ChangeJobCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeJobRunCompartmentResponse> changeJobRunCompartment(ChangeJobRunCompartmentRequest request, AsyncHandler<ChangeJobRunCompartmentRequest, ChangeJobRunCompartmentResponse> handler) {
        LOG.trace("Called async changeJobRunCompartment");
        ChangeJobRunCompartmentRequest interceptedRequest = ChangeJobRunCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeJobRunCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeJobRunCompartmentResponse> transformer = ChangeJobRunCompartmentConverter.fromResponse();
        AsyncHandler<ChangeJobRunCompartmentRequest, ChangeJobRunCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeJobRunCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeJobRunCompartmentRequest, ChangeJobRunCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeModelCompartmentResponse> changeModelCompartment(ChangeModelCompartmentRequest request, AsyncHandler<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse> handler) {
        LOG.trace("Called async changeModelCompartment");
        ChangeModelCompartmentRequest interceptedRequest = ChangeModelCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeModelCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeModelCompartmentResponse> transformer = ChangeModelCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeModelCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeModelDeploymentCompartmentResponse> changeModelDeploymentCompartment(ChangeModelDeploymentCompartmentRequest request, AsyncHandler<ChangeModelDeploymentCompartmentRequest, ChangeModelDeploymentCompartmentResponse> handler) {
        LOG.trace("Called async changeModelDeploymentCompartment");
        ChangeModelDeploymentCompartmentRequest interceptedRequest = ChangeModelDeploymentCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeModelDeploymentCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeModelDeploymentCompartmentResponse> transformer = ChangeModelDeploymentCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeModelDeploymentCompartmentRequest, ChangeModelDeploymentCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeModelDeploymentCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeModelDeploymentCompartmentRequest, ChangeModelDeploymentCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeNotebookSessionCompartmentResponse> changeNotebookSessionCompartment(ChangeNotebookSessionCompartmentRequest request, AsyncHandler<ChangeNotebookSessionCompartmentRequest, ChangeNotebookSessionCompartmentResponse> handler) {
        LOG.trace("Called async changeNotebookSessionCompartment");
        ChangeNotebookSessionCompartmentRequest interceptedRequest = ChangeNotebookSessionCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeNotebookSessionCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeNotebookSessionCompartmentResponse> transformer = ChangeNotebookSessionCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeNotebookSessionCompartmentRequest, ChangeNotebookSessionCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeNotebookSessionCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeNotebookSessionCompartmentRequest, ChangeNotebookSessionCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeProjectCompartmentResponse> changeProjectCompartment(ChangeProjectCompartmentRequest request, AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handler) {
        LOG.trace("Called async changeProjectCompartment");
        ChangeProjectCompartmentRequest interceptedRequest = ChangeProjectCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeProjectCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeProjectCompartmentResponse> transformer = ChangeProjectCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeProjectCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateJobResponse> createJob(CreateJobRequest request, AsyncHandler<CreateJobRequest, CreateJobResponse> handler) {
        LOG.trace("Called async createJob");
        CreateJobRequest interceptedRequest = CreateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateJobResponse> transformer = CreateJobConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateJobRequest, CreateJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateJobDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateJobRequest, CreateJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateJobArtifactResponse> createJobArtifact(CreateJobArtifactRequest request, AsyncHandler<CreateJobArtifactRequest, CreateJobArtifactResponse> handler) {
        LOG.trace("Called async createJobArtifact");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (CreateJobArtifactRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)CreateJobArtifactRequest.builder());
        }
        final CreateJobArtifactRequest interceptedRequest = CreateJobArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobArtifactConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateJobArtifactResponse> transformer = CreateJobArtifactConverter.fromResponse();
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getJobArtifact(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateJobArtifactRequest, CreateJobArtifactResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getJobArtifact(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateJobRunResponse> createJobRun(CreateJobRunRequest request, AsyncHandler<CreateJobRunRequest, CreateJobRunResponse> handler) {
        LOG.trace("Called async createJobRun");
        CreateJobRunRequest interceptedRequest = CreateJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateJobRunResponse> transformer = CreateJobRunConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateJobRunRequest, CreateJobRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateJobRunDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateJobRunRequest, CreateJobRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateModelResponse> createModel(CreateModelRequest request, AsyncHandler<CreateModelRequest, CreateModelResponse> handler) {
        LOG.trace("Called async createModel");
        CreateModelRequest interceptedRequest = CreateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateModelResponse> transformer = CreateModelConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateModelRequest, CreateModelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateModelDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateModelRequest, CreateModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateModelArtifactResponse> createModelArtifact(CreateModelArtifactRequest request, AsyncHandler<CreateModelArtifactRequest, CreateModelArtifactResponse> handler) {
        LOG.trace("Called async createModelArtifact");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (CreateModelArtifactRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)CreateModelArtifactRequest.builder());
        }
        final CreateModelArtifactRequest interceptedRequest = CreateModelArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelArtifactConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateModelArtifactResponse> transformer = CreateModelArtifactConverter.fromResponse();
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getModelArtifact(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateModelArtifactRequest, CreateModelArtifactResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getModelArtifact(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateModelDeploymentResponse> createModelDeployment(CreateModelDeploymentRequest request, AsyncHandler<CreateModelDeploymentRequest, CreateModelDeploymentResponse> handler) {
        LOG.trace("Called async createModelDeployment");
        CreateModelDeploymentRequest interceptedRequest = CreateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateModelDeploymentResponse> transformer = CreateModelDeploymentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateModelDeploymentRequest, CreateModelDeploymentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateModelDeploymentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateModelDeploymentRequest, CreateModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateModelProvenanceResponse> createModelProvenance(CreateModelProvenanceRequest request, AsyncHandler<CreateModelProvenanceRequest, CreateModelProvenanceResponse> handler) {
        LOG.trace("Called async createModelProvenance");
        CreateModelProvenanceRequest interceptedRequest = CreateModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateModelProvenanceResponse> transformer = CreateModelProvenanceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateModelProvenanceRequest, CreateModelProvenanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateModelProvenanceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateModelProvenanceRequest, CreateModelProvenanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateNotebookSessionResponse> createNotebookSession(CreateNotebookSessionRequest request, AsyncHandler<CreateNotebookSessionRequest, CreateNotebookSessionResponse> handler) {
        LOG.trace("Called async createNotebookSession");
        CreateNotebookSessionRequest interceptedRequest = CreateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateNotebookSessionResponse> transformer = CreateNotebookSessionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateNotebookSessionRequest, CreateNotebookSessionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateNotebookSessionDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateNotebookSessionRequest, CreateNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateProjectResponse> createProject(CreateProjectRequest request, AsyncHandler<CreateProjectRequest, CreateProjectResponse> handler) {
        LOG.trace("Called async createProject");
        CreateProjectRequest interceptedRequest = CreateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateProjectResponse> transformer = CreateProjectConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateProjectRequest, CreateProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateProjectDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateProjectRequest, CreateProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeactivateModelResponse> deactivateModel(DeactivateModelRequest request, AsyncHandler<DeactivateModelRequest, DeactivateModelResponse> handler) {
        LOG.trace("Called async deactivateModel");
        DeactivateModelRequest interceptedRequest = DeactivateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateModelConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeactivateModelResponse> transformer = DeactivateModelConverter.fromResponse();
        AsyncHandler<DeactivateModelRequest, DeactivateModelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeactivateModelRequest, DeactivateModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeactivateModelDeploymentResponse> deactivateModelDeployment(DeactivateModelDeploymentRequest request, AsyncHandler<DeactivateModelDeploymentRequest, DeactivateModelDeploymentResponse> handler) {
        LOG.trace("Called async deactivateModelDeployment");
        DeactivateModelDeploymentRequest interceptedRequest = DeactivateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeactivateModelDeploymentResponse> transformer = DeactivateModelDeploymentConverter.fromResponse();
        AsyncHandler<DeactivateModelDeploymentRequest, DeactivateModelDeploymentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeactivateModelDeploymentRequest, DeactivateModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeactivateNotebookSessionResponse> deactivateNotebookSession(DeactivateNotebookSessionRequest request, AsyncHandler<DeactivateNotebookSessionRequest, DeactivateNotebookSessionResponse> handler) {
        LOG.trace("Called async deactivateNotebookSession");
        DeactivateNotebookSessionRequest interceptedRequest = DeactivateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeactivateNotebookSessionResponse> transformer = DeactivateNotebookSessionConverter.fromResponse();
        AsyncHandler<DeactivateNotebookSessionRequest, DeactivateNotebookSessionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeactivateNotebookSessionRequest, DeactivateNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteJobResponse> deleteJob(DeleteJobRequest request, AsyncHandler<DeleteJobRequest, DeleteJobResponse> handler) {
        LOG.trace("Called async deleteJob");
        DeleteJobRequest interceptedRequest = DeleteJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteJobResponse> transformer = DeleteJobConverter.fromResponse();
        AsyncHandler<DeleteJobRequest, DeleteJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteJobRequest, DeleteJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteJobRunResponse> deleteJobRun(DeleteJobRunRequest request, AsyncHandler<DeleteJobRunRequest, DeleteJobRunResponse> handler) {
        LOG.trace("Called async deleteJobRun");
        DeleteJobRunRequest interceptedRequest = DeleteJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteJobRunResponse> transformer = DeleteJobRunConverter.fromResponse();
        AsyncHandler<DeleteJobRunRequest, DeleteJobRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteJobRunRequest, DeleteJobRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteModelResponse> deleteModel(DeleteModelRequest request, AsyncHandler<DeleteModelRequest, DeleteModelResponse> handler) {
        LOG.trace("Called async deleteModel");
        DeleteModelRequest interceptedRequest = DeleteModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteModelConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteModelResponse> transformer = DeleteModelConverter.fromResponse();
        AsyncHandler<DeleteModelRequest, DeleteModelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteModelRequest, DeleteModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteModelDeploymentResponse> deleteModelDeployment(DeleteModelDeploymentRequest request, AsyncHandler<DeleteModelDeploymentRequest, DeleteModelDeploymentResponse> handler) {
        LOG.trace("Called async deleteModelDeployment");
        DeleteModelDeploymentRequest interceptedRequest = DeleteModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteModelDeploymentResponse> transformer = DeleteModelDeploymentConverter.fromResponse();
        AsyncHandler<DeleteModelDeploymentRequest, DeleteModelDeploymentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteModelDeploymentRequest, DeleteModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteNotebookSessionResponse> deleteNotebookSession(DeleteNotebookSessionRequest request, AsyncHandler<DeleteNotebookSessionRequest, DeleteNotebookSessionResponse> handler) {
        LOG.trace("Called async deleteNotebookSession");
        DeleteNotebookSessionRequest interceptedRequest = DeleteNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteNotebookSessionResponse> transformer = DeleteNotebookSessionConverter.fromResponse();
        AsyncHandler<DeleteNotebookSessionRequest, DeleteNotebookSessionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteNotebookSessionRequest, DeleteNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteProjectResponse> deleteProject(DeleteProjectRequest request, AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handler) {
        LOG.trace("Called async deleteProject");
        DeleteProjectRequest interceptedRequest = DeleteProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteProjectResponse> transformer = DeleteProjectConverter.fromResponse();
        AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteProjectRequest, DeleteProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobResponse> getJob(GetJobRequest request, AsyncHandler<GetJobRequest, GetJobResponse> handler) {
        LOG.trace("Called async getJob");
        GetJobRequest interceptedRequest = GetJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetJobResponse> transformer = GetJobConverter.fromResponse();
        AsyncHandler<GetJobRequest, GetJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobRequest, GetJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobArtifactContentResponse> getJobArtifactContent(GetJobArtifactContentRequest request, AsyncHandler<GetJobArtifactContentRequest, GetJobArtifactContentResponse> handler) {
        LOG.trace("Called async getJobArtifactContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getJobArtifactContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetJobArtifactContentRequest interceptedRequest = GetJobArtifactContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobArtifactContentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetJobArtifactContentResponse> transformer = GetJobArtifactContentConverter.fromResponse();
        AsyncHandler<GetJobArtifactContentRequest, GetJobArtifactContentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobArtifactContentRequest, GetJobArtifactContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobRunResponse> getJobRun(GetJobRunRequest request, AsyncHandler<GetJobRunRequest, GetJobRunResponse> handler) {
        LOG.trace("Called async getJobRun");
        GetJobRunRequest interceptedRequest = GetJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetJobRunResponse> transformer = GetJobRunConverter.fromResponse();
        AsyncHandler<GetJobRunRequest, GetJobRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobRunRequest, GetJobRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetModelResponse> getModel(GetModelRequest request, AsyncHandler<GetModelRequest, GetModelResponse> handler) {
        LOG.trace("Called async getModel");
        GetModelRequest interceptedRequest = GetModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetModelResponse> transformer = GetModelConverter.fromResponse();
        AsyncHandler<GetModelRequest, GetModelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetModelRequest, GetModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetModelArtifactContentResponse> getModelArtifactContent(GetModelArtifactContentRequest request, AsyncHandler<GetModelArtifactContentRequest, GetModelArtifactContentResponse> handler) {
        LOG.trace("Called async getModelArtifactContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getModelArtifactContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetModelArtifactContentRequest interceptedRequest = GetModelArtifactContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelArtifactContentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetModelArtifactContentResponse> transformer = GetModelArtifactContentConverter.fromResponse();
        AsyncHandler<GetModelArtifactContentRequest, GetModelArtifactContentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetModelArtifactContentRequest, GetModelArtifactContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetModelDeploymentResponse> getModelDeployment(GetModelDeploymentRequest request, AsyncHandler<GetModelDeploymentRequest, GetModelDeploymentResponse> handler) {
        LOG.trace("Called async getModelDeployment");
        GetModelDeploymentRequest interceptedRequest = GetModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetModelDeploymentResponse> transformer = GetModelDeploymentConverter.fromResponse();
        AsyncHandler<GetModelDeploymentRequest, GetModelDeploymentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetModelDeploymentRequest, GetModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetModelProvenanceResponse> getModelProvenance(GetModelProvenanceRequest request, AsyncHandler<GetModelProvenanceRequest, GetModelProvenanceResponse> handler) {
        LOG.trace("Called async getModelProvenance");
        GetModelProvenanceRequest interceptedRequest = GetModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetModelProvenanceResponse> transformer = GetModelProvenanceConverter.fromResponse();
        AsyncHandler<GetModelProvenanceRequest, GetModelProvenanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetModelProvenanceRequest, GetModelProvenanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetNotebookSessionResponse> getNotebookSession(GetNotebookSessionRequest request, AsyncHandler<GetNotebookSessionRequest, GetNotebookSessionResponse> handler) {
        LOG.trace("Called async getNotebookSession");
        GetNotebookSessionRequest interceptedRequest = GetNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetNotebookSessionResponse> transformer = GetNotebookSessionConverter.fromResponse();
        AsyncHandler<GetNotebookSessionRequest, GetNotebookSessionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetNotebookSessionRequest, GetNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetProjectResponse> getProject(GetProjectRequest request, AsyncHandler<GetProjectRequest, GetProjectResponse> handler) {
        LOG.trace("Called async getProject");
        GetProjectRequest interceptedRequest = GetProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetProjectResponse> transformer = GetProjectConverter.fromResponse();
        AsyncHandler<GetProjectRequest, GetProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetProjectRequest, GetProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<HeadJobArtifactResponse> headJobArtifact(HeadJobArtifactRequest request, AsyncHandler<HeadJobArtifactRequest, HeadJobArtifactResponse> handler) {
        LOG.trace("Called async headJobArtifact");
        HeadJobArtifactRequest interceptedRequest = HeadJobArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadJobArtifactConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, HeadJobArtifactResponse> transformer = HeadJobArtifactConverter.fromResponse();
        AsyncHandler<HeadJobArtifactRequest, HeadJobArtifactResponse> handlerToUse = handler;
        Function futureSupplier = this.client.headFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<HeadJobArtifactRequest, HeadJobArtifactResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<HeadModelArtifactResponse> headModelArtifact(HeadModelArtifactRequest request, AsyncHandler<HeadModelArtifactRequest, HeadModelArtifactResponse> handler) {
        LOG.trace("Called async headModelArtifact");
        HeadModelArtifactRequest interceptedRequest = HeadModelArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadModelArtifactConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, HeadModelArtifactResponse> transformer = HeadModelArtifactConverter.fromResponse();
        AsyncHandler<HeadModelArtifactRequest, HeadModelArtifactResponse> handlerToUse = handler;
        Function futureSupplier = this.client.headFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<HeadModelArtifactRequest, HeadModelArtifactResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobRunsResponse> listJobRuns(ListJobRunsRequest request, AsyncHandler<ListJobRunsRequest, ListJobRunsResponse> handler) {
        LOG.trace("Called async listJobRuns");
        ListJobRunsRequest interceptedRequest = ListJobRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobRunsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListJobRunsResponse> transformer = ListJobRunsConverter.fromResponse();
        AsyncHandler<ListJobRunsRequest, ListJobRunsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobRunsRequest, ListJobRunsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobShapesResponse> listJobShapes(ListJobShapesRequest request, AsyncHandler<ListJobShapesRequest, ListJobShapesResponse> handler) {
        LOG.trace("Called async listJobShapes");
        ListJobShapesRequest interceptedRequest = ListJobShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobShapesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListJobShapesResponse> transformer = ListJobShapesConverter.fromResponse();
        AsyncHandler<ListJobShapesRequest, ListJobShapesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobShapesRequest, ListJobShapesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobsResponse> listJobs(ListJobsRequest request, AsyncHandler<ListJobsRequest, ListJobsResponse> handler) {
        LOG.trace("Called async listJobs");
        ListJobsRequest interceptedRequest = ListJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListJobsResponse> transformer = ListJobsConverter.fromResponse();
        AsyncHandler<ListJobsRequest, ListJobsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobsRequest, ListJobsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListModelDeploymentShapesResponse> listModelDeploymentShapes(ListModelDeploymentShapesRequest request, AsyncHandler<ListModelDeploymentShapesRequest, ListModelDeploymentShapesResponse> handler) {
        LOG.trace("Called async listModelDeploymentShapes");
        ListModelDeploymentShapesRequest interceptedRequest = ListModelDeploymentShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelDeploymentShapesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListModelDeploymentShapesResponse> transformer = ListModelDeploymentShapesConverter.fromResponse();
        AsyncHandler<ListModelDeploymentShapesRequest, ListModelDeploymentShapesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListModelDeploymentShapesRequest, ListModelDeploymentShapesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListModelDeploymentsResponse> listModelDeployments(ListModelDeploymentsRequest request, AsyncHandler<ListModelDeploymentsRequest, ListModelDeploymentsResponse> handler) {
        LOG.trace("Called async listModelDeployments");
        ListModelDeploymentsRequest interceptedRequest = ListModelDeploymentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelDeploymentsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListModelDeploymentsResponse> transformer = ListModelDeploymentsConverter.fromResponse();
        AsyncHandler<ListModelDeploymentsRequest, ListModelDeploymentsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListModelDeploymentsRequest, ListModelDeploymentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListModelsResponse> listModels(ListModelsRequest request, AsyncHandler<ListModelsRequest, ListModelsResponse> handler) {
        LOG.trace("Called async listModels");
        ListModelsRequest interceptedRequest = ListModelsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListModelsResponse> transformer = ListModelsConverter.fromResponse();
        AsyncHandler<ListModelsRequest, ListModelsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListModelsRequest, ListModelsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListNotebookSessionShapesResponse> listNotebookSessionShapes(ListNotebookSessionShapesRequest request, AsyncHandler<ListNotebookSessionShapesRequest, ListNotebookSessionShapesResponse> handler) {
        LOG.trace("Called async listNotebookSessionShapes");
        ListNotebookSessionShapesRequest interceptedRequest = ListNotebookSessionShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNotebookSessionShapesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListNotebookSessionShapesResponse> transformer = ListNotebookSessionShapesConverter.fromResponse();
        AsyncHandler<ListNotebookSessionShapesRequest, ListNotebookSessionShapesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListNotebookSessionShapesRequest, ListNotebookSessionShapesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListNotebookSessionsResponse> listNotebookSessions(ListNotebookSessionsRequest request, AsyncHandler<ListNotebookSessionsRequest, ListNotebookSessionsResponse> handler) {
        LOG.trace("Called async listNotebookSessions");
        ListNotebookSessionsRequest interceptedRequest = ListNotebookSessionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNotebookSessionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListNotebookSessionsResponse> transformer = ListNotebookSessionsConverter.fromResponse();
        AsyncHandler<ListNotebookSessionsRequest, ListNotebookSessionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListNotebookSessionsRequest, ListNotebookSessionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListProjectsResponse> listProjects(ListProjectsRequest request, AsyncHandler<ListProjectsRequest, ListProjectsResponse> handler) {
        LOG.trace("Called async listProjects");
        ListProjectsRequest interceptedRequest = ListProjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProjectsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListProjectsResponse> transformer = ListProjectsConverter.fromResponse();
        AsyncHandler<ListProjectsRequest, ListProjectsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListProjectsRequest, ListProjectsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateJobResponse> updateJob(UpdateJobRequest request, AsyncHandler<UpdateJobRequest, UpdateJobResponse> handler) {
        LOG.trace("Called async updateJob");
        UpdateJobRequest interceptedRequest = UpdateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateJobResponse> transformer = UpdateJobConverter.fromResponse();
        AsyncHandler<UpdateJobRequest, UpdateJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateJobDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateJobRequest, UpdateJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateJobRunResponse> updateJobRun(UpdateJobRunRequest request, AsyncHandler<UpdateJobRunRequest, UpdateJobRunResponse> handler) {
        LOG.trace("Called async updateJobRun");
        UpdateJobRunRequest interceptedRequest = UpdateJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateJobRunResponse> transformer = UpdateJobRunConverter.fromResponse();
        AsyncHandler<UpdateJobRunRequest, UpdateJobRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateJobRunDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateJobRunRequest, UpdateJobRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateModelResponse> updateModel(UpdateModelRequest request, AsyncHandler<UpdateModelRequest, UpdateModelResponse> handler) {
        LOG.trace("Called async updateModel");
        UpdateModelRequest interceptedRequest = UpdateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateModelResponse> transformer = UpdateModelConverter.fromResponse();
        AsyncHandler<UpdateModelRequest, UpdateModelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateModelDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateModelRequest, UpdateModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateModelDeploymentResponse> updateModelDeployment(UpdateModelDeploymentRequest request, AsyncHandler<UpdateModelDeploymentRequest, UpdateModelDeploymentResponse> handler) {
        LOG.trace("Called async updateModelDeployment");
        UpdateModelDeploymentRequest interceptedRequest = UpdateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateModelDeploymentResponse> transformer = UpdateModelDeploymentConverter.fromResponse();
        AsyncHandler<UpdateModelDeploymentRequest, UpdateModelDeploymentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateModelDeploymentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateModelDeploymentRequest, UpdateModelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateModelProvenanceResponse> updateModelProvenance(UpdateModelProvenanceRequest request, AsyncHandler<UpdateModelProvenanceRequest, UpdateModelProvenanceResponse> handler) {
        LOG.trace("Called async updateModelProvenance");
        UpdateModelProvenanceRequest interceptedRequest = UpdateModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateModelProvenanceResponse> transformer = UpdateModelProvenanceConverter.fromResponse();
        AsyncHandler<UpdateModelProvenanceRequest, UpdateModelProvenanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateModelProvenanceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateModelProvenanceRequest, UpdateModelProvenanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateNotebookSessionResponse> updateNotebookSession(UpdateNotebookSessionRequest request, AsyncHandler<UpdateNotebookSessionRequest, UpdateNotebookSessionResponse> handler) {
        LOG.trace("Called async updateNotebookSession");
        UpdateNotebookSessionRequest interceptedRequest = UpdateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateNotebookSessionResponse> transformer = UpdateNotebookSessionConverter.fromResponse();
        AsyncHandler<UpdateNotebookSessionRequest, UpdateNotebookSessionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateNotebookSessionDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateNotebookSessionRequest, UpdateNotebookSessionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateProjectResponse> updateProject(UpdateProjectRequest request, AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handler) {
        LOG.trace("Called async updateProject");
        UpdateProjectRequest interceptedRequest = UpdateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateProjectResponse> transformer = UpdateProjectConverter.fromResponse();
        AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateProjectDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateProjectRequest, UpdateProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataScienceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DataScienceAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DataScienceAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

