/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.circuitbreaker.JaxRsCircuitBreaker;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datascience.DataScience;
import com.oracle.bmc.datascience.DataSciencePaginators;
import com.oracle.bmc.datascience.DataScienceWaiters;
import com.oracle.bmc.datascience.internal.http.ActivateModelConverter;
import com.oracle.bmc.datascience.internal.http.ActivateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.ActivateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.CancelJobRunConverter;
import com.oracle.bmc.datascience.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.datascience.internal.http.ChangeJobCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeJobRunCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeModelCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeModelDeploymentCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeNotebookSessionCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeProjectCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.CreateJobArtifactConverter;
import com.oracle.bmc.datascience.internal.http.CreateJobConverter;
import com.oracle.bmc.datascience.internal.http.CreateJobRunConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelArtifactConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.CreateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.CreateProjectConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateModelConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.DeleteJobConverter;
import com.oracle.bmc.datascience.internal.http.DeleteJobRunConverter;
import com.oracle.bmc.datascience.internal.http.DeleteModelConverter;
import com.oracle.bmc.datascience.internal.http.DeleteModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.DeleteNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.DeleteProjectConverter;
import com.oracle.bmc.datascience.internal.http.GetJobArtifactContentConverter;
import com.oracle.bmc.datascience.internal.http.GetJobConverter;
import com.oracle.bmc.datascience.internal.http.GetJobRunConverter;
import com.oracle.bmc.datascience.internal.http.GetModelArtifactContentConverter;
import com.oracle.bmc.datascience.internal.http.GetModelConverter;
import com.oracle.bmc.datascience.internal.http.GetModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.GetModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.GetNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.GetProjectConverter;
import com.oracle.bmc.datascience.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.datascience.internal.http.HeadJobArtifactConverter;
import com.oracle.bmc.datascience.internal.http.HeadModelArtifactConverter;
import com.oracle.bmc.datascience.internal.http.ListJobRunsConverter;
import com.oracle.bmc.datascience.internal.http.ListJobShapesConverter;
import com.oracle.bmc.datascience.internal.http.ListJobsConverter;
import com.oracle.bmc.datascience.internal.http.ListModelDeploymentShapesConverter;
import com.oracle.bmc.datascience.internal.http.ListModelDeploymentsConverter;
import com.oracle.bmc.datascience.internal.http.ListModelsConverter;
import com.oracle.bmc.datascience.internal.http.ListNotebookSessionShapesConverter;
import com.oracle.bmc.datascience.internal.http.ListNotebookSessionsConverter;
import com.oracle.bmc.datascience.internal.http.ListProjectsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.datascience.internal.http.UpdateJobConverter;
import com.oracle.bmc.datascience.internal.http.UpdateJobRunConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.UpdateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.UpdateProjectConverter;
import com.oracle.bmc.datascience.requests.ActivateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.ActivateModelRequest;
import com.oracle.bmc.datascience.requests.ActivateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.CancelJobRunRequest;
import com.oracle.bmc.datascience.requests.CancelWorkRequestRequest;
import com.oracle.bmc.datascience.requests.ChangeJobCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeJobRunCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeModelDeploymentCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeNotebookSessionCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.datascience.requests.CreateJobArtifactRequest;
import com.oracle.bmc.datascience.requests.CreateJobRequest;
import com.oracle.bmc.datascience.requests.CreateJobRunRequest;
import com.oracle.bmc.datascience.requests.CreateModelArtifactRequest;
import com.oracle.bmc.datascience.requests.CreateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.CreateModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.CreateModelRequest;
import com.oracle.bmc.datascience.requests.CreateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.CreateProjectRequest;
import com.oracle.bmc.datascience.requests.DeactivateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.DeactivateModelRequest;
import com.oracle.bmc.datascience.requests.DeactivateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.DeleteJobRequest;
import com.oracle.bmc.datascience.requests.DeleteJobRunRequest;
import com.oracle.bmc.datascience.requests.DeleteModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.DeleteModelRequest;
import com.oracle.bmc.datascience.requests.DeleteNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.DeleteProjectRequest;
import com.oracle.bmc.datascience.requests.GetJobArtifactContentRequest;
import com.oracle.bmc.datascience.requests.GetJobRequest;
import com.oracle.bmc.datascience.requests.GetJobRunRequest;
import com.oracle.bmc.datascience.requests.GetModelArtifactContentRequest;
import com.oracle.bmc.datascience.requests.GetModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.GetModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.GetModelRequest;
import com.oracle.bmc.datascience.requests.GetNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.GetProjectRequest;
import com.oracle.bmc.datascience.requests.GetWorkRequestRequest;
import com.oracle.bmc.datascience.requests.HeadJobArtifactRequest;
import com.oracle.bmc.datascience.requests.HeadModelArtifactRequest;
import com.oracle.bmc.datascience.requests.ListJobRunsRequest;
import com.oracle.bmc.datascience.requests.ListJobShapesRequest;
import com.oracle.bmc.datascience.requests.ListJobsRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentShapesRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentsRequest;
import com.oracle.bmc.datascience.requests.ListModelsRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionShapesRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionsRequest;
import com.oracle.bmc.datascience.requests.ListProjectsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datascience.requests.UpdateJobRequest;
import com.oracle.bmc.datascience.requests.UpdateJobRunRequest;
import com.oracle.bmc.datascience.requests.UpdateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.UpdateModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.UpdateModelRequest;
import com.oracle.bmc.datascience.requests.UpdateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.UpdateProjectRequest;
import com.oracle.bmc.datascience.responses.ActivateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.ActivateModelResponse;
import com.oracle.bmc.datascience.responses.ActivateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.CancelJobRunResponse;
import com.oracle.bmc.datascience.responses.CancelWorkRequestResponse;
import com.oracle.bmc.datascience.responses.ChangeJobCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeJobRunCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeModelDeploymentCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeNotebookSessionCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.datascience.responses.CreateJobArtifactResponse;
import com.oracle.bmc.datascience.responses.CreateJobResponse;
import com.oracle.bmc.datascience.responses.CreateJobRunResponse;
import com.oracle.bmc.datascience.responses.CreateModelArtifactResponse;
import com.oracle.bmc.datascience.responses.CreateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.CreateModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.CreateModelResponse;
import com.oracle.bmc.datascience.responses.CreateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.CreateProjectResponse;
import com.oracle.bmc.datascience.responses.DeactivateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.DeactivateModelResponse;
import com.oracle.bmc.datascience.responses.DeactivateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.DeleteJobResponse;
import com.oracle.bmc.datascience.responses.DeleteJobRunResponse;
import com.oracle.bmc.datascience.responses.DeleteModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.DeleteModelResponse;
import com.oracle.bmc.datascience.responses.DeleteNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.DeleteProjectResponse;
import com.oracle.bmc.datascience.responses.GetJobArtifactContentResponse;
import com.oracle.bmc.datascience.responses.GetJobResponse;
import com.oracle.bmc.datascience.responses.GetJobRunResponse;
import com.oracle.bmc.datascience.responses.GetModelArtifactContentResponse;
import com.oracle.bmc.datascience.responses.GetModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.GetModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.GetModelResponse;
import com.oracle.bmc.datascience.responses.GetNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.GetProjectResponse;
import com.oracle.bmc.datascience.responses.GetWorkRequestResponse;
import com.oracle.bmc.datascience.responses.HeadJobArtifactResponse;
import com.oracle.bmc.datascience.responses.HeadModelArtifactResponse;
import com.oracle.bmc.datascience.responses.ListJobRunsResponse;
import com.oracle.bmc.datascience.responses.ListJobShapesResponse;
import com.oracle.bmc.datascience.responses.ListJobsResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentShapesResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentsResponse;
import com.oracle.bmc.datascience.responses.ListModelsResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionShapesResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionsResponse;
import com.oracle.bmc.datascience.responses.ListProjectsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datascience.responses.UpdateJobResponse;
import com.oracle.bmc.datascience.responses.UpdateJobRunResponse;
import com.oracle.bmc.datascience.responses.UpdateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.UpdateModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.UpdateModelResponse;
import com.oracle.bmc.datascience.responses.UpdateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.UpdateProjectResponse;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.RetryUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.io.internal.KeepOpenInputStream;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataScienceClient
implements DataScience {
    private static final Logger LOG = LoggerFactory.getLogger(DataScienceClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATASCIENCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datascience.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DataScienceWaiters waiters;
    private final DataSciencePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    public DataScienceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataScienceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataScienceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        JaxRsCircuitBreaker circuitBreaker = CircuitBreakerUtils.getUserDefinedCircuitBreaker((ClientConfiguration)configuration);
        if (circuitBreaker == null) {
            circuitBreaker = CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER;
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse, isNonBufferingApacheClient, circuitBreaker);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DataScience-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DataScienceWaiters(executorService, this);
        this.paginators = new DataSciencePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ActivateModelResponse activateModel(ActivateModelRequest request) {
        LOG.trace("Called activateModel");
        ActivateModelRequest interceptedRequest = ActivateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ActivateModelResponse> transformer = ActivateModelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ActivateModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ActivateModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ActivateModelResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ActivateModelDeploymentResponse activateModelDeployment(ActivateModelDeploymentRequest request) {
        LOG.trace("Called activateModelDeployment");
        ActivateModelDeploymentRequest interceptedRequest = ActivateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ActivateModelDeploymentResponse> transformer = ActivateModelDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ActivateModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ActivateModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ActivateModelDeploymentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ActivateNotebookSessionResponse activateNotebookSession(ActivateNotebookSessionRequest request) {
        LOG.trace("Called activateNotebookSession");
        ActivateNotebookSessionRequest interceptedRequest = ActivateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ActivateNotebookSessionResponse> transformer = ActivateNotebookSessionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ActivateNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ActivateNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ActivateNotebookSessionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CancelJobRunResponse cancelJobRun(CancelJobRunRequest request) {
        LOG.trace("Called cancelJobRun");
        CancelJobRunRequest interceptedRequest = CancelJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelJobRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelJobRunResponse> transformer = CancelJobRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CancelJobRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelJobRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (CancelJobRunResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        LOG.trace("Called cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CancelWorkRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelWorkRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (CancelWorkRequestResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeJobCompartmentResponse changeJobCompartment(ChangeJobCompartmentRequest request) {
        LOG.trace("Called changeJobCompartment");
        ChangeJobCompartmentRequest interceptedRequest = ChangeJobCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeJobCompartmentResponse> transformer = ChangeJobCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ChangeJobCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeJobCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeJobCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeJobCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeJobRunCompartmentResponse changeJobRunCompartment(ChangeJobRunCompartmentRequest request) {
        LOG.trace("Called changeJobRunCompartment");
        ChangeJobRunCompartmentRequest interceptedRequest = ChangeJobRunCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeJobRunCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeJobRunCompartmentResponse> transformer = ChangeJobRunCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ChangeJobRunCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeJobRunCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeJobRunCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeJobRunCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeModelCompartmentResponse changeModelCompartment(ChangeModelCompartmentRequest request) {
        LOG.trace("Called changeModelCompartment");
        ChangeModelCompartmentRequest interceptedRequest = ChangeModelCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeModelCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeModelCompartmentResponse> transformer = ChangeModelCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ChangeModelCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeModelCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeModelCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeModelCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeModelDeploymentCompartmentResponse changeModelDeploymentCompartment(ChangeModelDeploymentCompartmentRequest request) {
        LOG.trace("Called changeModelDeploymentCompartment");
        ChangeModelDeploymentCompartmentRequest interceptedRequest = ChangeModelDeploymentCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeModelDeploymentCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeModelDeploymentCompartmentResponse> transformer = ChangeModelDeploymentCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ChangeModelDeploymentCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeModelDeploymentCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeModelDeploymentCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeModelDeploymentCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeNotebookSessionCompartmentResponse changeNotebookSessionCompartment(ChangeNotebookSessionCompartmentRequest request) {
        LOG.trace("Called changeNotebookSessionCompartment");
        ChangeNotebookSessionCompartmentRequest interceptedRequest = ChangeNotebookSessionCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeNotebookSessionCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeNotebookSessionCompartmentResponse> transformer = ChangeNotebookSessionCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ChangeNotebookSessionCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeNotebookSessionCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeNotebookSessionCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeNotebookSessionCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeProjectCompartmentResponse changeProjectCompartment(ChangeProjectCompartmentRequest request) {
        LOG.trace("Called changeProjectCompartment");
        ChangeProjectCompartmentRequest interceptedRequest = ChangeProjectCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeProjectCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeProjectCompartmentResponse> transformer = ChangeProjectCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ChangeProjectCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeProjectCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeProjectCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeProjectCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) {
        LOG.trace("Called createJob");
        CreateJobRequest interceptedRequest = CreateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateJobResponse> transformer = CreateJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateJobDetails(), (BmcRequest)retriedRequest);
                return (CreateJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobArtifactResponse createJobArtifact(CreateJobArtifactRequest request) {
        LOG.trace("Called createJobArtifact");
        try {
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (CreateJobArtifactRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)CreateJobArtifactRequest.builder());
            }
            CreateJobArtifactRequest interceptedRequest = CreateJobArtifactConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = CreateJobArtifactConverter.fromRequest(this.client, interceptedRequest);
            Function<Response, CreateJobArtifactResponse> transformer = CreateJobArtifactConverter.fromResponse();
            ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
            RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
            RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
            CreateJobArtifactResponse createJobArtifactResponse = (CreateJobArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (CreateJobArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.post(ib, (Object)retriedRequest.getJobArtifact(), (BmcRequest)retriedRequest);
                        return (CreateJobArtifactResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getJobArtifact(), (boolean)true);
                        }
                        throw e;
                    }
                })));
            }));
            return createJobArtifactResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getJobArtifact());
        }
    }

    @Override
    public CreateJobRunResponse createJobRun(CreateJobRunRequest request) {
        LOG.trace("Called createJobRun");
        CreateJobRunRequest interceptedRequest = CreateJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateJobRunResponse> transformer = CreateJobRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateJobRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateJobRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateJobRunDetails(), (BmcRequest)retriedRequest);
                return (CreateJobRunResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateModelResponse createModel(CreateModelRequest request) {
        LOG.trace("Called createModel");
        CreateModelRequest interceptedRequest = CreateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateModelResponse> transformer = CreateModelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateModelDetails(), (BmcRequest)retriedRequest);
                return (CreateModelResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateModelArtifactResponse createModelArtifact(CreateModelArtifactRequest request) {
        LOG.trace("Called createModelArtifact");
        try {
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (CreateModelArtifactRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)CreateModelArtifactRequest.builder());
            }
            CreateModelArtifactRequest interceptedRequest = CreateModelArtifactConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = CreateModelArtifactConverter.fromRequest(this.client, interceptedRequest);
            Function<Response, CreateModelArtifactResponse> transformer = CreateModelArtifactConverter.fromResponse();
            ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
            RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
            RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
            CreateModelArtifactResponse createModelArtifactResponse = (CreateModelArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (CreateModelArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.post(ib, (Object)retriedRequest.getModelArtifact(), (BmcRequest)retriedRequest);
                        return (CreateModelArtifactResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getModelArtifact(), (boolean)true);
                        }
                        throw e;
                    }
                })));
            }));
            return createModelArtifactResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getModelArtifact());
        }
    }

    @Override
    public CreateModelDeploymentResponse createModelDeployment(CreateModelDeploymentRequest request) {
        LOG.trace("Called createModelDeployment");
        CreateModelDeploymentRequest interceptedRequest = CreateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateModelDeploymentResponse> transformer = CreateModelDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateModelDeploymentDetails(), (BmcRequest)retriedRequest);
                return (CreateModelDeploymentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateModelProvenanceResponse createModelProvenance(CreateModelProvenanceRequest request) {
        LOG.trace("Called createModelProvenance");
        CreateModelProvenanceRequest interceptedRequest = CreateModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateModelProvenanceResponse> transformer = CreateModelProvenanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateModelProvenanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateModelProvenanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateModelProvenanceDetails(), (BmcRequest)retriedRequest);
                return (CreateModelProvenanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateNotebookSessionResponse createNotebookSession(CreateNotebookSessionRequest request) {
        LOG.trace("Called createNotebookSession");
        CreateNotebookSessionRequest interceptedRequest = CreateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateNotebookSessionResponse> transformer = CreateNotebookSessionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateNotebookSessionDetails(), (BmcRequest)retriedRequest);
                return (CreateNotebookSessionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) {
        LOG.trace("Called createProject");
        CreateProjectRequest interceptedRequest = CreateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateProjectResponse> transformer = CreateProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateProjectDetails(), (BmcRequest)retriedRequest);
                return (CreateProjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeactivateModelResponse deactivateModel(DeactivateModelRequest request) {
        LOG.trace("Called deactivateModel");
        DeactivateModelRequest interceptedRequest = DeactivateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeactivateModelResponse> transformer = DeactivateModelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeactivateModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeactivateModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DeactivateModelResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeactivateModelDeploymentResponse deactivateModelDeployment(DeactivateModelDeploymentRequest request) {
        LOG.trace("Called deactivateModelDeployment");
        DeactivateModelDeploymentRequest interceptedRequest = DeactivateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeactivateModelDeploymentResponse> transformer = DeactivateModelDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeactivateModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeactivateModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DeactivateModelDeploymentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeactivateNotebookSessionResponse deactivateNotebookSession(DeactivateNotebookSessionRequest request) {
        LOG.trace("Called deactivateNotebookSession");
        DeactivateNotebookSessionRequest interceptedRequest = DeactivateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeactivateNotebookSessionResponse> transformer = DeactivateNotebookSessionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeactivateNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeactivateNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DeactivateNotebookSessionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest request) {
        LOG.trace("Called deleteJob");
        DeleteJobRequest interceptedRequest = DeleteJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteJobResponse> transformer = DeleteJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteJobRunResponse deleteJobRun(DeleteJobRunRequest request) {
        LOG.trace("Called deleteJobRun");
        DeleteJobRunRequest interceptedRequest = DeleteJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteJobRunResponse> transformer = DeleteJobRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteJobRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteJobRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteJobRunResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest request) {
        LOG.trace("Called deleteModel");
        DeleteModelRequest interceptedRequest = DeleteModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteModelResponse> transformer = DeleteModelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteModelResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteModelDeploymentResponse deleteModelDeployment(DeleteModelDeploymentRequest request) {
        LOG.trace("Called deleteModelDeployment");
        DeleteModelDeploymentRequest interceptedRequest = DeleteModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteModelDeploymentResponse> transformer = DeleteModelDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteModelDeploymentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteNotebookSessionResponse deleteNotebookSession(DeleteNotebookSessionRequest request) {
        LOG.trace("Called deleteNotebookSession");
        DeleteNotebookSessionRequest interceptedRequest = DeleteNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteNotebookSessionResponse> transformer = DeleteNotebookSessionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteNotebookSessionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest request) {
        LOG.trace("Called deleteProject");
        DeleteProjectRequest interceptedRequest = DeleteProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteProjectResponse> transformer = DeleteProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteProjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) {
        LOG.trace("Called getJob");
        GetJobRequest interceptedRequest = GetJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobResponse> transformer = GetJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetJobArtifactContentResponse getJobArtifactContent(GetJobArtifactContentRequest request) {
        LOG.trace("Called getJobArtifactContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getJobArtifactContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetJobArtifactContentRequest interceptedRequest = GetJobArtifactContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobArtifactContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobArtifactContentResponse> transformer = GetJobArtifactContentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetJobArtifactContentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobArtifactContentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobArtifactContentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetJobRunResponse getJobRun(GetJobRunRequest request) {
        LOG.trace("Called getJobRun");
        GetJobRunRequest interceptedRequest = GetJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobRunResponse> transformer = GetJobRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetJobRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobRunResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetModelResponse getModel(GetModelRequest request) {
        LOG.trace("Called getModel");
        GetModelRequest interceptedRequest = GetModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetModelResponse> transformer = GetModelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModelResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetModelArtifactContentResponse getModelArtifactContent(GetModelArtifactContentRequest request) {
        LOG.trace("Called getModelArtifactContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getModelArtifactContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetModelArtifactContentRequest interceptedRequest = GetModelArtifactContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelArtifactContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetModelArtifactContentResponse> transformer = GetModelArtifactContentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetModelArtifactContentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModelArtifactContentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModelArtifactContentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetModelDeploymentResponse getModelDeployment(GetModelDeploymentRequest request) {
        LOG.trace("Called getModelDeployment");
        GetModelDeploymentRequest interceptedRequest = GetModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetModelDeploymentResponse> transformer = GetModelDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModelDeploymentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetModelProvenanceResponse getModelProvenance(GetModelProvenanceRequest request) {
        LOG.trace("Called getModelProvenance");
        GetModelProvenanceRequest interceptedRequest = GetModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetModelProvenanceResponse> transformer = GetModelProvenanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetModelProvenanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModelProvenanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModelProvenanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetNotebookSessionResponse getNotebookSession(GetNotebookSessionRequest request) {
        LOG.trace("Called getNotebookSession");
        GetNotebookSessionRequest interceptedRequest = GetNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNotebookSessionResponse> transformer = GetNotebookSessionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetNotebookSessionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetProjectResponse getProject(GetProjectRequest request) {
        LOG.trace("Called getProject");
        GetProjectRequest interceptedRequest = GetProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetProjectResponse> transformer = GetProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetProjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetWorkRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public HeadJobArtifactResponse headJobArtifact(HeadJobArtifactRequest request) {
        LOG.trace("Called headJobArtifact");
        HeadJobArtifactRequest interceptedRequest = HeadJobArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadJobArtifactConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, HeadJobArtifactResponse> transformer = HeadJobArtifactConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (HeadJobArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (HeadJobArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.head(ib, (BmcRequest)retriedRequest);
                return (HeadJobArtifactResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public HeadModelArtifactResponse headModelArtifact(HeadModelArtifactRequest request) {
        LOG.trace("Called headModelArtifact");
        HeadModelArtifactRequest interceptedRequest = HeadModelArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadModelArtifactConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, HeadModelArtifactResponse> transformer = HeadModelArtifactConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (HeadModelArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (HeadModelArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.head(ib, (BmcRequest)retriedRequest);
                return (HeadModelArtifactResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListJobRunsResponse listJobRuns(ListJobRunsRequest request) {
        LOG.trace("Called listJobRuns");
        ListJobRunsRequest interceptedRequest = ListJobRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobRunsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobRunsResponse> transformer = ListJobRunsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListJobRunsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobRunsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobRunsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListJobShapesResponse listJobShapes(ListJobShapesRequest request) {
        LOG.trace("Called listJobShapes");
        ListJobShapesRequest interceptedRequest = ListJobShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobShapesResponse> transformer = ListJobShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListJobShapesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobShapesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobShapesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) {
        LOG.trace("Called listJobs");
        ListJobsRequest interceptedRequest = ListJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobsResponse> transformer = ListJobsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListJobsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListModelDeploymentShapesResponse listModelDeploymentShapes(ListModelDeploymentShapesRequest request) {
        LOG.trace("Called listModelDeploymentShapes");
        ListModelDeploymentShapesRequest interceptedRequest = ListModelDeploymentShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelDeploymentShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListModelDeploymentShapesResponse> transformer = ListModelDeploymentShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListModelDeploymentShapesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModelDeploymentShapesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModelDeploymentShapesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListModelDeploymentsResponse listModelDeployments(ListModelDeploymentsRequest request) {
        LOG.trace("Called listModelDeployments");
        ListModelDeploymentsRequest interceptedRequest = ListModelDeploymentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelDeploymentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListModelDeploymentsResponse> transformer = ListModelDeploymentsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListModelDeploymentsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModelDeploymentsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModelDeploymentsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListModelsResponse listModels(ListModelsRequest request) {
        LOG.trace("Called listModels");
        ListModelsRequest interceptedRequest = ListModelsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListModelsResponse> transformer = ListModelsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListModelsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModelsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModelsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListNotebookSessionShapesResponse listNotebookSessionShapes(ListNotebookSessionShapesRequest request) {
        LOG.trace("Called listNotebookSessionShapes");
        ListNotebookSessionShapesRequest interceptedRequest = ListNotebookSessionShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNotebookSessionShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNotebookSessionShapesResponse> transformer = ListNotebookSessionShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListNotebookSessionShapesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListNotebookSessionShapesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListNotebookSessionShapesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListNotebookSessionsResponse listNotebookSessions(ListNotebookSessionsRequest request) {
        LOG.trace("Called listNotebookSessions");
        ListNotebookSessionsRequest interceptedRequest = ListNotebookSessionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNotebookSessionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNotebookSessionsResponse> transformer = ListNotebookSessionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListNotebookSessionsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListNotebookSessionsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListNotebookSessionsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest request) {
        LOG.trace("Called listProjects");
        ListProjectsRequest interceptedRequest = ListProjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProjectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListProjectsResponse> transformer = ListProjectsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListProjectsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListProjectsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListProjectsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListWorkRequestErrorsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListWorkRequestLogsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListWorkRequestsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) {
        LOG.trace("Called updateJob");
        UpdateJobRequest interceptedRequest = UpdateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateJobResponse> transformer = UpdateJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateJobDetails(), (BmcRequest)retriedRequest);
                return (UpdateJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateJobRunResponse updateJobRun(UpdateJobRunRequest request) {
        LOG.trace("Called updateJobRun");
        UpdateJobRunRequest interceptedRequest = UpdateJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateJobRunResponse> transformer = UpdateJobRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateJobRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateJobRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateJobRunDetails(), (BmcRequest)retriedRequest);
                return (UpdateJobRunResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateModelResponse updateModel(UpdateModelRequest request) {
        LOG.trace("Called updateModel");
        UpdateModelRequest interceptedRequest = UpdateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateModelResponse> transformer = UpdateModelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateModelDetails(), (BmcRequest)retriedRequest);
                return (UpdateModelResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateModelDeploymentResponse updateModelDeployment(UpdateModelDeploymentRequest request) {
        LOG.trace("Called updateModelDeployment");
        UpdateModelDeploymentRequest interceptedRequest = UpdateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateModelDeploymentResponse> transformer = UpdateModelDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateModelDeploymentDetails(), (BmcRequest)retriedRequest);
                return (UpdateModelDeploymentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateModelProvenanceResponse updateModelProvenance(UpdateModelProvenanceRequest request) {
        LOG.trace("Called updateModelProvenance");
        UpdateModelProvenanceRequest interceptedRequest = UpdateModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateModelProvenanceResponse> transformer = UpdateModelProvenanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateModelProvenanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateModelProvenanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateModelProvenanceDetails(), (BmcRequest)retriedRequest);
                return (UpdateModelProvenanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateNotebookSessionResponse updateNotebookSession(UpdateNotebookSessionRequest request) {
        LOG.trace("Called updateNotebookSession");
        UpdateNotebookSessionRequest interceptedRequest = UpdateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNotebookSessionResponse> transformer = UpdateNotebookSessionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateNotebookSessionDetails(), (BmcRequest)retriedRequest);
                return (UpdateNotebookSessionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) {
        LOG.trace("Called updateProject");
        UpdateProjectRequest interceptedRequest = UpdateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateProjectResponse> transformer = UpdateProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateProjectDetails(), (BmcRequest)retriedRequest);
                return (UpdateProjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DataScienceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DataSciencePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataScienceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DataScienceClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DataScienceClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

