/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.datascience.DataScience;
import com.oracle.bmc.datascience.model.JobRunSummary;
import com.oracle.bmc.datascience.model.JobShapeSummary;
import com.oracle.bmc.datascience.model.JobSummary;
import com.oracle.bmc.datascience.model.ModelDeploymentShapeSummary;
import com.oracle.bmc.datascience.model.ModelDeploymentSummary;
import com.oracle.bmc.datascience.model.ModelSummary;
import com.oracle.bmc.datascience.model.NotebookSessionShapeSummary;
import com.oracle.bmc.datascience.model.NotebookSessionSummary;
import com.oracle.bmc.datascience.model.ProjectSummary;
import com.oracle.bmc.datascience.model.WorkRequestSummary;
import com.oracle.bmc.datascience.requests.ListJobRunsRequest;
import com.oracle.bmc.datascience.requests.ListJobShapesRequest;
import com.oracle.bmc.datascience.requests.ListJobsRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentShapesRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentsRequest;
import com.oracle.bmc.datascience.requests.ListModelsRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionShapesRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionsRequest;
import com.oracle.bmc.datascience.requests.ListProjectsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datascience.responses.ListJobRunsResponse;
import com.oracle.bmc.datascience.responses.ListJobShapesResponse;
import com.oracle.bmc.datascience.responses.ListJobsResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentShapesResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentsResponse;
import com.oracle.bmc.datascience.responses.ListModelsResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionShapesResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionsResponse;
import com.oracle.bmc.datascience.responses.ListProjectsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class DataSciencePaginators {
    private final DataScience client;

    public Iterable<ListJobRunsResponse> listJobRunsResponseIterator(final ListJobRunsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobRunsRequest.Builder>(){

            public ListJobRunsRequest.Builder get() {
                return ListJobRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobRunsResponse, String>(){

            public String apply(ListJobRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobRunsRequest.Builder>, ListJobRunsRequest>(){

            public ListJobRunsRequest apply(RequestBuilderAndToken<ListJobRunsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobRunsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobRunsRequest, ListJobRunsResponse>(){

            public ListJobRunsResponse apply(ListJobRunsRequest request) {
                return DataSciencePaginators.this.client.listJobRuns(request);
            }
        });
    }

    public Iterable<JobRunSummary> listJobRunsRecordIterator(final ListJobRunsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobRunsRequest.Builder>(){

            public ListJobRunsRequest.Builder get() {
                return ListJobRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobRunsResponse, String>(){

            public String apply(ListJobRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobRunsRequest.Builder>, ListJobRunsRequest>(){

            public ListJobRunsRequest apply(RequestBuilderAndToken<ListJobRunsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobRunsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobRunsRequest, ListJobRunsResponse>(){

            public ListJobRunsResponse apply(ListJobRunsRequest request) {
                return DataSciencePaginators.this.client.listJobRuns(request);
            }
        }, (Function)new Function<ListJobRunsResponse, List<JobRunSummary>>(){

            public List<JobRunSummary> apply(ListJobRunsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListJobShapesResponse> listJobShapesResponseIterator(final ListJobShapesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobShapesRequest.Builder>(){

            public ListJobShapesRequest.Builder get() {
                return ListJobShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobShapesResponse, String>(){

            public String apply(ListJobShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobShapesRequest.Builder>, ListJobShapesRequest>(){

            public ListJobShapesRequest apply(RequestBuilderAndToken<ListJobShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobShapesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobShapesRequest, ListJobShapesResponse>(){

            public ListJobShapesResponse apply(ListJobShapesRequest request) {
                return DataSciencePaginators.this.client.listJobShapes(request);
            }
        });
    }

    public Iterable<JobShapeSummary> listJobShapesRecordIterator(final ListJobShapesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobShapesRequest.Builder>(){

            public ListJobShapesRequest.Builder get() {
                return ListJobShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobShapesResponse, String>(){

            public String apply(ListJobShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobShapesRequest.Builder>, ListJobShapesRequest>(){

            public ListJobShapesRequest apply(RequestBuilderAndToken<ListJobShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobShapesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobShapesRequest, ListJobShapesResponse>(){

            public ListJobShapesResponse apply(ListJobShapesRequest request) {
                return DataSciencePaginators.this.client.listJobShapes(request);
            }
        }, (Function)new Function<ListJobShapesResponse, List<JobShapeSummary>>(){

            public List<JobShapeSummary> apply(ListJobShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListJobsResponse> listJobsResponseIterator(final ListJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobsRequest.Builder>(){

            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobsResponse, String>(){

            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobsRequest, ListJobsResponse>(){

            public ListJobsResponse apply(ListJobsRequest request) {
                return DataSciencePaginators.this.client.listJobs(request);
            }
        });
    }

    public Iterable<JobSummary> listJobsRecordIterator(final ListJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobsRequest.Builder>(){

            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobsResponse, String>(){

            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobsRequest, ListJobsResponse>(){

            public ListJobsResponse apply(ListJobsRequest request) {
                return DataSciencePaginators.this.client.listJobs(request);
            }
        }, (Function)new Function<ListJobsResponse, List<JobSummary>>(){

            public List<JobSummary> apply(ListJobsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListModelDeploymentShapesResponse> listModelDeploymentShapesResponseIterator(final ListModelDeploymentShapesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListModelDeploymentShapesRequest.Builder>(){

            public ListModelDeploymentShapesRequest.Builder get() {
                return ListModelDeploymentShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelDeploymentShapesResponse, String>(){

            public String apply(ListModelDeploymentShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelDeploymentShapesRequest.Builder>, ListModelDeploymentShapesRequest>(){

            public ListModelDeploymentShapesRequest apply(RequestBuilderAndToken<ListModelDeploymentShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListModelDeploymentShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelDeploymentShapesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListModelDeploymentShapesRequest, ListModelDeploymentShapesResponse>(){

            public ListModelDeploymentShapesResponse apply(ListModelDeploymentShapesRequest request) {
                return DataSciencePaginators.this.client.listModelDeploymentShapes(request);
            }
        });
    }

    public Iterable<ModelDeploymentShapeSummary> listModelDeploymentShapesRecordIterator(final ListModelDeploymentShapesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListModelDeploymentShapesRequest.Builder>(){

            public ListModelDeploymentShapesRequest.Builder get() {
                return ListModelDeploymentShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelDeploymentShapesResponse, String>(){

            public String apply(ListModelDeploymentShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelDeploymentShapesRequest.Builder>, ListModelDeploymentShapesRequest>(){

            public ListModelDeploymentShapesRequest apply(RequestBuilderAndToken<ListModelDeploymentShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListModelDeploymentShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelDeploymentShapesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListModelDeploymentShapesRequest, ListModelDeploymentShapesResponse>(){

            public ListModelDeploymentShapesResponse apply(ListModelDeploymentShapesRequest request) {
                return DataSciencePaginators.this.client.listModelDeploymentShapes(request);
            }
        }, (Function)new Function<ListModelDeploymentShapesResponse, List<ModelDeploymentShapeSummary>>(){

            public List<ModelDeploymentShapeSummary> apply(ListModelDeploymentShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListModelDeploymentsResponse> listModelDeploymentsResponseIterator(final ListModelDeploymentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListModelDeploymentsRequest.Builder>(){

            public ListModelDeploymentsRequest.Builder get() {
                return ListModelDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelDeploymentsResponse, String>(){

            public String apply(ListModelDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelDeploymentsRequest.Builder>, ListModelDeploymentsRequest>(){

            public ListModelDeploymentsRequest apply(RequestBuilderAndToken<ListModelDeploymentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListModelDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelDeploymentsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListModelDeploymentsRequest, ListModelDeploymentsResponse>(){

            public ListModelDeploymentsResponse apply(ListModelDeploymentsRequest request) {
                return DataSciencePaginators.this.client.listModelDeployments(request);
            }
        });
    }

    public Iterable<ModelDeploymentSummary> listModelDeploymentsRecordIterator(final ListModelDeploymentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListModelDeploymentsRequest.Builder>(){

            public ListModelDeploymentsRequest.Builder get() {
                return ListModelDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelDeploymentsResponse, String>(){

            public String apply(ListModelDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelDeploymentsRequest.Builder>, ListModelDeploymentsRequest>(){

            public ListModelDeploymentsRequest apply(RequestBuilderAndToken<ListModelDeploymentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListModelDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelDeploymentsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListModelDeploymentsRequest, ListModelDeploymentsResponse>(){

            public ListModelDeploymentsResponse apply(ListModelDeploymentsRequest request) {
                return DataSciencePaginators.this.client.listModelDeployments(request);
            }
        }, (Function)new Function<ListModelDeploymentsResponse, List<ModelDeploymentSummary>>(){

            public List<ModelDeploymentSummary> apply(ListModelDeploymentsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListModelsResponse> listModelsResponseIterator(final ListModelsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListModelsRequest.Builder>(){

            public ListModelsRequest.Builder get() {
                return ListModelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelsResponse, String>(){

            public String apply(ListModelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelsRequest.Builder>, ListModelsRequest>(){

            public ListModelsRequest apply(RequestBuilderAndToken<ListModelsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListModelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListModelsRequest, ListModelsResponse>(){

            public ListModelsResponse apply(ListModelsRequest request) {
                return DataSciencePaginators.this.client.listModels(request);
            }
        });
    }

    public Iterable<ModelSummary> listModelsRecordIterator(final ListModelsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListModelsRequest.Builder>(){

            public ListModelsRequest.Builder get() {
                return ListModelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelsResponse, String>(){

            public String apply(ListModelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelsRequest.Builder>, ListModelsRequest>(){

            public ListModelsRequest apply(RequestBuilderAndToken<ListModelsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListModelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListModelsRequest, ListModelsResponse>(){

            public ListModelsResponse apply(ListModelsRequest request) {
                return DataSciencePaginators.this.client.listModels(request);
            }
        }, (Function)new Function<ListModelsResponse, List<ModelSummary>>(){

            public List<ModelSummary> apply(ListModelsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListNotebookSessionShapesResponse> listNotebookSessionShapesResponseIterator(final ListNotebookSessionShapesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNotebookSessionShapesRequest.Builder>(){

            public ListNotebookSessionShapesRequest.Builder get() {
                return ListNotebookSessionShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNotebookSessionShapesResponse, String>(){

            public String apply(ListNotebookSessionShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNotebookSessionShapesRequest.Builder>, ListNotebookSessionShapesRequest>(){

            public ListNotebookSessionShapesRequest apply(RequestBuilderAndToken<ListNotebookSessionShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListNotebookSessionShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNotebookSessionShapesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListNotebookSessionShapesRequest, ListNotebookSessionShapesResponse>(){

            public ListNotebookSessionShapesResponse apply(ListNotebookSessionShapesRequest request) {
                return DataSciencePaginators.this.client.listNotebookSessionShapes(request);
            }
        });
    }

    public Iterable<NotebookSessionShapeSummary> listNotebookSessionShapesRecordIterator(final ListNotebookSessionShapesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNotebookSessionShapesRequest.Builder>(){

            public ListNotebookSessionShapesRequest.Builder get() {
                return ListNotebookSessionShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNotebookSessionShapesResponse, String>(){

            public String apply(ListNotebookSessionShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNotebookSessionShapesRequest.Builder>, ListNotebookSessionShapesRequest>(){

            public ListNotebookSessionShapesRequest apply(RequestBuilderAndToken<ListNotebookSessionShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListNotebookSessionShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNotebookSessionShapesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListNotebookSessionShapesRequest, ListNotebookSessionShapesResponse>(){

            public ListNotebookSessionShapesResponse apply(ListNotebookSessionShapesRequest request) {
                return DataSciencePaginators.this.client.listNotebookSessionShapes(request);
            }
        }, (Function)new Function<ListNotebookSessionShapesResponse, List<NotebookSessionShapeSummary>>(){

            public List<NotebookSessionShapeSummary> apply(ListNotebookSessionShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListNotebookSessionsResponse> listNotebookSessionsResponseIterator(final ListNotebookSessionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNotebookSessionsRequest.Builder>(){

            public ListNotebookSessionsRequest.Builder get() {
                return ListNotebookSessionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNotebookSessionsResponse, String>(){

            public String apply(ListNotebookSessionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNotebookSessionsRequest.Builder>, ListNotebookSessionsRequest>(){

            public ListNotebookSessionsRequest apply(RequestBuilderAndToken<ListNotebookSessionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListNotebookSessionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNotebookSessionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListNotebookSessionsRequest, ListNotebookSessionsResponse>(){

            public ListNotebookSessionsResponse apply(ListNotebookSessionsRequest request) {
                return DataSciencePaginators.this.client.listNotebookSessions(request);
            }
        });
    }

    public Iterable<NotebookSessionSummary> listNotebookSessionsRecordIterator(final ListNotebookSessionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNotebookSessionsRequest.Builder>(){

            public ListNotebookSessionsRequest.Builder get() {
                return ListNotebookSessionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNotebookSessionsResponse, String>(){

            public String apply(ListNotebookSessionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNotebookSessionsRequest.Builder>, ListNotebookSessionsRequest>(){

            public ListNotebookSessionsRequest apply(RequestBuilderAndToken<ListNotebookSessionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListNotebookSessionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNotebookSessionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListNotebookSessionsRequest, ListNotebookSessionsResponse>(){

            public ListNotebookSessionsResponse apply(ListNotebookSessionsRequest request) {
                return DataSciencePaginators.this.client.listNotebookSessions(request);
            }
        }, (Function)new Function<ListNotebookSessionsResponse, List<NotebookSessionSummary>>(){

            public List<NotebookSessionSummary> apply(ListNotebookSessionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListProjectsResponse> listProjectsResponseIterator(final ListProjectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            public ListProjectsResponse apply(ListProjectsRequest request) {
                return DataSciencePaginators.this.client.listProjects(request);
            }
        });
    }

    public Iterable<ProjectSummary> listProjectsRecordIterator(final ListProjectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            public ListProjectsResponse apply(ListProjectsRequest request) {
                return DataSciencePaginators.this.client.listProjects(request);
            }
        }, (Function)new Function<ListProjectsResponse, List<ProjectSummary>>(){

            public List<ProjectSummary> apply(ListProjectsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataSciencePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataSciencePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public DataSciencePaginators(DataScience client) {
        this.client = client;
    }
}

