/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobShapeSummary {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="coreCount")
    private final Integer coreCount;
    @JsonProperty(value="memoryInGBs")
    private final Integer memoryInGBs;
    @JsonProperty(value="shapeSeries")
    private final ShapeSeries shapeSeries;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().name(this.name).coreCount(this.coreCount).memoryInGBs(this.memoryInGBs).shapeSeries(this.shapeSeries);
    }

    public String getName() {
        return this.name;
    }

    public Integer getCoreCount() {
        return this.coreCount;
    }

    public Integer getMemoryInGBs() {
        return this.memoryInGBs;
    }

    public ShapeSeries getShapeSeries() {
        return this.shapeSeries;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobShapeSummary)) {
            return false;
        }
        JobShapeSummary other = (JobShapeSummary)o;
        Integer this$coreCount = this.getCoreCount();
        Integer other$coreCount = other.getCoreCount();
        if (this$coreCount == null ? other$coreCount != null : !((Object)this$coreCount).equals(other$coreCount)) {
            return false;
        }
        Integer this$memoryInGBs = this.getMemoryInGBs();
        Integer other$memoryInGBs = other.getMemoryInGBs();
        if (this$memoryInGBs == null ? other$memoryInGBs != null : !((Object)this$memoryInGBs).equals(other$memoryInGBs)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ShapeSeries this$shapeSeries = this.getShapeSeries();
        ShapeSeries other$shapeSeries = other.getShapeSeries();
        if (this$shapeSeries == null ? other$shapeSeries != null : !((Object)((Object)this$shapeSeries)).equals((Object)other$shapeSeries)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $coreCount = this.getCoreCount();
        result = result * 59 + ($coreCount == null ? 43 : ((Object)$coreCount).hashCode());
        Integer $memoryInGBs = this.getMemoryInGBs();
        result = result * 59 + ($memoryInGBs == null ? 43 : ((Object)$memoryInGBs).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ShapeSeries $shapeSeries = this.getShapeSeries();
        result = result * 59 + ($shapeSeries == null ? 43 : ((Object)((Object)$shapeSeries)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "JobShapeSummary(name=" + this.getName() + ", coreCount=" + this.getCoreCount() + ", memoryInGBs=" + this.getMemoryInGBs() + ", shapeSeries=" + (Object)((Object)this.getShapeSeries()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"name", "coreCount", "memoryInGBs", "shapeSeries"})
    @Deprecated
    public JobShapeSummary(String name, Integer coreCount, Integer memoryInGBs, ShapeSeries shapeSeries) {
        this.name = name;
        this.coreCount = coreCount;
        this.memoryInGBs = memoryInGBs;
        this.shapeSeries = shapeSeries;
    }

    public static enum ShapeSeries {
        AmdRome("AMD_ROME"),
        IntelSkylake("INTEL_SKYLAKE"),
        NvidiaGpu("NVIDIA_GPU"),
        Legacy("LEGACY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ShapeSeries> map;

        private ShapeSeries(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShapeSeries create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ShapeSeries', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ShapeSeries.class);
            map = new HashMap<String, ShapeSeries>();
            for (ShapeSeries v : ShapeSeries.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="coreCount")
        private Integer coreCount;
        @JsonProperty(value="memoryInGBs")
        private Integer memoryInGBs;
        @JsonProperty(value="shapeSeries")
        private ShapeSeries shapeSeries;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder coreCount(Integer coreCount) {
            this.coreCount = coreCount;
            this.__explicitlySet__.add("coreCount");
            return this;
        }

        public Builder memoryInGBs(Integer memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public Builder shapeSeries(ShapeSeries shapeSeries) {
            this.shapeSeries = shapeSeries;
            this.__explicitlySet__.add("shapeSeries");
            return this;
        }

        public JobShapeSummary build() {
            JobShapeSummary __instance__ = new JobShapeSummary(this.name, this.coreCount, this.memoryInGBs, this.shapeSeries);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(JobShapeSummary o) {
            Builder copiedBuilder = this.name(o.getName()).coreCount(o.getCoreCount()).memoryInGBs(o.getMemoryInGBs()).shapeSeries(o.getShapeSeries());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "JobShapeSummary.Builder(name=" + this.name + ", coreCount=" + this.coreCount + ", memoryInGBs=" + this.memoryInGBs + ", shapeSeries=" + (Object)((Object)this.shapeSeries) + ")";
        }
    }
}

