/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ActivateModelDeploymentRequest
extends BmcRequest<Void> {
    private String modelDeploymentId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"modelDeploymentId", "ifMatch", "opcRequestId"})
    ActivateModelDeploymentRequest(String modelDeploymentId, String ifMatch, String opcRequestId) {
        this.modelDeploymentId = modelDeploymentId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().modelDeploymentId(this.modelDeploymentId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "ActivateModelDeploymentRequest(super=" + super.toString() + ", modelDeploymentId=" + this.getModelDeploymentId() + ", ifMatch=" + this.getIfMatch() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivateModelDeploymentRequest)) {
            return false;
        }
        ActivateModelDeploymentRequest other = (ActivateModelDeploymentRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$modelDeploymentId = this.getModelDeploymentId();
        String other$modelDeploymentId = other.getModelDeploymentId();
        if (this$modelDeploymentId == null ? other$modelDeploymentId != null : !this$modelDeploymentId.equals(other$modelDeploymentId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        if (this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivateModelDeploymentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $modelDeploymentId = this.getModelDeploymentId();
        result = result * 59 + ($modelDeploymentId == null ? 43 : $modelDeploymentId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getModelDeploymentId() {
        return this.modelDeploymentId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ActivateModelDeploymentRequest, Void> {
        private String modelDeploymentId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ActivateModelDeploymentRequest o) {
            this.modelDeploymentId(o.getModelDeploymentId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ActivateModelDeploymentRequest build() {
            ActivateModelDeploymentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder modelDeploymentId(String modelDeploymentId) {
            this.modelDeploymentId = modelDeploymentId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ActivateModelDeploymentRequest buildWithoutInvocationCallback() {
            return new ActivateModelDeploymentRequest(this.modelDeploymentId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "ActivateModelDeploymentRequest.Builder(modelDeploymentId=" + this.modelDeploymentId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

